/*
 * Decompiled with CFR 0.152.
 */
package vibrantjourneys.worldgen;

import java.util.Map;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.IWorldGenerator;
import vibrantjourneys.init.PVJWorldGen;
import vibrantjourneys.util.PVJLootTableList;

public class WorldGenAbandonedFarm
implements IWorldGenerator {
    private int frequency;
    private Biome[] biomes;

    public WorldGenAbandonedFarm(int frequency, Biome ... biomes) {
        this.biomes = biomes;
        this.frequency = frequency;
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        int i;
        int x = chunkX * 16 + 8;
        int z = chunkZ * 16 + 8;
        Biome biome = world.getBiomeForCoordsBody(new BlockPos(x, 0, z));
        for (int id : PVJWorldGen.dimensionBlacklist) {
            if (PVJWorldGen.shouldGenHere(id, world)) continue;
            return;
        }
        boolean isValidBiome = false;
        for (i = 0; i < this.biomes.length; ++i) {
            if (biome != this.biomes[i]) continue;
            isValidBiome = true;
            break;
        }
        if (isValidBiome && world.func_180495_p(new BlockPos(x, world.func_189649_b(x, z) - 1, z)).func_177230_c() == Blocks.field_150349_c) {
            for (i = 0; i < this.frequency; ++i) {
                if (random.nextInt(5000) != 0) continue;
                WorldServer server = DimensionManager.getWorld((int)0);
                TemplateManager manager = server.func_184163_y();
                int id = random.nextInt(4) + 1;
                Template structure = manager.func_189942_b(server.func_73046_m(), new ResourceLocation("pvj", "farm/farm" + id));
                if (structure == null) continue;
                BlockPos pos = new BlockPos(x, world.func_189649_b(x, z) - 1, z);
                Rotation rot = Rotation.values()[random.nextInt(Rotation.values().length)];
                PlacementSettings settings = new PlacementSettings().func_186214_a(Mirror.NONE).func_186220_a(rot).func_186226_b(false);
                structure.func_186253_b(world, pos, settings);
                Map blocks = structure.func_186258_a(pos, settings);
                for (Map.Entry entry : blocks.entrySet()) {
                    if (!((String)entry.getValue()).equals("chest")) continue;
                    BlockPos chestPos = ((BlockPos)entry.getKey()).func_177977_b();
                    TileEntity chest = world.func_175625_s(chestPos);
                    if (chest instanceof TileEntityChest) {
                        ((TileEntityChest)chest).func_189404_a(PVJLootTableList.ABANDONED_FARM, random.nextLong());
                    }
                    world.func_175698_g((BlockPos)entry.getKey());
                }
                break;
            }
        }
    }
}

