/*
 * Decompiled with CFR 0.152.
 */
package vibrantjourneys.worldgen;

import java.util.Random;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;
import vibrantjourneys.init.PVJBlocks;
import vibrantjourneys.init.PVJWorldGen;
import vibrantjourneys.util.PVJConfig;

public class WorldGenBeachGrass
implements IWorldGenerator {
    private int frequency;
    private Biome[] biomes;

    public WorldGenBeachGrass(int frequency, Biome ... biomes) {
        this.biomes = biomes;
        this.frequency = (int)((double)frequency * ((double)PVJConfig.global.overworldPlantsDensity / 100.0));
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        int i;
        Random rand = new Random();
        ChunkPos chunkPos = world.func_72964_e(chunkX, chunkZ).func_76632_l();
        Biome biome = world.getBiomeForCoordsBody(chunkPos.func_180331_a(0, 0, 0));
        for (int id : PVJWorldGen.dimensionBlacklist) {
            if (PVJWorldGen.shouldGenHere(id, world)) continue;
            return;
        }
        if (biome == Biomes.field_150577_O || biome == Biomes.field_150576_N) {
            return;
        }
        boolean isValidBiome = false;
        for (i = 0; i < this.biomes.length; ++i) {
            if (biome != this.biomes[i]) continue;
            isValidBiome = true;
            break;
        }
        if (isValidBiome) {
            for (i = 0; i < this.frequency; ++i) {
                int xPos = rand.nextInt(16) + 8;
                int zPos = rand.nextInt(16) + 8;
                int y = world.func_175645_m(chunkPos.func_180331_a(0, 0, 0).func_177982_a(xPos, 0, zPos)).func_177956_o() + rand.nextInt(10) - rand.nextInt(10);
                BlockPos pos = chunkPos.func_180331_a(0, 0, 0).func_177982_a(xPos, y, zPos);
                for (int j = 0; j < 30; ++j) {
                    BlockPos blockpos = pos.func_177982_a(rand.nextInt(3) - rand.nextInt(3), rand.nextInt(4) - rand.nextInt(4), rand.nextInt(3) - rand.nextInt(3));
                    if (!world.func_175623_d(blockpos) || blockpos.func_177956_o() >= 255 || !PVJBlocks.beach_grass.func_176196_c(world, blockpos) || world.func_180495_p(blockpos.func_177977_b()).func_177230_c() != Blocks.field_150354_m) continue;
                    world.func_180501_a(blockpos, PVJBlocks.beach_grass.func_176223_P(), 2);
                }
            }
        }
    }
}

