/*
 * Decompiled with CFR 0.152.
 */
package vibrantjourneys.worldgen;

import java.util.Arrays;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenBlockBlob;
import net.minecraftforge.fml.common.IWorldGenerator;
import vibrantjourneys.init.PVJWorldGen;

public class WorldGenBoulder
implements IWorldGenerator {
    private int frequency;
    private Biome[] biomes;

    public WorldGenBoulder(int frequency, Biome ... biomes) {
        this.frequency = frequency;
        this.biomes = biomes;
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator generator, IChunkProvider provider) {
        for (int id : PVJWorldGen.dimensionBlacklist) {
            if (PVJWorldGen.shouldGenHere(id, world)) continue;
            return;
        }
        ChunkPos chunkPos = world.func_72964_e(chunkX, chunkZ).func_76632_l();
        Biome biome = world.getBiomeForCoordsBody(chunkPos.func_180331_a(0, 0, 0));
        if (Arrays.asList(this.biomes).contains(biome)) {
            for (int i = 0; i < this.frequency; ++i) {
                if (random.nextInt(50) != 0) continue;
                int xPos = random.nextInt(16) + 8;
                int zPos = random.nextInt(16) + 8;
                int y = world.func_175645_m(chunkPos.func_180331_a(0, 0, 0).func_177982_a(xPos, 0, zPos)).func_177956_o() + random.nextInt(8) - random.nextInt(8);
                BlockPos pos = chunkPos.func_180331_a(0, 0, 0).func_177982_a(xPos, y, zPos);
                new WorldGenBlockBlob(Blocks.field_150348_b, 0).func_180709_b(world, random, pos);
            }
        }
    }
}

