/*
 * Decompiled with CFR 0.152.
 */
package vibrantjourneys.worldgen;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;
import vibrantjourneys.init.PVJWorldGen;
import vibrantjourneys.util.PVJConfig;

public class WorldGenFallenLeaves
implements IWorldGenerator {
    private Block block;
    private int frequency;
    private Biome[] biomes;

    public WorldGenFallenLeaves(Block block, int frequency, Biome ... biomes) {
        this.block = block;
        this.frequency = (int)((double)frequency * ((double)PVJConfig.global.fallenLeavesDensity / 100.0) * ((double)PVJConfig.global.groundcoverDensity / 100.0));
        this.biomes = biomes;
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        int i;
        Random rand = new Random();
        ChunkPos chunkPos = world.func_72964_e(chunkX, chunkZ).func_76632_l();
        for (int id : PVJWorldGen.dimensionBlacklist) {
            if (PVJWorldGen.shouldGenHere(id, world)) continue;
            return;
        }
        Biome biome = world.getBiomeForCoordsBody(chunkPos.func_180331_a(0, 0, 0));
        boolean isValidBiome = false;
        for (i = 0; i < this.biomes.length; ++i) {
            if (biome != this.biomes[i]) continue;
            isValidBiome = true;
            break;
        }
        if (isValidBiome) {
            for (i = 0; i < this.frequency; ++i) {
                int xPos = rand.nextInt(16) + 8;
                int zPos = rand.nextInt(16) + 8;
                int y = world.func_175645_m(chunkPos.func_180331_a(0, 0, 0).func_177982_a(xPos, 0, zPos)).func_177956_o() + rand.nextInt(8) - rand.nextInt(8);
                BlockPos pos = chunkPos.func_180331_a(0, 0, 0).func_177982_a(xPos, y, zPos);
                if (!world.isSideSolid(pos.func_177977_b(), EnumFacing.UP)) continue;
                IBlockState state = world.func_180495_p(pos);
                if (!world.func_175623_d(pos) && !world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)world, pos) || state.func_185904_a() == Material.field_151586_h || y <= 60 && (y >= 60 || !world.func_175678_i(pos))) continue;
                world.func_175656_a(pos, this.block.func_176223_P());
            }
        }
    }
}

