/*
 * Decompiled with CFR 0.152.
 */
package vibrantjourneys.worldgen;

import java.util.Arrays;
import java.util.Random;
import net.minecraft.block.properties.IProperty;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;
import vibrantjourneys.blocks.plant.BlockBracketFungus;
import vibrantjourneys.init.PVJBlocks;
import vibrantjourneys.init.PVJWorldGen;
import vibrantjourneys.util.PVJConfig;

public class WorldGenFlouropore
implements IWorldGenerator {
    private int frequency;
    private Biome[] biomes;

    public WorldGenFlouropore(int frequency, Biome ... biomes) {
        this.frequency = (int)((double)frequency * ((double)PVJConfig.global.overworldPlantsDensity / 100.0));
        this.biomes = biomes;
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator generator, IChunkProvider provider) {
        int x = chunkX * 16 + 8;
        int z = chunkZ * 16 + 8;
        for (int id : PVJWorldGen.dimensionBlacklist) {
            if (PVJWorldGen.shouldGenHere(id, world)) continue;
            return;
        }
        Biome biome = world.getBiomeForCoordsBody(new BlockPos(x, 0, z));
        if (Arrays.asList(this.biomes).contains(biome)) {
            for (int i = 0; i < this.frequency; ++i) {
                int xPos = x + random.nextInt(16);
                int zPos = z + random.nextInt(16);
                int yPos = 1 + random.nextInt(40);
                BlockPos pos = new BlockPos(xPos, yPos, zPos);
                Random rand = new Random();
                EnumFacing facing = EnumFacing.Plane.HORIZONTAL.func_179518_a(rand);
                if (!world.func_175665_u(pos) || !world.func_175623_d(pos.func_177972_a(facing))) continue;
                world.func_175656_a(pos.func_177972_a(facing), PVJBlocks.flouropore.func_176223_P().func_177226_a((IProperty)BlockBracketFungus.field_185512_D, (Comparable)facing));
            }
        }
    }
}

