/*
 * Decompiled with CFR 0.152.
 */
package vibrantjourneys.worldgen;

import com.google.common.base.Predicate;
import java.util.Arrays;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.fml.common.IWorldGenerator;
import vibrantjourneys.init.PVJBlocks;
import vibrantjourneys.init.PVJWorldGen;

public class WorldGenMud
implements IWorldGenerator {
    private WorldGenMinable mudGen = new WorldGenMinable(PVJBlocks.mud.func_176223_P(), 12, (Predicate)new DirtPredicate());
    private int maxHeight = 70;
    private int frequency;
    private Biome[] biomes;

    public WorldGenMud(int frequency, Biome ... biomes) {
        this.frequency = frequency;
        this.biomes = biomes;
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        Random rand = new Random();
        int x = chunkX * 16 + 8;
        int z = chunkZ * 16 + 8;
        for (int id : PVJWorldGen.dimensionBlacklist) {
            if (PVJWorldGen.shouldGenHere(id, world)) continue;
            return;
        }
        Biome biome = world.getBiomeForCoordsBody(new BlockPos(x, 0, z));
        if (Arrays.asList(this.biomes).contains(biome)) {
            for (int i = 0; i < this.frequency; ++i) {
                int xPos = x + rand.nextInt(8);
                int yPos = 55 + rand.nextInt(this.maxHeight);
                int zPos = z + rand.nextInt(8);
                this.mudGen.func_180709_b(world, rand, new BlockPos(xPos, yPos, zPos));
            }
        }
    }

    static class DirtPredicate
    implements Predicate<IBlockState> {
        private DirtPredicate() {
        }

        public boolean apply(IBlockState state) {
            return state != null && (state.func_177230_c() == Blocks.field_150346_d || state.func_177230_c() == Blocks.field_150349_c);
        }
    }
}

