/*
 * Decompiled with CFR 0.152.
 */
package vibrantjourneys.worldgen;

import java.util.Random;
import net.minecraft.block.BlockStone;
import net.minecraft.block.BlockVine;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;
import vibrantjourneys.init.PVJWorldGen;

public class WorldGenOvergrownCaves
implements IWorldGenerator {
    private Biome[] biomes;

    public WorldGenOvergrownCaves(Biome ... biomes) {
        this.biomes = biomes;
    }

    public void generate(Random rand, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        Random random = new Random();
        if (world.field_73011_w.func_186058_p() != DimensionType.OVERWORLD && world.field_73011_w.func_186058_p() != DimensionType.NETHER) {
            return;
        }
        for (int id : PVJWorldGen.dimensionBlacklist) {
            if (PVJWorldGen.shouldGenHere(id, world)) continue;
            return;
        }
        int x = chunkX * 16 + 8;
        int z = chunkZ * 16 + 8;
        Biome biome = world.getBiomeForCoordsBody(new BlockPos(x, 0, z));
        boolean isValidBiome = false;
        for (int i = 0; i < this.biomes.length; ++i) {
            if (biome != this.biomes[i]) continue;
            isValidBiome = true;
            break;
        }
        if (isValidBiome) {
            int y = 30;
            block2: for (BlockPos position : BlockPos.func_191531_b((int)(x - 6), (int)(y - 28), (int)(z - 6), (int)(x + 6), (int)(y + 40), (int)(z + 6))) {
                if (world.func_175678_i(position) || !(world.func_180495_p(position).func_177230_c() instanceof BlockStone)) continue;
                for (EnumFacing facing : EnumFacing.field_82609_l) {
                    if (!world.func_175623_d(position.func_177972_a(facing)) || random.nextInt(9) >= 3 || facing == EnumFacing.UP) continue;
                    world.func_175656_a(position.func_177972_a(facing), Blocks.field_150395_bd.func_176223_P().func_177226_a((IProperty)BlockVine.func_176267_a((EnumFacing)facing.func_176734_d()), (Comparable)Boolean.valueOf(true)));
                    continue block2;
                }
            }
        }
    }
}

