/*
 * Decompiled with CFR 0.152.
 */
package vibrantjourneys.worldgen;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;
import vibrantjourneys.init.PVJWorldGen;
import vibrantjourneys.util.PVJConfig;
import vibrantjourneys.worldgen.feature.WorldGenPlant;

public class WorldGenPVJPlant
implements IWorldGenerator {
    public static final int OVERWORLD = 0;
    public static final int NETHER = -1;
    public static final int END = 1;
    private int frequency;
    private Biome[] biomes;
    private WorldGenPlant plant_gen;

    public WorldGenPVJPlant(Block block, int frequency, Biome ... biomes) {
        this(block, frequency, 0, biomes);
    }

    public WorldGenPVJPlant(Block block, int frequency, int dimension, Biome ... biomes) {
        this.biomes = biomes;
        this.plant_gen = new WorldGenPlant(block);
        if (dimension == -1) {
            this.frequency = (int)((double)frequency * ((double)PVJConfig.global.netherPlantsDensity / 100.0));
        }
        this.frequency = dimension == 1 ? (int)((double)frequency * ((double)PVJConfig.global.endPlantsDensity / 100.0)) : (int)((double)frequency * ((double)PVJConfig.global.overworldPlantsDensity / 100.0));
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        int i;
        Random rand = new Random();
        int x = chunkX * 16 + 8;
        int z = chunkZ * 16 + 8;
        for (int id : PVJWorldGen.dimensionBlacklist) {
            if (PVJWorldGen.shouldGenHere(id, world)) continue;
            return;
        }
        Biome biome = world.getBiomeForCoordsBody(new BlockPos(x, 0, z));
        boolean isValidBiome = false;
        for (i = 0; i < this.biomes.length; ++i) {
            if (biome != this.biomes[i]) continue;
            isValidBiome = true;
            break;
        }
        if (isValidBiome) {
            for (i = 0; i < this.frequency; ++i) {
                ChunkPos chunkPos = world.func_72964_e(chunkX, chunkZ).func_76632_l();
                int xPos = rand.nextInt(16) + 8;
                int zPos = rand.nextInt(16) + 8;
                int y = rand.nextInt(world.func_175645_m(chunkPos.func_180331_a(0, 0, 0).func_177982_a(xPos, 0, zPos)).func_177956_o() + 32);
                BlockPos pos = chunkPos.func_180331_a(0, 0, 0).func_177982_a(xPos, y, zPos);
                this.plant_gen.func_180709_b(world, rand, pos);
            }
        }
    }
}

