/*
 * Decompiled with CFR 0.152.
 */
package vibrantjourneys.worldgen;

import java.util.Arrays;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.fml.common.IWorldGenerator;
import vibrantjourneys.init.PVJWorldGen;
import vibrantjourneys.util.PVJConfig;

public class WorldGenRocks
implements IWorldGenerator {
    private WorldGenMinable rockGen;
    private int maxHeight;
    private int frequency;
    private Biome[] biomes;

    public WorldGenRocks(Block stone, int count, int maxHeight, int frequency, Biome ... biomes) {
        this.rockGen = new WorldGenMinable(stone.func_176223_P(), count);
        this.maxHeight = maxHeight;
        this.frequency = (int)((double)frequency * ((double)PVJConfig.global.stoneDepositsDensity / 100.0));
        this.biomes = biomes;
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        Random rand = new Random();
        int x = chunkX * 16 + 8;
        int z = chunkZ * 16 + 8;
        for (int id : PVJWorldGen.dimensionBlacklist) {
            if (PVJWorldGen.shouldGenHere(id, world)) continue;
            return;
        }
        Biome biome = world.getBiomeForCoordsBody(new BlockPos(x, 0, z));
        if (Arrays.asList(this.biomes).contains(biome)) {
            for (int i = 0; i < this.frequency; ++i) {
                int xPos = x + rand.nextInt(8);
                int yPos = 1 + rand.nextInt(this.maxHeight);
                int zPos = z + rand.nextInt(8);
                this.rockGen.func_180709_b(world, rand, new BlockPos(xPos, yPos, zPos));
            }
        }
    }
}

