/*
 * Decompiled with CFR 0.152.
 */
package vibrantjourneys.worldgen;

import java.util.Map;
import java.util.Random;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.IWorldGenerator;
import vibrantjourneys.init.PVJWorldGen;
import vibrantjourneys.util.PVJLootTableList;

public class WorldGenRuins
implements IWorldGenerator {
    private int frequency;
    private Biome[] biomes;

    public WorldGenRuins(int frequency, Biome ... biomes) {
        this.biomes = biomes;
        this.frequency = frequency;
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        int i;
        int x = chunkX * 16 + 8;
        int z = chunkZ * 16 + 8;
        Biome biome = world.getBiomeForCoordsBody(new BlockPos(x, 0, z));
        for (int id : PVJWorldGen.dimensionBlacklist) {
            if (PVJWorldGen.shouldGenHere(id, world)) continue;
            return;
        }
        boolean isValidBiome = false;
        for (i = 0; i < this.biomes.length; ++i) {
            if (biome != this.biomes[i]) continue;
            isValidBiome = true;
            break;
        }
        if (isValidBiome && world.func_180495_p(new BlockPos(x, world.func_189649_b(x, z) - 1, z)).func_177230_c() == Blocks.field_150349_c) {
            for (i = 0; i < this.frequency; ++i) {
                Template structure;
                if (random.nextInt(5300) != 0) continue;
                WorldServer server = DimensionManager.getWorld((int)0);
                TemplateManager manager = server.func_184163_y();
                int id = 1;
                if (random.nextBoolean()) {
                    id = biome == Biomes.field_150583_P || biome == Biomes.field_150582_Q || biome == Biomes.field_185448_Z || biome == Biomes.field_185429_aa ? 3 : 2;
                }
                if ((structure = manager.func_189942_b(server.func_73046_m(), new ResourceLocation("pvj", "ruins/ruins" + id))) == null) continue;
                int yOffset = id == 3 ? 1 : 0;
                BlockPos pos = new BlockPos(x, world.func_189649_b(x, z) - yOffset, z);
                Rotation rot = Rotation.values()[random.nextInt(Rotation.values().length)];
                PlacementSettings settings = new PlacementSettings().func_186214_a(Mirror.NONE).func_186220_a(rot).func_186226_b(false);
                structure.func_186253_b(world, pos, settings);
                System.out.println(pos);
                Map blocks = structure.func_186258_a(pos, settings);
                for (Map.Entry entry : blocks.entrySet()) {
                    if (((String)entry.getValue()).equals("chest")) {
                        BlockPos chestPos = ((BlockPos)entry.getKey()).func_177977_b();
                        TileEntity chest = world.func_175625_s(chestPos);
                        if (chest instanceof TileEntityChest) {
                            ((TileEntityChest)chest).func_189404_a(PVJLootTableList.RUINS, random.nextLong());
                        }
                        world.func_175698_g((BlockPos)entry.getKey());
                    }
                    if (!((String)entry.getValue()).equals("support")) continue;
                    BlockPos supportPos = (BlockPos)entry.getKey();
                    world.func_175698_g(supportPos);
                    IBlockState state = this.getSupportBlock(id);
                    while (this.canReplace(world, supportPos)) {
                        world.func_180501_a(supportPos, state, 2);
                        supportPos = supportPos.func_177977_b();
                    }
                }
                break;
            }
        }
    }

    public IBlockState getSupportBlock(int id) {
        switch (id) {
            default: {
                return Blocks.field_150347_e.func_176223_P();
            }
            case 2: {
                return Blocks.field_150344_f.func_176223_P();
            }
            case 3: 
        }
        return Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.BIRCH);
    }

    public boolean canReplace(World world, BlockPos pos) {
        if (world.func_175623_d(pos)) {
            return true;
        }
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c().func_176200_f((IBlockAccess)world, pos)) {
            return true;
        }
        if (state.func_177230_c().isLeaves(state, (IBlockAccess)world, pos)) {
            return true;
        }
        return state.func_185904_a() == Material.field_151586_h;
    }
}

