/*
 * Decompiled with CFR 0.152.
 */
package vibrantjourneys.worldgen;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;
import vibrantjourneys.blocks.plant.BlockShortGrass;
import vibrantjourneys.init.PVJWorldGen;

public class WorldGenShortGrass
implements IWorldGenerator {
    private Block block;
    private int frequency;
    private Biome[] biomes;

    public WorldGenShortGrass(Block block, int frequency, Biome ... biomes) {
        this.block = block;
        this.frequency = frequency;
        this.biomes = biomes;
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (world.field_73011_w.func_186058_p() != DimensionType.OVERWORLD && world.field_73011_w.func_186058_p() != DimensionType.NETHER) {
            return;
        }
        int x = chunkX * 16 + 8;
        int z = chunkZ * 16 + 8;
        for (int id : PVJWorldGen.dimensionBlacklist) {
            if (PVJWorldGen.shouldGenHere(id, world)) continue;
            return;
        }
        Biome biome = world.getBiomeForCoordsBody(new BlockPos(x, 0, z));
        boolean isValidBiome = false;
        for (int i = 0; i < this.biomes.length; ++i) {
            if (biome != this.biomes[i]) continue;
            isValidBiome = true;
            break;
        }
        if (isValidBiome) {
            BlockPos pos = world.func_175672_r(new BlockPos(x, 0, z));
            int xPos = pos.func_177958_n();
            int yPos = pos.func_177956_o();
            int zPos = pos.func_177952_p();
            for (BlockPos position : BlockPos.func_177975_b((BlockPos)new BlockPos(xPos - 7, yPos - 40, zPos - 7), (BlockPos)new BlockPos(xPos + 7, yPos + 40, zPos + 7))) {
                IBlockState state = world.func_180495_p(position);
                if (!(state.func_177230_c() instanceof BlockTallGrass) || state.func_177229_b((IProperty)BlockTallGrass.field_176497_a) != BlockTallGrass.EnumType.GRASS || random.nextInt(8) >= this.frequency) continue;
                int model = random.nextInt(7);
                world.func_175656_a(position, this.block.func_176223_P().func_177226_a((IProperty)BlockShortGrass.MODEL, (Comparable)Integer.valueOf(model)));
            }
        }
    }
}

