/*
 * Decompiled with CFR 0.152.
 */
package vibrantjourneys.worldgen;

import java.util.Random;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.common.IWorldGenerator;
import vibrantjourneys.init.PVJWorldGen;

public class WorldGenSmallBush
implements IWorldGenerator {
    private int frequency;
    private Biome[] biomes;

    public WorldGenSmallBush(int frequency, Biome ... biomes) {
        this.frequency = frequency;
        this.biomes = biomes;
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        int i;
        for (int id : PVJWorldGen.dimensionBlacklist) {
            if (PVJWorldGen.shouldGenHere(id, world)) continue;
            return;
        }
        ChunkPos chunkPos = world.func_72964_e(chunkX, chunkZ).func_76632_l();
        Biome biome = world.getBiomeForCoordsBody(chunkPos.func_180331_a(0, 0, 0));
        boolean isValidBiome = false;
        for (i = 0; i < this.biomes.length; ++i) {
            if (biome != this.biomes[i]) continue;
            isValidBiome = true;
            break;
        }
        if (isValidBiome) {
            for (i = 0; i < this.frequency; ++i) {
                IBlockState soil;
                int xPos = random.nextInt(16) + 8;
                int zPos = random.nextInt(16) + 8;
                int y = world.func_175645_m(chunkPos.func_180331_a(0, 0, 0).func_177982_a(xPos, 0, zPos)).func_177956_o() + random.nextInt(4) - random.nextInt(4);
                BlockPos pos = chunkPos.func_180331_a(0, 0, 0).func_177982_a(xPos, y, zPos);
                if (!world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)world, pos) || !(soil = world.func_180495_p(pos.func_177977_b())).func_177230_c().canSustainPlant(soil, (IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP, (IPlantable)((BlockSapling)Blocks.field_150345_g))) continue;
                world.func_175656_a(pos, Blocks.field_150364_r.func_176223_P());
                for (EnumFacing facing : EnumFacing.field_176754_o) {
                    BlockPos temp = pos.func_177972_a(facing);
                    if (!world.func_180495_p(temp).func_177230_c().func_176200_f((IBlockAccess)world, temp)) continue;
                    world.func_175656_a(temp, Blocks.field_150362_t.func_176223_P());
                }
                if (!world.func_180495_p(pos.func_177984_a()).func_177230_c().func_176200_f((IBlockAccess)world, pos.func_177984_a())) continue;
                world.func_175656_a(pos.func_177984_a(), Blocks.field_150362_t.func_176223_P());
            }
        }
    }
}

