/*
 * Decompiled with CFR 0.152.
 */
package vibrantjourneys.worldgen;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;
import vibrantjourneys.blocks.BlockRockFormation;
import vibrantjourneys.init.PVJWorldGen;

public class WorldGenStalagmite
implements IWorldGenerator {
    private Block block;
    private int minY;
    private int maxY;
    private int frequency;
    private Biome[] biomes;

    public WorldGenStalagmite(Block block, int minY, int maxY, int frequency, Biome ... biomes) {
        this.block = block;
        this.minY = minY;
        this.maxY = maxY;
        this.frequency = frequency;
        this.biomes = biomes;
    }

    public void generate(Random rand, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        int i;
        Random random = new Random();
        if (world.field_73011_w.func_186058_p() != DimensionType.OVERWORLD && world.field_73011_w.func_186058_p() != DimensionType.NETHER) {
            return;
        }
        int x = chunkX * 16 + 8;
        int z = chunkZ * 16 + 8;
        for (int id : PVJWorldGen.dimensionBlacklist) {
            if (PVJWorldGen.shouldGenHere(id, world)) continue;
            return;
        }
        Biome biome = world.getBiomeForCoordsBody(new BlockPos(x, 0, z));
        boolean isValidBiome = false;
        for (i = 0; i < this.biomes.length; ++i) {
            if (biome != this.biomes[i]) continue;
            isValidBiome = true;
            break;
        }
        if (isValidBiome) {
            for (i = 0; i < this.frequency; ++i) {
                Block down;
                int xPos = x + random.nextInt(8) - random.nextInt(8);
                int zPos = z + random.nextInt(8) - random.nextInt(8);
                int yPos = this.minY + random.nextInt(this.maxY - this.minY + 1);
                BlockPos pos = new BlockPos(xPos, yPos, zPos);
                if (world.func_175678_i(pos.func_177977_b())) {
                    return;
                }
                boolean flag = false;
                for (int h = pos.func_177956_o() + 1; h < 256; ++h) {
                    if (world.func_175623_d(pos.func_177981_b(h))) continue;
                    flag = true;
                }
                if (!flag || !BlockRockFormation.VALID_SPAWN_BLOCKS.contains(down = world.func_180495_p(pos.func_177977_b()).func_177230_c()) || !world.isSideSolid(pos.func_177977_b(), EnumFacing.UP)) continue;
                for (int size = 0; size < 3 && world.func_175623_d(pos.func_177981_b(size)); ++size) {
                    world.func_175656_a(pos.func_177981_b(size), this.block.func_176223_P().func_177226_a((IProperty)BlockRockFormation.SIZE, (Comparable)Integer.valueOf(size)));
                }
            }
        }
    }
}

