/*
 * Decompiled with CFR 0.152.
 */
package vibrantjourneys.worldgen.feature;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.BlockHardenedClay;
import net.minecraft.block.BlockSand;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.common.IPlantable;
import vibrantjourneys.init.PVJBlocks;
import vibrantjourneys.util.EnumLeafType;
import vibrantjourneys.util.EnumWoodType;

public class WorldGenCherryBlossomTree
extends WorldGenAbstractTree {
    private IBlockState LOG = PVJBlocks.LOGS.get(EnumWoodType.CHERRY_BLOSSOM.getID()).func_176223_P();
    private IBlockState LEAVES = PVJBlocks.LEAVES.get(EnumLeafType.WHITE_CHERRY_BLOSSOM.getID()).func_176223_P();

    public WorldGenCherryBlossomTree(boolean notify, boolean isPink) {
        super(notify);
        if (isPink) {
            this.LEAVES = PVJBlocks.LEAVES.get(EnumLeafType.PINK_CHERRY_BLOSSOM.getID()).func_176223_P();
        }
    }

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        int i = rand.nextInt(4) + 5;
        while (world.func_180495_p(pos.func_177977_b()).func_185904_a() == Material.field_151586_h) {
            pos = pos.func_177977_b();
        }
        boolean flag = true;
        if (pos.func_177956_o() >= 1 && pos.func_177956_o() + i + 1 <= 256) {
            for (int j = pos.func_177956_o(); j <= pos.func_177956_o() + 1 + i; ++j) {
                int k = 1;
                if (j == pos.func_177956_o()) {
                    k = 0;
                }
                if (j >= pos.func_177956_o() + 1 + i - 2) {
                    k = 3;
                }
                BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                for (int l = pos.func_177958_n() - k; l <= pos.func_177958_n() + k && flag; ++l) {
                    for (int i1 = pos.func_177952_p() - k; i1 <= pos.func_177952_p() + k && flag; ++i1) {
                        if (j >= 0 && j < 256) {
                            IBlockState iblockstate = world.func_180495_p((BlockPos)blockpos$mutableblockpos.func_181079_c(l, j, i1));
                            if (iblockstate.func_177230_c().isAir(iblockstate, (IBlockAccess)world, (BlockPos)blockpos$mutableblockpos.func_181079_c(l, j, i1)) || iblockstate.func_177230_c().isLeaves(iblockstate, (IBlockAccess)world, (BlockPos)blockpos$mutableblockpos.func_181079_c(l, j, i1))) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
        }
        if (!flag) {
            return false;
        }
        BlockPos down = pos.func_177977_b();
        IBlockState state = world.func_180495_p(down);
        boolean isSoil = state.func_177230_c().canSustainPlant(state, (IBlockAccess)world, down, EnumFacing.UP, (IPlantable)Blocks.field_150345_g) || state.func_177230_c() instanceof BlockSand || state.func_177230_c() instanceof BlockHardenedClay;
        ArrayList<EnumFacing> facings = new ArrayList<EnumFacing>();
        int baseHeight = 10 + rand.nextInt(6);
        if (isSoil && pos.func_177956_o() < world.func_72800_K() - baseHeight - 1) {
            int branchStart = 5 + rand.nextInt(3);
            for (int height = 0; height < baseHeight; ++height) {
                facings.clear();
                BlockPos logPos = pos.func_177981_b(height);
                if (this.canPlaceLog(world.func_180495_p(logPos), world, logPos)) {
                    world.func_175656_a(logPos, this.LOG);
                }
                if (height <= branchStart || height % 2 != 0) continue;
                int branchCount = rand.nextInt(3) + 1;
                for (int b = 0; b < branchCount; ++b) {
                    int length = 2 + rand.nextInt(6);
                    if (height >= 10) {
                        length -= (int)(0.3 * (double)height - 1.0);
                    }
                    EnumFacing facing = EnumFacing.Plane.HORIZONTAL.func_179518_a(rand);
                    while (facings.contains(facing)) {
                        facing = EnumFacing.Plane.HORIZONTAL.func_179518_a(rand);
                    }
                    facings.add(facing);
                    BlockPos branchPos = new BlockPos((Vec3i)logPos);
                    for (int q = 1; q <= length; ++q) {
                        EnumFacing temp;
                        BlockPos tempPos;
                        branchPos = branchPos.func_177972_a(facing);
                        if (q > 1) {
                            if (rand.nextBoolean()) {
                                branchPos = branchPos.func_177972_a(EnumFacing.Plane.HORIZONTAL.func_179518_a(rand));
                            }
                            if (rand.nextBoolean()) {
                                branchPos = branchPos.func_177984_a();
                            }
                        }
                        if (!this.canPlaceLog(world.func_180495_p(branchPos), world, branchPos)) continue;
                        world.func_175656_a(branchPos, this.LOG);
                        this.genLeaves(world, branchPos, rand);
                        if (rand.nextInt(3) != 0 || !this.canPlaceLog(world.func_180495_p(tempPos = branchPos.func_177972_a(temp = EnumFacing.Plane.HORIZONTAL.func_179518_a(rand))), world, tempPos)) continue;
                        world.func_175656_a(tempPos, this.LOG);
                        this.genLeaves(world, tempPos, rand);
                    }
                }
            }
        }
        return true;
    }

    public void genLeaves(World world, BlockPos pos, Random rand) {
        for (int x = -2; x <= 2; ++x) {
            for (int y = -1; y <= 2; ++y) {
                for (int z = -2; z <= 2; ++z) {
                    BlockPos tempPos;
                    BlockPos leafPos = pos.func_177982_a(x, y, z);
                    if (!world.func_175623_d(leafPos)) continue;
                    if (Math.abs(x) == 2 || Math.abs(y) == 2 || Math.abs(z) == 2) {
                        if (rand.nextInt(16) <= 5) {
                            boolean shouldGenLeaves = false;
                            for (EnumFacing facing : EnumFacing.field_82609_l) {
                                IBlockState state = world.func_180495_p(leafPos.func_177972_a(facing));
                                if (!state.func_177230_c().isLeaves(state, (IBlockAccess)world, leafPos.func_177972_a(facing))) continue;
                                shouldGenLeaves = true;
                                break;
                            }
                            if (shouldGenLeaves) {
                                if (Math.abs(x) == Math.abs(z)) {
                                    if (rand.nextInt(4) == 0) {
                                        world.func_175656_a(leafPos, this.LEAVES);
                                    }
                                } else {
                                    world.func_175656_a(leafPos, this.LEAVES);
                                }
                            }
                        }
                    } else {
                        world.func_175656_a(leafPos, this.LEAVES);
                    }
                    if (rand.nextInt(8) >= 2 || !world.func_175623_d(tempPos = leafPos.func_177977_b())) continue;
                    world.func_175656_a(tempPos, this.LEAVES);
                }
            }
        }
    }

    public boolean canPlaceLog(IBlockState state, World world, BlockPos pos) {
        return state.func_177230_c().isAir(state, (IBlockAccess)world, pos) || state.func_177230_c().isLeaves(state, (IBlockAccess)world, pos);
    }
}

