/*
 * Decompiled with CFR 0.152.
 */
package vibrantjourneys.worldgen.feature;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHardenedClay;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockSand;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.common.IPlantable;
import vibrantjourneys.init.PVJBlocks;
import vibrantjourneys.util.EnumLeafType;
import vibrantjourneys.util.EnumWoodType;

public class WorldGenJuniperTree
extends WorldGenAbstractTree {
    private static final IBlockState LOG = PVJBlocks.LOGS.get(EnumWoodType.JUNIPER.getID()).func_176223_P();
    private static final IBlockState LEAVES = PVJBlocks.LEAVES.get(EnumLeafType.JUNIPER.getID()).func_176223_P();
    private static final IBlockState LEAVES_BERRIED = PVJBlocks.LEAVES.get(EnumLeafType.JUNIPER_BERRIED.getID()).func_176223_P();

    public WorldGenJuniperTree(boolean notify) {
        super(notify);
    }

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        int i = rand.nextInt(4) + 5;
        while (world.func_180495_p(pos.func_177977_b()).func_185904_a() == Material.field_151586_h) {
            pos = pos.func_177977_b();
        }
        boolean flag = true;
        if (pos.func_177956_o() >= 1 && pos.func_177956_o() + i + 1 <= 256) {
            for (int j = pos.func_177956_o(); j <= pos.func_177956_o() + 1 + i; ++j) {
                int k = 1;
                if (j == pos.func_177956_o()) {
                    k = 0;
                }
                if (j >= pos.func_177956_o() + 1 + i - 2) {
                    k = 3;
                }
                BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                for (int l = pos.func_177958_n() - k; l <= pos.func_177958_n() + k && flag; ++l) {
                    for (int i1 = pos.func_177952_p() - k; i1 <= pos.func_177952_p() + k && flag; ++i1) {
                        if (j >= 0 && j < 256) {
                            IBlockState iblockstate = world.func_180495_p((BlockPos)blockpos$mutableblockpos.func_181079_c(l, j, i1));
                            Block block = iblockstate.func_177230_c();
                            if (iblockstate.func_177230_c().isAir(iblockstate, (IBlockAccess)world, (BlockPos)blockpos$mutableblockpos.func_181079_c(l, j, i1)) || iblockstate.func_177230_c().isLeaves(iblockstate, (IBlockAccess)world, (BlockPos)blockpos$mutableblockpos.func_181079_c(l, j, i1))) continue;
                            if (block != Blocks.field_150355_j && block != Blocks.field_150358_i) {
                                flag = false;
                                continue;
                            }
                            if (j <= pos.func_177956_o()) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
        }
        if (!flag) {
            return false;
        }
        BlockPos down = pos.func_177977_b();
        IBlockState state = world.func_180495_p(down);
        boolean isSoil = state.func_177230_c().canSustainPlant(state, (IBlockAccess)world, down, EnumFacing.UP, (IPlantable)Blocks.field_150345_g) || state.func_177230_c() instanceof BlockSand || state.func_177230_c() instanceof BlockHardenedClay;
        int baseHeight = 3 + rand.nextInt(4);
        EnumFacing facing = EnumFacing.Plane.HORIZONTAL.func_179518_a(rand);
        if (isSoil && pos.func_177956_o() < world.func_72800_K() - baseHeight - 1) {
            state = world.func_180495_p(pos);
            if (this.canGenerateLogAt(state, world, pos)) {
                this.func_175903_a(world, pos, LOG);
            }
            if (this.canGenerateLogAt(state = world.func_180495_p(pos.func_177984_a()), world, pos.func_177984_a())) {
                this.func_175903_a(world, pos.func_177984_a(), LOG);
            }
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            BlockPos shamalamadingdong = new BlockPos(x, y, z);
            for (int h = 0; h <= baseHeight; ++h) {
                BlockPos logpos;
                if (rand.nextInt(12) < 5) {
                    x += facing.func_82601_c();
                    z += facing.func_82599_e();
                }
                if (rand.nextInt(6) < 5) {
                    ++y;
                }
                if ((state = world.func_180495_p(logpos = new BlockPos(x, y, z))).func_177230_c().isAir(state, (IBlockAccess)world, logpos) || state.func_177230_c().isLeaves(state, (IBlockAccess)world, logpos)) {
                    this.func_175903_a(world, logpos, LOG);
                    if (rand.nextInt(6) == 0 && ((state = world.func_180495_p(logpos.func_177977_b())).func_177230_c().isAir(state, (IBlockAccess)world, logpos.func_177977_b()) || state.func_177230_c().isLeaves(state, (IBlockAccess)world, logpos.func_177977_b()))) {
                        this.func_175903_a(world, logpos.func_177977_b(), LOG);
                    }
                }
                shamalamadingdong = logpos;
            }
            this.generateBranches(world, rand, shamalamadingdong);
        }
        return true;
    }

    private void generateBranches(World world, Random rand, BlockPos pos) {
        int numBranches = 2;
        EnumFacing facing = EnumFacing.Plane.HORIZONTAL.func_179518_a(rand);
        for (int i = 0; i <= numBranches; ++i) {
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            EnumFacing temp = EnumFacing.Plane.HORIZONTAL.func_179518_a(rand);
            if (!facing.func_176743_c().equals((Object)temp.func_176743_c())) {
                facing = temp;
            }
            int length = rand.nextInt(2) + 2;
            IBlockState state = world.func_180495_p(pos);
            for (int h = 0; h <= length; ++h) {
                BlockPos logpos;
                x += facing.func_82601_c();
                z += facing.func_82599_e();
                if (rand.nextInt(4) < 2) {
                    ++y;
                }
                if ((state = world.func_180495_p(logpos = new BlockPos(x, y, z))).func_177230_c().isAir(state, (IBlockAccess)world, logpos) || state.func_177230_c().isLeaves(state, (IBlockAccess)world, logpos)) {
                    this.func_175903_a(world, logpos, LOG);
                    if (rand.nextInt(2) == 0 && ((state = world.func_180495_p(logpos.func_177977_b())).func_177230_c().isAir(state, (IBlockAccess)world, logpos.func_177977_b()) || state.func_177230_c().isLeaves(state, (IBlockAccess)world, logpos.func_177977_b()))) {
                        this.func_175903_a(world, logpos.func_177977_b(), LOG);
                    }
                }
                for (int up = -rand.nextInt(2); up <= rand.nextInt(2) + 1; ++up) {
                    for (int west = -rand.nextInt(2); west <= rand.nextInt(2) + 1; ++west) {
                        for (int north = -rand.nextInt(2); north <= rand.nextInt(2) + 1; ++north) {
                            BlockPos leafpos = logpos.func_177981_b(up).func_177985_f(west).func_177964_d(north);
                            state = world.func_180495_p(leafpos);
                            if (!state.func_177230_c().isAir(state, (IBlockAccess)world, leafpos) && !state.func_177230_c().isLeaves(state, (IBlockAccess)world, leafpos)) continue;
                            if (Math.abs(up) == 2 && Math.abs(west) == 2 && Math.abs(north) == 2) {
                                for (EnumFacing facing2 : EnumFacing.field_82609_l) {
                                    if (!(world.func_180495_p(leafpos.func_177972_a(facing2)) instanceof BlockLeaves) || rand.nextInt(9) >= 3) continue;
                                    if (rand.nextInt(9) == 0) {
                                        this.func_175903_a(world, leafpos, LEAVES_BERRIED);
                                        continue;
                                    }
                                    this.func_175903_a(world, leafpos, LEAVES);
                                }
                                continue;
                            }
                            if (rand.nextInt(9) >= 3) continue;
                            if (rand.nextInt(9) == 0) {
                                this.func_175903_a(world, leafpos, LEAVES_BERRIED);
                                continue;
                            }
                            this.func_175903_a(world, leafpos, LEAVES);
                        }
                    }
                }
            }
        }
    }

    public boolean canGenerateLogAt(IBlockState state, World world, BlockPos pos) {
        return state.func_177230_c().isAir(state, (IBlockAccess)world, pos) || state.func_177230_c().isLeaves(state, (IBlockAccess)world, pos);
    }
}

