/*
 * Decompiled with CFR 0.152.
 */
package vibrantjourneys.worldgen.feature;

import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.common.IPlantable;
import vibrantjourneys.blocks.wood.BlockPVJSapling;
import vibrantjourneys.init.PVJBlocks;
import vibrantjourneys.util.EnumLeafType;
import vibrantjourneys.util.EnumWoodType;

public class WorldGenMangroveTree
extends WorldGenAbstractTree {
    private static final IBlockState LOG = PVJBlocks.LOGS.get(EnumWoodType.MANGROVE.getID()).func_176223_P();
    private static final IBlockState LEAVES = PVJBlocks.LEAVES.get(EnumLeafType.MANGROVE.getID()).func_176223_P();

    public WorldGenMangroveTree() {
        super(false);
    }

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        int height = 6 + rand.nextInt(3);
        boolean flag = true;
        if (pos.func_177956_o() >= 1 && pos.func_177956_o() + height + 1 <= 256) {
            boolean isSoil;
            for (int j = pos.func_177956_o(); j <= pos.func_177956_o() + 1 + height; ++j) {
                int k = 1;
                if (j == pos.func_177956_o()) {
                    k = 0;
                }
                if (j >= pos.func_177956_o() + 1 + height - 2) {
                    k = 2;
                }
                BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                for (int l = pos.func_177958_n() - k; l <= pos.func_177958_n() + k && flag; ++l) {
                    for (int i1 = pos.func_177952_p() - k; i1 <= pos.func_177952_p() + k && flag; ++i1) {
                        if (j >= 0 && j < 256) {
                            if (this.isReplaceable(world, (BlockPos)blockpos$mutableblockpos.func_181079_c(l, j, i1))) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            BlockPos down = pos.func_177977_b();
            IBlockState state = world.func_180495_p(down);
            boolean bl = isSoil = state.func_177230_c().canSustainPlant(state, (IBlockAccess)world, down, EnumFacing.UP, (IPlantable)((BlockPVJSapling)PVJBlocks.SAPLINGS.get(EnumLeafType.MANGROVE.getID()))) || state.func_185904_a() == Material.field_151586_h || state.func_177230_c() == Blocks.field_150354_m;
            if (isSoil && pos.func_177956_o() < world.func_72800_K() - height - 1) {
                BlockPos posRoot;
                int rootHeight = rand.nextInt(2) + 1;
                BlockPos topBlock = posRoot = pos.func_177981_b(rootHeight - 1);
                for (int i = rootHeight; i <= height; ++i) {
                    BlockPos posA;
                    BlockPos pos1;
                    if (i == rootHeight) {
                        pos1 = posRoot.func_177985_f(2);
                        while (this.isWaterOrAir(world, pos1)) {
                            this.func_175903_a(world, pos1, LOG);
                            pos1 = pos1.func_177977_b();
                        }
                        BlockPos pos2 = posRoot.func_177965_g(2);
                        while (this.isWaterOrAir(world, pos2)) {
                            this.func_175903_a(world, pos2, LOG);
                            pos2 = pos2.func_177977_b();
                        }
                        BlockPos pos3 = posRoot.func_177964_d(2);
                        while (this.isWaterOrAir(world, pos3)) {
                            this.func_175903_a(world, pos3, LOG);
                            pos3 = pos3.func_177977_b();
                        }
                        BlockPos pos4 = posRoot.func_177970_e(2);
                        while (this.isWaterOrAir(world, pos4)) {
                            this.func_175903_a(world, pos4, LOG);
                            pos4 = pos4.func_177977_b();
                        }
                    }
                    if (i == rootHeight + 1) {
                        pos1 = posRoot.func_177984_a();
                        pos1 = posRoot.func_177984_a().func_177976_e();
                        state = world.func_180495_p(pos1);
                        if (state.func_177230_c().isAir(state, (IBlockAccess)world, pos1) || state.func_177230_c().isLeaves(state, (IBlockAccess)world, pos1)) {
                            this.func_175903_a(world, pos1, LOG);
                            if (rand.nextInt(3) != 0 && ((state = world.func_180495_p(pos1 = posRoot.func_177984_a().func_177976_e().func_177977_b())).func_177230_c().isAir(state, (IBlockAccess)world, pos1) || state.func_177230_c().isLeaves(state, (IBlockAccess)world, pos1))) {
                                this.func_175903_a(world, pos1, LOG);
                            }
                            if (rand.nextInt(3) != 0 && ((state = world.func_180495_p(pos1 = posRoot.func_177984_a().func_177976_e().func_177984_a())).func_177230_c().isAir(state, (IBlockAccess)world, pos1) || state.func_177230_c().isLeaves(state, (IBlockAccess)world, pos1))) {
                                this.func_175903_a(world, pos1, LOG);
                            }
                        }
                        if ((state = world.func_180495_p(pos1 = posRoot.func_177984_a().func_177974_f())).func_177230_c().isAir(state, (IBlockAccess)world, pos1) || state.func_177230_c().isLeaves(state, (IBlockAccess)world, pos1)) {
                            this.func_175903_a(world, pos1, LOG);
                            if (rand.nextInt(3) != 0 && ((state = world.func_180495_p(pos1 = posRoot.func_177984_a().func_177976_e().func_177977_b())).func_177230_c().isAir(state, (IBlockAccess)world, pos1) || state.func_177230_c().isLeaves(state, (IBlockAccess)world, pos1))) {
                                this.func_175903_a(world, pos1, LOG);
                            }
                            if (rand.nextInt(3) != 0 && ((state = world.func_180495_p(pos1 = posRoot.func_177984_a().func_177976_e().func_177984_a())).func_177230_c().isAir(state, (IBlockAccess)world, pos1) || state.func_177230_c().isLeaves(state, (IBlockAccess)world, pos1))) {
                                this.func_175903_a(world, pos1, LOG);
                            }
                        }
                        if ((state = world.func_180495_p(pos1 = posRoot.func_177984_a().func_177978_c())).func_177230_c().isAir(state, (IBlockAccess)world, pos1) || state.func_177230_c().isLeaves(state, (IBlockAccess)world, pos1)) {
                            this.func_175903_a(world, pos1, LOG);
                            if (rand.nextInt(3) != 0 && ((state = world.func_180495_p(pos1 = posRoot.func_177984_a().func_177976_e().func_177977_b())).func_177230_c().isAir(state, (IBlockAccess)world, pos1) || state.func_177230_c().isLeaves(state, (IBlockAccess)world, pos1))) {
                                this.func_175903_a(world, pos1, LOG);
                            }
                            if (rand.nextInt(3) != 0 && ((state = world.func_180495_p(pos1 = posRoot.func_177984_a().func_177976_e().func_177984_a())).func_177230_c().isAir(state, (IBlockAccess)world, pos1) || state.func_177230_c().isLeaves(state, (IBlockAccess)world, pos1))) {
                                this.func_175903_a(world, pos1, LOG);
                            }
                        }
                        if ((state = world.func_180495_p(pos1 = posRoot.func_177984_a().func_177968_d())).func_177230_c().isAir(state, (IBlockAccess)world, pos1) || state.func_177230_c().isLeaves(state, (IBlockAccess)world, pos1)) {
                            this.func_175903_a(world, pos1, LOG);
                            if (rand.nextInt(3) != 0 && ((state = world.func_180495_p(pos1 = posRoot.func_177984_a().func_177976_e().func_177977_b())).func_177230_c().isAir(state, (IBlockAccess)world, pos1) || state.func_177230_c().isLeaves(state, (IBlockAccess)world, pos1))) {
                                this.func_175903_a(world, pos1, LOG);
                            }
                            if (rand.nextInt(3) != 0 && ((state = world.func_180495_p(pos1 = posRoot.func_177984_a().func_177976_e().func_177984_a())).func_177230_c().isAir(state, (IBlockAccess)world, pos1) || state.func_177230_c().isLeaves(state, (IBlockAccess)world, pos1))) {
                                this.func_175903_a(world, pos1, LOG);
                            }
                        }
                    }
                    if ((state = world.func_180495_p(posA = pos.func_177981_b(i))).func_177230_c().isAir(state, (IBlockAccess)world, posA) || state.func_177230_c().isLeaves(state, (IBlockAccess)world, posA)) {
                        this.func_175903_a(world, posA, LOG);
                    }
                    topBlock = posA;
                }
                state = world.func_180495_p(topBlock = topBlock.func_177982_a(0, 1, 0));
                if (state.func_177230_c().isAir(state, (IBlockAccess)world, topBlock) || state.func_177230_c().isLeaves(state, (IBlockAccess)world, topBlock)) {
                    this.func_175903_a(world, topBlock, LEAVES);
                }
                int leafHeight = 3 + rand.nextInt(2);
                for (int i = 0; i < leafHeight; ++i) {
                    BlockPos leafPos = topBlock.func_177979_c(i + 1);
                    int xOffset = 2;
                    int zOffset = 2;
                    if (i == 0 || i == leafHeight - 1) {
                        xOffset = 1;
                        zOffset = 1;
                    }
                    for (int j = -xOffset; j <= xOffset; ++j) {
                        for (int k = -zOffset; k <= zOffset; ++k) {
                            int x = leafPos.func_177958_n() + j;
                            int z = leafPos.func_177952_p() + k;
                            BlockPos newpos = new BlockPos(x, leafPos.func_177956_o(), z);
                            state = world.func_180495_p(newpos);
                            if (!state.func_177230_c().isAir(state, (IBlockAccess)world, newpos) && !state.func_177230_c().isLeaves(state, (IBlockAccess)world, newpos)) continue;
                            if (Math.abs(j) == Math.abs(k) && rand.nextInt(2) == 0) {
                                this.func_175903_a(world, newpos, LEAVES);
                            }
                            this.func_175903_a(world, newpos, LEAVES);
                        }
                    }
                }
            }
            return true;
        }
        return false;
    }

    private boolean isWaterOrAir(World world, BlockPos pos) {
        if (world.func_180495_p(pos).func_185904_a() == Material.field_151586_h) {
            return true;
        }
        return world.func_175623_d(pos);
    }
}

