/*
 * Decompiled with CFR 0.152.
 */
package vibrantjourneys.worldgen.feature;

import java.util.Random;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.common.IPlantable;
import vibrantjourneys.blocks.wood.BlockPVJLeaves;
import vibrantjourneys.blocks.wood.BlockPVJSapling;
import vibrantjourneys.init.PVJBlocks;
import vibrantjourneys.util.EnumLeafType;
import vibrantjourneys.util.EnumWoodType;

public class WorldGenPalmTree
extends WorldGenAbstractTree {
    private static final IBlockState LOG = PVJBlocks.LOGS.get(EnumWoodType.PALM.getID()).func_176223_P();
    private static final IBlockState LEAF = PVJBlocks.LEAVES.get(EnumLeafType.PALM.getID()).func_176223_P().func_177226_a((IProperty)BlockPVJLeaves.field_176236_b, (Comparable)Boolean.valueOf(false));
    private static final IBlockState COCONUT = PVJBlocks.coconut.func_176223_P();

    public WorldGenPalmTree() {
        super(true);
    }

    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        int height = rand.nextInt(4) + rand.nextInt(4) + 3;
        boolean flag = true;
        if (position.func_177956_o() >= 1 && position.func_177956_o() + height + 1 <= 256) {
            boolean isSoil;
            for (int j = position.func_177956_o(); j <= position.func_177956_o() + 1 + height; ++j) {
                int k = 1;
                if (j == position.func_177956_o()) {
                    k = 0;
                }
                if (j >= position.func_177956_o() + 1 + height - 2) {
                    k = 2;
                }
                BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                for (int l = position.func_177958_n() - k; l <= position.func_177958_n() + k && flag; ++l) {
                    for (int i1 = position.func_177952_p() - k; i1 <= position.func_177952_p() + k && flag; ++i1) {
                        if (j >= 0 && j < 256) {
                            if (this.isReplaceable(worldIn, (BlockPos)blockpos$mutableblockpos.func_181079_c(l, j, i1))) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            BlockPos down = position.func_177977_b();
            IBlockState state = worldIn.func_180495_p(down);
            boolean bl = isSoil = state.func_177230_c().canSustainPlant(state, (IBlockAccess)worldIn, down, EnumFacing.UP, (IPlantable)((BlockPVJSapling)PVJBlocks.SAPLINGS.get(EnumLeafType.PALM.getID()))) || state.func_177230_c() == Blocks.field_150354_m;
            if (isSoil && position.func_177956_o() < worldIn.func_72800_K() - height - 1) {
                int i;
                state.func_177230_c().onPlantGrow(state, worldIn, down, position);
                EnumFacing enumfacing = EnumFacing.Plane.HORIZONTAL.func_179518_a(rand);
                int x = position.func_177958_n();
                int y = position.func_177956_o();
                int z = position.func_177952_p();
                int trunk = height - rand.nextInt(4) - 2;
                BlockPos pos1 = null;
                for (i = 0; i < height; ++i) {
                    BlockPos blockpos;
                    int y1 = y + i;
                    if (i > trunk) {
                        x += enumfacing.func_82601_c();
                        z += enumfacing.func_82599_e();
                    }
                    if ((state = worldIn.func_180495_p(blockpos = new BlockPos(x, y1, z))).func_177230_c().isAir(state, (IBlockAccess)worldIn, blockpos) || state.func_177230_c().isLeaves(state, (IBlockAccess)worldIn, blockpos)) {
                        this.func_175903_a(worldIn, blockpos, LOG);
                        if (i > trunk && rand.nextInt(2) == 0 && (state.func_177230_c().isAir(state, (IBlockAccess)worldIn, blockpos.func_177984_a()) || state.func_177230_c().isLeaves(state, (IBlockAccess)worldIn, blockpos.func_177984_a()))) {
                            this.func_175903_a(worldIn, blockpos.func_177984_a(), LOG);
                        }
                    }
                    if (i != height - 1) continue;
                    pos1 = new BlockPos(x, y1 + 1, z);
                }
                if (state.func_177230_c().isAir(state, (IBlockAccess)worldIn, pos1) || state.func_177230_c().isLeaves(state, (IBlockAccess)worldIn, pos1)) {
                    this.func_175903_a(worldIn, pos1, LOG);
                }
                if (state.func_177230_c().isAir(state, (IBlockAccess)worldIn, pos1.func_177984_a()) || state.func_177230_c().isLeaves(state, (IBlockAccess)worldIn, pos1.func_177984_a())) {
                    this.func_175903_a(worldIn, pos1.func_177984_a(), LOG);
                }
                if (state.func_177230_c().isAir(state, (IBlockAccess)worldIn, pos1.func_177981_b(2)) || state.func_177230_c().isLeaves(state, (IBlockAccess)worldIn, pos1.func_177981_b(2))) {
                    this.func_175903_a(worldIn, pos1.func_177981_b(2), LEAF);
                }
                for (int xOffset = -2; xOffset <= 2; ++xOffset) {
                    for (int zOffset = -2; zOffset <= 2; ++zOffset) {
                        BlockPos leafpos = new BlockPos(pos1.func_177958_n() + xOffset, pos1.func_177956_o() + 1, pos1.func_177952_p() + zOffset);
                        if (leafpos.equals((Object)pos1)) continue;
                        state = worldIn.func_180495_p(leafpos);
                        if (Math.abs(xOffset) == 2 || Math.abs(zOffset) == 2) {
                            if (!state.func_177230_c().isAir(state, (IBlockAccess)worldIn, leafpos) && !state.func_177230_c().isLeaves(state, (IBlockAccess)worldIn, leafpos) || rand.nextInt(3) != 0 || Math.abs(xOffset) == Math.abs(zOffset)) continue;
                            this.func_175903_a(worldIn, leafpos, LEAF);
                            if (!state.func_177230_c().isAir(state, (IBlockAccess)worldIn, leafpos.func_177977_b()) && !state.func_177230_c().isLeaves(state, (IBlockAccess)worldIn, leafpos.func_177977_b()) || rand.nextInt(7) != 0) continue;
                            this.func_175903_a(worldIn, leafpos.func_177977_b(), COCONUT);
                            continue;
                        }
                        if (!state.func_177230_c().isAir(state, (IBlockAccess)worldIn, leafpos) && !state.func_177230_c().isLeaves(state, (IBlockAccess)worldIn, leafpos)) continue;
                        this.func_175903_a(worldIn, leafpos, LEAF);
                        if (!state.func_177230_c().isAir(state, (IBlockAccess)worldIn, leafpos.func_177977_b()) && !state.func_177230_c().isLeaves(state, (IBlockAccess)worldIn, leafpos.func_177977_b()) || rand.nextInt(7) != 0) continue;
                        this.func_175903_a(worldIn, leafpos.func_177977_b(), COCONUT);
                    }
                }
                for (i = 0; i < rand.nextInt(2) + 1; ++i) {
                    BlockPos leafpos = new BlockPos(pos1.func_177958_n(), pos1.func_177956_o() + 1 - i, pos1.func_177952_p()).func_177985_f(2 + i);
                    state = worldIn.func_180495_p(leafpos);
                    if (state.func_177230_c().isAir(state, (IBlockAccess)worldIn, leafpos) || state.func_177230_c().isLeaves(state, (IBlockAccess)worldIn, leafpos)) {
                        this.func_175903_a(worldIn, leafpos, LEAF);
                    }
                    if (!state.func_177230_c().isAir(state, (IBlockAccess)worldIn, leafpos.func_177977_b()) && !state.func_177230_c().isLeaves(state, (IBlockAccess)worldIn, leafpos.func_177977_b())) continue;
                    this.func_175903_a(worldIn, leafpos.func_177977_b(), LEAF);
                }
                for (i = 0; i < rand.nextInt(2) + 1; ++i) {
                    BlockPos leafpos = new BlockPos(pos1.func_177958_n(), pos1.func_177956_o() + 1 - i, pos1.func_177952_p()).func_177965_g(2 + i);
                    state = worldIn.func_180495_p(leafpos);
                    if (state.func_177230_c().isAir(state, (IBlockAccess)worldIn, leafpos) || state.func_177230_c().isLeaves(state, (IBlockAccess)worldIn, leafpos)) {
                        this.func_175903_a(worldIn, leafpos, LEAF);
                    }
                    if (!state.func_177230_c().isAir(state, (IBlockAccess)worldIn, leafpos.func_177977_b()) && !state.func_177230_c().isLeaves(state, (IBlockAccess)worldIn, leafpos.func_177977_b())) continue;
                    this.func_175903_a(worldIn, leafpos.func_177977_b(), LEAF);
                }
                for (i = 0; i < rand.nextInt(2) + 1; ++i) {
                    BlockPos leafpos = new BlockPos(pos1.func_177958_n(), pos1.func_177956_o() + 1 - i, pos1.func_177952_p()).func_177964_d(2 + i);
                    state = worldIn.func_180495_p(leafpos);
                    if (state.func_177230_c().isAir(state, (IBlockAccess)worldIn, leafpos) || state.func_177230_c().isLeaves(state, (IBlockAccess)worldIn, leafpos)) {
                        this.func_175903_a(worldIn, leafpos, LEAF);
                    }
                    if (!state.func_177230_c().isAir(state, (IBlockAccess)worldIn, leafpos.func_177977_b()) && !state.func_177230_c().isLeaves(state, (IBlockAccess)worldIn, leafpos.func_177977_b())) continue;
                    this.func_175903_a(worldIn, leafpos.func_177977_b(), LEAF);
                }
                for (i = 0; i < rand.nextInt(2) + 1; ++i) {
                    BlockPos leafpos = new BlockPos(pos1.func_177958_n(), pos1.func_177956_o() + 1 - i, pos1.func_177952_p()).func_177970_e(2 + i);
                    state = worldIn.func_180495_p(leafpos);
                    if (state.func_177230_c().isAir(state, (IBlockAccess)worldIn, leafpos) || state.func_177230_c().isLeaves(state, (IBlockAccess)worldIn, leafpos)) {
                        this.func_175903_a(worldIn, leafpos, LEAF);
                    }
                    if (!state.func_177230_c().isAir(state, (IBlockAccess)worldIn, leafpos.func_177977_b()) && !state.func_177230_c().isLeaves(state, (IBlockAccess)worldIn, leafpos.func_177977_b())) continue;
                    this.func_175903_a(worldIn, leafpos.func_177977_b(), LEAF);
                }
                return true;
            }
        }
        return false;
    }
}

