/*
 * Decompiled with CFR 0.152.
 */
package vibrantjourneys.worldgen.feature;

import java.util.Random;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.common.IPlantable;
import vibrantjourneys.init.PVJBlocks;
import vibrantjourneys.util.EnumLeafType;
import vibrantjourneys.util.EnumWoodType;

public class WorldGenPineTree
extends WorldGenAbstractTree {
    private static final IBlockState TRUNK = PVJBlocks.LOGS.get(EnumWoodType.PINE.getID()).func_176223_P();
    private static final IBlockState LEAF = PVJBlocks.LEAVES.get(EnumLeafType.PINE.getID()).func_176223_P().func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false));

    public WorldGenPineTree(boolean notify) {
        super(notify);
    }

    public boolean func_180709_b(World world, Random rand, BlockPos position) {
        int height = 9 + rand.nextInt(4);
        int j = 1 + rand.nextInt(2);
        int l = 3 + rand.nextInt(2);
        boolean flag = true;
        if (position.func_177956_o() >= 1 && position.func_177956_o() + height + 1 <= world.func_72800_K()) {
            for (int i1 = position.func_177956_o(); i1 <= position.func_177956_o() + 1 + height && flag; ++i1) {
                int j1 = i1 - position.func_177956_o() < j ? 0 : l;
                BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                for (int k1 = position.func_177958_n() - j1; k1 <= position.func_177958_n() + j1 && flag; ++k1) {
                    for (int l1 = position.func_177952_p() - j1; l1 <= position.func_177952_p() + j1 && flag; ++l1) {
                        if (i1 >= 0 && i1 < world.func_72800_K()) {
                            IBlockState state = world.func_180495_p((BlockPos)blockpos$mutableblockpos.func_181079_c(k1, i1, l1));
                            if (state.func_177230_c().isAir(state, (IBlockAccess)world, (BlockPos)blockpos$mutableblockpos.func_181079_c(k1, i1, l1)) || state.func_177230_c().isLeaves(state, (IBlockAccess)world, (BlockPos)blockpos$mutableblockpos.func_181079_c(k1, i1, l1))) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            BlockPos down = position.func_177977_b();
            IBlockState state = world.func_180495_p(down);
            int p = 6 + rand.nextInt(2);
            if (state.func_177230_c().canSustainPlant(state, (IBlockAccess)world, down, EnumFacing.UP, (IPlantable)((BlockSapling)Blocks.field_150345_g)) && position.func_177956_o() < world.func_72800_K() - height - 1) {
                state.func_177230_c().onPlantGrow(state, world, down, position);
                int branch = 1;
                for (int i = 0; i <= height; ++i) {
                    int y = position.func_177956_o() + height - i;
                    int y1 = height - i;
                    BlockPos pos = new BlockPos(position.func_177958_n(), y, position.func_177952_p());
                    state = world.func_180495_p(pos);
                    if (state.func_177230_c().isAir(state, (IBlockAccess)world, pos) || state.func_177230_c().isLeaves(state, (IBlockAccess)world, pos)) {
                        this.func_175903_a(world, pos, TRUNK);
                        if (i < p && i % 2 == 0) {
                            this.growLeavesLayerStrict(world, pos, i < p / 2 ? 1 : 2);
                        }
                        if (branch % 2 == 0 && y1 > j) {
                            EnumFacing facing = EnumFacing.Plane.HORIZONTAL.func_179518_a(rand);
                            int branchX = position.func_177958_n() + facing.func_82601_c();
                            int branchZ = position.func_177952_p() + facing.func_82599_e();
                            pos = new BlockPos(branchX, y, branchZ);
                            if (state.func_177230_c().isAir(state, (IBlockAccess)world, pos) || state.func_177230_c().isLeaves(state, (IBlockAccess)world, pos)) {
                                this.func_175903_a(world, pos, TRUNK.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.func_176870_a((EnumFacing.Axis)facing.func_176740_k())));
                                for (EnumFacing f : EnumFacing.field_82609_l) {
                                    BlockPos pos1 = pos.func_177972_a(f);
                                    IBlockState state1 = world.func_180495_p(pos1);
                                    if (!state1.func_177230_c().canBeReplacedByLeaves(state1, (IBlockAccess)world, pos1)) continue;
                                    this.func_175903_a(world, pos1, LEAF);
                                }
                            }
                        }
                    }
                    ++branch;
                    if (i != 0 || !(state = world.func_180495_p(pos = pos.func_177984_a())).func_177230_c().canBeReplacedByLeaves(state, (IBlockAccess)world, pos)) continue;
                    this.func_175903_a(world, pos, LEAF);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    protected void growLeavesLayerStrict(World worldIn, BlockPos layerCenter, int width) {
        int i = width * width;
        for (int j = -width; j <= width + 1; ++j) {
            for (int k = -width; k <= width + 1; ++k) {
                BlockPos blockpos;
                IBlockState state;
                int l = j - 1;
                int i1 = k - 1;
                if (j * j + k * k > i && l * l + i1 * i1 > i && j * j + i1 * i1 > i && l * l + k * k > i || !(state = worldIn.func_180495_p(blockpos = layerCenter.func_177982_a(j, 0, k))).func_177230_c().isAir(state, (IBlockAccess)worldIn, blockpos) && !state.func_177230_c().isLeaves(state, (IBlockAccess)worldIn, blockpos)) continue;
                this.func_175903_a(worldIn, blockpos, LEAF);
            }
        }
    }
}

