/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.qualitytools.config;

import com.google.common.collect.HashMultimap;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.tmtravlr.qualitytools.config.ConfigLoader;
import java.lang.reflect.Type;
import java.util.UUID;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.FMLLog;

public class QualityEntry {
    public String name;
    public TextFormatting color;
    public int weight;
    public HashMultimap<String, AttributeModifier> attributeMap;

    public static class Serializer
    implements JsonDeserializer<QualityEntry> {
        public QualityEntry deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext context) throws JsonParseException {
            JsonObject json = jsonElement.getAsJsonObject();
            QualityEntry entry = new QualityEntry();
            entry.weight = JsonUtils.func_151208_a((JsonObject)json, (String)"weight", (int)1);
            if (entry.weight < 1) {
                entry.weight = 1;
            }
            entry.name = JsonUtils.func_151200_h((JsonObject)json, (String)"name");
            if (entry.name.equalsIgnoreCase("normal")) {
                return entry;
            }
            String colorName = json.has("color") ? JsonUtils.func_151200_h((JsonObject)json, (String)"color") : "white";
            entry.color = TextFormatting.func_96300_b((String)colorName);
            if (entry.color == null) {
                FMLLog.warning((String)"[Quality Tools] Unknown formatting color %s in %s. Ignoring and setting to white.", (Object[])new Object[]{colorName, ConfigLoader.typeDeserializing});
                entry.color = TextFormatting.WHITE;
            }
            entry.attributeMap = HashMultimap.create();
            JsonArray attributes = JsonUtils.func_151214_t((JsonObject)json, (String)"attributes");
            for (int i = 0; i < attributes.size(); ++i) {
                if (!attributes.get(i).isJsonObject()) continue;
                JsonObject jsonAttribute = attributes.get(i).getAsJsonObject();
                String attributeName = JsonUtils.func_151200_h((JsonObject)jsonAttribute, (String)"name");
                float amount = JsonUtils.func_151217_k((JsonObject)jsonAttribute, (String)"amount");
                int operation = JsonUtils.func_151208_a((JsonObject)jsonAttribute, (String)"operation", (int)0);
                AttributeModifier modifier = new AttributeModifier(new UUID(1L, 1L), "qualitytools", (double)amount, operation);
                entry.attributeMap.put((Object)attributeName, (Object)modifier);
            }
            return entry;
        }
    }
}

