/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import xreliquary.Reliquary;
import xreliquary.crafting.factories.AlkahestryChargingRecipeFactory;
import xreliquary.init.ModSounds;
import xreliquary.init.XRRecipes;
import xreliquary.items.ItemToggleable;
import xreliquary.reference.Settings;
import xreliquary.util.InventoryHelper;
import xreliquary.util.LanguageHelper;
import xreliquary.util.NBTHelper;

public class ItemAlkahestryTome
extends ItemToggleable {
    public ItemAlkahestryTome() {
        super("alkahestry_tome");
        this.func_77637_a(Reliquary.CREATIVE_TAB);
        this.func_77625_d(1);
        this.func_77656_e(ItemAlkahestryTome.getChargeLimit() + 1);
        this.canRepair = false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment.field_77351_y == EnumEnchantmentType.BREAKABLE ? false : super.canApplyAtEnchantingTable(stack, enchantment);
    }

    @Override
    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        ItemStack newStack = (ItemStack)super.func_77659_a(world, player, hand).func_188398_b();
        if (player.func_70093_af()) {
            return new ActionResult(EnumActionResult.SUCCESS, (Object)newStack);
        }
        player.func_184185_a(ModSounds.book, 1.0f, 1.0f);
        player.openGui((Object)Reliquary.INSTANCE, 0, world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public void func_77663_a(ItemStack tome, World world, Entity entity, int i, boolean f) {
        if (world.field_72995_K) {
            return;
        }
        if (!this.isEnabled(tome)) {
            return;
        }
        if (!(entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        for (AlkahestryChargingRecipeFactory.AlkahestryChargingRecipe recipe : XRRecipes.chargingRecipes) {
            if (ItemAlkahestryTome.getCharge(tome) + recipe.getChargeToAdd() > ItemAlkahestryTome.getChargeLimit() || !this.consumeItem(recipe, player)) continue;
            ItemAlkahestryTome.addCharge(tome, recipe.getChargeToAdd());
        }
    }

    private boolean consumeItem(AlkahestryChargingRecipeFactory.AlkahestryChargingRecipe recipe, EntityPlayer player) {
        return InventoryHelper.consumeItem(is -> recipe.getChargingIngredient().apply(is), player);
    }

    @Override
    protected void addMoreInformation(ItemStack tome, @Nullable World world, List<String> tooltip) {
        LanguageHelper.formatTooltip(this.func_77657_g(tome) + ".tooltip2", (ImmutableMap<String, String>)ImmutableMap.of((Object)"chargeAmount", (Object)String.valueOf(ItemAlkahestryTome.getCharge(tome)), (Object)"chargeLimit", (Object)String.valueOf(ItemAlkahestryTome.getChargeLimit())), tooltip);
        if (this.isEnabled(tome)) {
            LanguageHelper.formatTooltip("tooltip.absorb_active", (ImmutableMap<String, String>)ImmutableMap.of((Object)"item", (Object)(TextFormatting.RED + XRRecipes.drainRecipe.func_77571_b().func_82833_r())), tooltip);
        } else {
            LanguageHelper.formatTooltip("tooltip.absorb", tooltip);
        }
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.EPIC;
    }

    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> subItems) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        ItemStack stack = new ItemStack((Item)this);
        stack.func_77964_b(stack.func_77958_k());
        subItems.add((Object)stack);
    }

    public static int getChargeLimit() {
        return Settings.Items.AlkahestryTome.chargeLimit;
    }

    public static void setCharge(ItemStack tome, int charge) {
        NBTHelper.setInteger("charge", tome, charge);
        tome.func_77964_b(tome.func_77958_k() - charge);
    }

    public static int getCharge(ItemStack tome) {
        return NBTHelper.getInteger("charge", tome);
    }

    public static void addCharge(ItemStack tome, int chageToAdd) {
        ItemAlkahestryTome.setCharge(tome, ItemAlkahestryTome.getCharge(tome) + chageToAdd);
    }

    public void useCharge(ItemStack tome, int chargeToUse) {
        ItemAlkahestryTome.addCharge(tome, -chargeToUse);
    }
}

