/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items.block;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import xreliquary.init.ModBlocks;
import xreliquary.items.block.ItemBlockBase;
import xreliquary.reference.Settings;

public class ItemFertileLilyPad
extends ItemBlockBase {
    public ItemFertileLilyPad() {
        super((Block)ModBlocks.fertileLilypad);
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.EPIC;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, @Nonnull EnumHand hand) {
        RayTraceResult result = this.func_77621_a(world, player, true);
        ItemStack stack = player.func_184586_b(hand);
        if (this.TryPlacingLilyPad(stack, world, player, result, hand)) {
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)stack);
    }

    private boolean TryPlacingLilyPad(ItemStack itemStack, World worldIn, EntityPlayer playerIn, RayTraceResult result, EnumHand hand) {
        if (result != null && result.field_72313_a == RayTraceResult.Type.BLOCK) {
            BlockPos blockpos = result.func_178782_a();
            if (!worldIn.func_175660_a(playerIn, blockpos)) {
                return true;
            }
            if (!playerIn.func_175151_a(blockpos.func_177972_a(result.field_178784_b), result.field_178784_b, itemStack)) {
                return true;
            }
            BlockPos blockpos1 = blockpos.func_177984_a();
            IBlockState iblockstate = worldIn.func_180495_p(blockpos);
            if (iblockstate.func_185904_a() == Material.field_151586_h && (Integer)iblockstate.func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0 && worldIn.func_175623_d(blockpos1)) {
                BlockSnapshot blocksnapshot = BlockSnapshot.getBlockSnapshot((World)worldIn, (BlockPos)blockpos1);
                worldIn.func_175656_a(blockpos1, ModBlocks.fertileLilypad.func_176223_P());
                if (ForgeEventFactory.onPlayerBlockPlace((EntityPlayer)playerIn, (BlockSnapshot)blocksnapshot, (EnumFacing)EnumFacing.UP, (EnumHand)hand).isCanceled()) {
                    blocksnapshot.restore(true, false);
                    return false;
                }
                int secondsBetweenGrowthTicks = Settings.Blocks.FertileLilypad.secondsBetweenGrowthTicks;
                worldIn.func_180497_b(blockpos1, (Block)ModBlocks.fertileLilypad, secondsBetweenGrowthTicks * 20, 1);
                if (!playerIn.field_71075_bZ.field_75098_d) {
                    itemStack.func_190918_g(1);
                }
            }
        }
        return true;
    }
}

