/*
 * Decompiled with CFR 0.152.
 */
package xxrexraptorxx.additionalstructures.world;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import xxrexraptorxx.additionalstructures.config.ConfigGeneral;
import xxrexraptorxx.additionalstructures.config.ConfigStructures;
import xxrexraptorxx.additionalstructures.world.StructureGenerator;
import xxrexraptorxx.additionalstructures.world.StructureList;

public class WorldGenStructures
implements IWorldGenerator {
    private static List<Biome> biomeList = ForgeRegistries.BIOMES.getValues();

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (world.func_72912_H().func_76089_r() && world.func_175624_G() != WorldType.field_77138_c) {
            int blockX = chunkX * 16 + random.nextInt(16);
            int blockZ = chunkZ * 16 + random.nextInt(16);
            if (world.field_73011_w.getDimension() == DimensionType.THE_END.func_186068_a()) {
                if (ConfigGeneral.activateEndGeneration) {
                    this.generateStructure(StructureList.BONE_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceBones, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.END));
                    this.generateStructure(StructureList.BONE_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceBones, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.END));
                    this.generateDownsetStructure(StructureList.END_ALTAR_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceSpawnAltars, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.END));
                    this.generateDownsetStructure(StructureList.END_ALTAR_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceSpawnAltars, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.END));
                    this.generateDownsetStructure(StructureList.END_HOUSE, world, random, blockX, blockZ, ConfigStructures.spawnchanceEndBuildings, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.END));
                    this.generateDownsetStructure(StructureList.END_VILLA, world, random, blockX, blockZ, ConfigStructures.spawnchanceEndBuildings, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.END));
                    this.generateDownsetStructure(StructureList.END_PILLARS, world, random, blockX, blockZ, ConfigStructures.spawnchanceStonePillars, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.END));
                    this.generateDownsetStructure(StructureList.END_TOWER_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceEndTowers, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.END));
                    this.generateDownsetStructure(StructureList.END_TOWER_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceEndTowers, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.END));
                    this.generateDownsetStructure(StructureList.END_TOWER_3, world, random, blockX, blockZ, ConfigStructures.spawnchanceEndTowers, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.END));
                    this.generateDownsetStructure(StructureList.END_TOWER_4, world, random, blockX, blockZ, ConfigStructures.spawnchanceEndTowers, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.END));
                    this.generateStructure(StructureList.END_WALL_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceWallRuins, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.END));
                    this.generateStructure(StructureList.END_WALL_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceWallRuins, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.END));
                    this.generateStructure(StructureList.END_WALL_3, world, random, blockX, blockZ, ConfigStructures.spawnchanceWallRuins, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.END));
                    this.generateStructure(StructureList.END_CRYSTAL, world, random, blockX, blockZ, ConfigStructures.spawnchanceEndCrystals, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.END));
                    this.generateStructure(StructureList.FOSSIL_ENDERDRAGON_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceFossils, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.END));
                    this.generateStructure(StructureList.FOSSIL_ENDERDRAGON_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceFossils, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.END));
                    this.generateDownsetStructure(StructureList.FOSSIL_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceFossils, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.END));
                    this.generateDownsetStructure(StructureList.FOSSIL_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceFossils, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.END));
                    this.generateStructure(StructureList.SKULL_WITHER, world, random, blockX, blockZ, ConfigStructures.spawnchanceSkulls, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.END));
                    this.generateDownsetStructure(StructureList.OBSIDIAN_PILLAR_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceObsidianPillars, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.END));
                    this.generateDownsetStructure(StructureList.OBSIDIAN_PILLAR_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceObsidianPillars, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.END));
                    this.generateDownsetStructure(StructureList.OBSIDIAN_PILLAR_3, world, random, blockX, blockZ, ConfigStructures.spawnchanceObsidianPillars, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.END));
                    this.generateDownsetStructure(StructureList.OBSIDIAN_PILLAR_BROKEN_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceObsidianPillars, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.END));
                    this.generateDownsetStructure(StructureList.OBSIDIAN_PILLAR_BROKEN_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceObsidianPillars, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.END));
                    this.generateDownsetStructure(StructureList.NETHER_PORTAL, world, random, blockX, blockZ, ConfigStructures.spawnchanceNetherPortals, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.END));
                    this.generateUndergroundStructure(StructureList.END_DUNGEON, world, random, blockX, blockZ, ConfigStructures.spawnchanceUndergroundDungeons, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.END));
                    this.generateDownsetStructure(StructureList.END_RUIN, world, random, blockX, blockZ, ConfigStructures.spawnchanceRuins, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.END));
                    this.generateDownsetStructure(StructureList.ENDBRICK_PILLAR_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceStonePillars, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.END));
                    this.generateDownsetStructure(StructureList.ENDBRICK_PILLAR_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceStonePillars, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.END));
                    this.generateBuryStructure(StructureList.OBSIDIAN_SPIKES_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceObsidianSpikes, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.END));
                    this.generateBuryStructure(StructureList.OBSIDIAN_SPIKES_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceObsidianSpikes, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.END));
                    this.generateBuryStructure(StructureList.OBSIDIAN_SPIKES_3, world, random, blockX, blockZ, ConfigStructures.spawnchanceObsidianSpikes, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.END));
                }
            } else if (world.field_73011_w.getDimension() == DimensionType.NETHER.func_186068_a()) {
                if (ConfigGeneral.activateNetherGeneration) {
                    // empty if block
                }
            } else if (ConfigGeneral.additionalDimensions.length > 0) {
                for (int i = 0; i < ConfigGeneral.additionalDimensions.length; ++i) {
                    int dimension = ConfigGeneral.additionalDimensions[i];
                    if (world.field_73011_w.getDimension() != dimension || !ConfigGeneral.activateOverworldGeneration) continue;
                    this.generateStructure(StructureList.DEAD_TREE_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceLogs, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SANDY));
                    this.generateStructure(StructureList.DEAD_TREE_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceLogs, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SANDY));
                    this.generateStructure(StructureList.DEAD_TREE_3, world, random, blockX, blockZ, ConfigStructures.spawnchanceLogs, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SANDY));
                    this.generateStructure(StructureList.BIG_CACTUS, world, random, blockX, blockZ, ConfigStructures.spawnchanceBiggerCacti, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SANDY));
                    this.generateStructure(StructureList.HUGE_CACTUS, world, random, blockX, blockZ, ConfigStructures.spawnchanceBiggerCacti, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SANDY));
                    this.generateStructure(StructureList.SMALL_PYRAMIDE, world, random, blockX, blockZ, ConfigStructures.spawnchancePyramides, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SANDY));
                    this.generateStructure(StructureList.PYRAMIDE_TEMPLE, world, random, blockX, blockZ, ConfigStructures.spawnchanceTemple, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SANDY));
                    this.generateStructure(StructureList.ACACIA_LOG, world, random, blockX, blockZ, ConfigStructures.spawnchanceLogs, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SANDY));
                    this.generateStructure(StructureList.SKULL, world, random, blockX, blockZ, ConfigStructures.spawnchanceSkulls, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SANDY));
                    this.generateStructure(StructureList.ROCK_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceRocks, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SANDY));
                    this.generateStructure(StructureList.ROCK_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceRocks, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SANDY));
                    this.generateStructure(StructureList.ROCK_3, world, random, blockX, blockZ, ConfigStructures.spawnchanceRocks, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SANDY));
                    this.generateDownsetStructure(StructureList.ROCK_4, world, random, blockX, blockZ, ConfigStructures.spawnchanceRocks, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SANDY));
                    this.generateStructure(StructureList.SAND_ROCK_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceRocks, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SANDY));
                    this.generateStructure(StructureList.SAND_ROCK_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceRocks, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SANDY));
                    this.generateStructure(StructureList.SAND_ROCK_3, world, random, blockX, blockZ, ConfigStructures.spawnchanceRocks, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SANDY));
                    this.generateDownsetStructure(StructureList.DESERT_PILLARS_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceDesertPillars, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SANDY));
                    this.generateDownsetStructure(StructureList.DESERT_PILLARS_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceDesertPillars, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SANDY));
                    this.generateDownsetStructure(StructureList.SAND_TOTEM_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceTotems, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SANDY));
                    this.generateStructure(StructureList.SAND_TOTEM_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceTotems, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SANDY));
                    this.generateDownsetStructure(StructureList.SAND_TOTEM_BIG, world, random, blockX, blockZ, ConfigStructures.spawnchanceTotems, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SANDY));
                    this.generateBuryStructure(StructureList.OASE, world, random, blockX, blockZ, ConfigStructures.spawnchanceOasis, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SANDY));
                    this.generateDownsetStructure(StructureList.OASE_SMALL, world, random, blockX, blockZ, ConfigStructures.spawnchanceOasis, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SANDY));
                    this.generateStructure(StructureList.PALM_BIG, world, random, blockX, blockZ, ConfigStructures.spawnchancePalms, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SANDY));
                    this.generateStructure(StructureList.PALM_SMALL, world, random, blockX, blockZ, ConfigStructures.spawnchancePalms, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SANDY));
                    this.generateStructure(StructureList.PALM_1, world, random, blockX, blockZ, ConfigStructures.spawnchancePalms, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SANDY));
                    this.generateStructure(StructureList.PALM_2, world, random, blockX, blockZ, ConfigStructures.spawnchancePalms, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SANDY));
                    this.generateUndergroundStructure(StructureList.DESERT_TOMB, world, random, blockX, blockZ, ConfigStructures.spawnchanceTombs, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SANDY));
                    this.generateBuryStructure(StructureList.PYRAMIDE_DUNGEON, world, random, blockX, blockZ, ConfigStructures.spawnchancePyramideDungeon, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SANDY));
                    this.generateDownsetStructure(StructureList.SPHINX, world, random, blockX, blockZ, ConfigStructures.spawnchanceSphinx, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SANDY));
                    this.generateDownsetStructure(StructureList.PYRAMIDE_BIG, world, random, blockX, blockZ, ConfigStructures.spawnchancePyramides, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SANDY));
                    this.generateStructure(StructureList.FALLEN_DEAD_TREE_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceFallenTrees, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SANDY));
                    this.generateStructure(StructureList.FALLEN_DEAD_TREE_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceFallenTrees, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SANDY));
                    this.generateStructure(StructureList.FALLEN_DEAD_TREE_3, world, random, blockX, blockZ, ConfigStructures.spawnchanceFallenTrees, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SANDY));
                    this.generateStructure(StructureList.FALLEN_PALM_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceFallenTrees, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SANDY));
                    this.generateStructure(StructureList.FALLEN_PALM_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceFallenTrees, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SANDY));
                    this.generateUndergroundStructure(StructureList.SARCOPHAGUS_ROOM, world, random, blockX, blockZ, ConfigStructures.spawnchanceTombs, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SANDY));
                    this.generateStructure(StructureList.SNOWMAN, world, random, blockX, blockZ, ConfigStructures.spawnchanceSnowmen, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SNOWY));
                    this.generateStructure(StructureList.SNOWMAN_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceSnowmen, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SNOWY));
                    this.generateStructure(StructureList.DEAD_SPRUCE_TREE, world, random, blockX, blockZ, ConfigStructures.spawnchanceLogs, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SNOWY));
                    this.generateStructure(StructureList.SPRUCE_LOG, world, random, blockX, blockZ, ConfigStructures.spawnchanceLogs, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SNOWY));
                    this.generateStructure(StructureList.FALLEN_SPRUCE_TREE_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceFallenTrees, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SNOWY));
                    this.generateStructure(StructureList.FALLEN_SPRUCE_TREE_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceFallenTrees, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SNOWY));
                    this.generateStructure(StructureList.SNOW_PILE_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceSnowPiles, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SNOWY));
                    this.generateStructure(StructureList.SNOW_PILE_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceSnowPiles, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SNOWY));
                    this.generateStructure(StructureList.SNOW_PILE_3, world, random, blockX, blockZ, ConfigStructures.spawnchanceSnowPiles, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SNOWY));
                    this.generateStructure(StructureList.WITCH_BREWING_STAND, world, random, blockX, blockZ, ConfigStructures.spawnchanceSpawnAltars, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SWAMP));
                    this.generateStructure(StructureList.SKULL, world, random, blockX, blockZ, ConfigStructures.spawnchanceSkulls, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SWAMP));
                    this.generateStructure(StructureList.SCARECROW, world, random, blockX, blockZ, ConfigStructures.spawnchanceScarecrow, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SWAMP));
                    this.generateStructure(StructureList.ILLAGER_HOUSE, world, random, blockX, blockZ, ConfigStructures.spawnchanceIllagerHouses, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SWAMP));
                    this.generateDownsetStructure(StructureList.ALTAR_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceSpawnAltars, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SWAMP));
                    this.generateDownsetStructure(StructureList.ALTAR_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceSpawnAltars, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SWAMP));
                    this.generateDownsetStructure(StructureList.ALTAR_3, world, random, blockX, blockZ, ConfigStructures.spawnchanceSpawnAltars, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SWAMP));
                    this.generateDownsetStructure(StructureList.ALTAR_BIG_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceSpawnAltars, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SWAMP));
                    this.generateDownsetStructure(StructureList.ALTAR_BIG_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceSpawnAltars, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SWAMP));
                    this.generateDownsetStructure(StructureList.NETHER_PORTAL, world, random, blockX, blockZ, ConfigStructures.spawnchanceNetherPortals, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SWAMP));
                    this.generateStructure(StructureList.OAK_LOG_SHORT, world, random, blockX, blockZ, ConfigStructures.spawnchanceLogs, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SWAMP));
                    this.generateUndergroundStructure(StructureList.TOMB, world, random, blockX, blockZ, ConfigStructures.spawnchanceTombs, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SWAMP));
                    this.generateBuryStructure(StructureList.HORCRUX, world, random, blockX, blockZ, ConfigStructures.spawnchanceSpecials, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SWAMP));
                    this.generateUndergroundStructure(StructureList.TOMB_BIG, world, random, blockX, blockZ, ConfigStructures.spawnchanceTombs + 500, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SWAMP));
                    this.generateDownsetStructure(StructureList.TOWER_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceTowers, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SWAMP));
                    this.generateDownsetStructure(StructureList.TOWER_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceTowers, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SWAMP));
                    this.generateDownsetStructure(StructureList.ALTAR_TOTEM_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceSpawnAltars, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SWAMP));
                    this.generateDownsetStructure(StructureList.ALTAR_TOTEM_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceSpawnAltars, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SWAMP));
                    this.generateDownsetStructure(StructureList.ALTAR_TOTEM_3, world, random, blockX, blockZ, ConfigStructures.spawnchanceSpawnAltars, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SWAMP));
                    this.generateStructure(StructureList.TREE_HOLE, world, random, blockX, blockZ, ConfigStructures.spawnchanceLogs, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE));
                    this.generateStructure(StructureList.DEAD_JUNGLE_TREE, world, random, blockX, blockZ, ConfigStructures.spawnchanceLogs, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE));
                    this.generateStructure(StructureList.JUNGLE_LOG, world, random, blockX, blockZ, ConfigStructures.spawnchanceLogs, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE));
                    this.generateStructure(StructureList.BIG_JUNGLE_LOG, world, random, blockX, blockZ, ConfigStructures.spawnchanceLogs, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE));
                    this.generateStructure(StructureList.FALLEN_JUNGLE_TREE, world, random, blockX, blockZ, ConfigStructures.spawnchanceFallenTrees, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE));
                    this.generateStructure(StructureList.OAK_LOG_SHORT, world, random, blockX, blockZ, ConfigStructures.spawnchanceLogs, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE));
                    this.generateBuryStructure(StructureList.MAYA_TEMPLE, world, random, blockX, blockZ, ConfigStructures.spawnchanceMayaTemple, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE));
                    this.generateDownsetStructure(StructureList.ALTAR_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceSpawnAltars, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE));
                    this.generateDownsetStructure(StructureList.ALTAR_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceSpawnAltars, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE));
                    this.generateDownsetStructure(StructureList.ALTAR_3, world, random, blockX, blockZ, ConfigStructures.spawnchanceSpawnAltars, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE));
                    this.generateDownsetStructure(StructureList.ALTAR_BIG_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceSpawnAltars, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE));
                    this.generateDownsetStructure(StructureList.ALTAR_BIG_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceSpawnAltars, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE));
                    this.generateDownsetStructure(StructureList.JUNGLE_TEMPLE, world, random, blockX, blockZ, ConfigStructures.spawnchanceTemple, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE));
                    this.generateUndergroundStructure(StructureList.FALL_TRAP, world, random, blockX, blockZ, ConfigStructures.spawnchanceTombs, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE));
                    this.generateUndergroundStructure(StructureList.TOMB, world, random, blockX, blockZ, ConfigStructures.spawnchanceTombs, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE));
                    this.generateUndergroundStructure(StructureList.TOMB_BIG, world, random, blockX, blockZ, ConfigStructures.spawnchanceTombs + 500, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE));
                    this.generateStructure(StructureList.MUSHROOM, world, random, blockX, blockZ, ConfigStructures.spawnchanceMushrooms, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE));
                    this.generateStructure(StructureList.OAK_LOG, world, random, blockX, blockZ, ConfigStructures.spawnchanceLogs, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.FOREST));
                    this.generateStructure(StructureList.OAK_LOG_SHORT, world, random, blockX, blockZ, ConfigStructures.spawnchanceLogs, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.FOREST));
                    this.generateStructure(StructureList.LOG_BUNDLE, world, random, blockX, blockZ, ConfigStructures.spawnchanceLogBundle, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.FOREST));
                    this.generateStructure(StructureList.DEAD_OAK_TREE, world, random, blockX, blockZ, ConfigStructures.spawnchanceLogs, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.FOREST));
                    this.generateStructure(StructureList.BUSH_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceBushes, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.FOREST));
                    this.generateStructure(StructureList.BUSH_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceBushes, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.FOREST));
                    this.generateStructure(StructureList.BUSH_3, world, random, blockX, blockZ, ConfigStructures.spawnchanceBushes, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.FOREST));
                    this.generateStructure(StructureList.SCARECROW, world, random, blockX, blockZ, ConfigStructures.spawnchanceScarecrow, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.FOREST));
                    this.generateStructure(StructureList.ROCK_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceRocks, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.FOREST));
                    this.generateStructure(StructureList.ROCK_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceRocks, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.FOREST));
                    this.generateStructure(StructureList.ROCK_3, world, random, blockX, blockZ, ConfigStructures.spawnchanceRocks, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.FOREST));
                    this.generateDownsetStructure(StructureList.ROCK_4, world, random, blockX, blockZ, ConfigStructures.spawnchanceRocks, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.FOREST));
                    this.generateStructure(StructureList.ROCK_COBBLE_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceRocks, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.FOREST));
                    this.generateStructure(StructureList.ROCK_COBBLE_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceRocks, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.FOREST));
                    this.generateStructure(StructureList.ROCK_COBBLE_3, world, random, blockX, blockZ, ConfigStructures.spawnchanceRocks, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.FOREST));
                    this.generateStructure(StructureList.FALLEN_OAK_TREE_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceFallenTrees, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.FOREST));
                    this.generateStructure(StructureList.FALLEN_OAK_TREE_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceFallenTrees, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.FOREST));
                    this.generateDownsetStructure(StructureList.ALTAR_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceSpawnAltars, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.FOREST));
                    this.generateDownsetStructure(StructureList.ALTAR_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceSpawnAltars, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.FOREST));
                    this.generateDownsetStructure(StructureList.ALTAR_3, world, random, blockX, blockZ, ConfigStructures.spawnchanceSpawnAltars, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.FOREST));
                    this.generateDownsetStructure(StructureList.ALTAR_BIG_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceSpawnAltars, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.FOREST));
                    this.generateDownsetStructure(StructureList.ALTAR_BIG_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceSpawnAltars, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.FOREST));
                    this.generateBuryStructure(StructureList.GRAVE, world, random, blockX, blockZ, ConfigStructures.spawnchanceGrave, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.FOREST));
                    this.generateStructure(StructureList.ILLAGER_HOUSE, world, random, blockX, blockZ, ConfigStructures.spawnchanceIllagerHouses, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.FOREST));
                    this.generateDownsetStructure(StructureList.NETHER_PORTAL, world, random, blockX, blockZ, ConfigStructures.spawnchanceNetherPortals, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.FOREST));
                    this.generateStructure(StructureList.VILLAGER_HOUSE, world, random, blockX, blockZ, ConfigStructures.spawnchanceVillagerHouses, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.FOREST));
                    this.generateStructure(StructureList.VILLAGER_HOUSE_SMALL, world, random, blockX, blockZ, ConfigStructures.spawnchanceVillagerHouses, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.FOREST));
                    this.generateBuryStructure(StructureList.WELL_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceWell, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.FOREST));
                    this.generateBuryStructure(StructureList.WELL_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceWell, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.FOREST));
                    this.generateStructure(StructureList.VILLAGER_HOUSE_BROCKEN, world, random, blockX, blockZ, ConfigStructures.spawnchanceVillagerHouses + 500, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.FOREST));
                    this.generateUndergroundStructure(StructureList.SPIDER_NEST_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceSpiderNests, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.FOREST));
                    this.generateUndergroundStructure(StructureList.SPIDER_NEST_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceSpiderNests, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.FOREST));
                    this.generateUndergroundStructure(StructureList.SPIDER_NEST_3, world, random, blockX, blockZ, ConfigStructures.spawnchanceSpiderNests, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.FOREST));
                    this.generateUndergroundStructure(StructureList.DUNGEON_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceUndergroundDungeons, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.FOREST));
                    this.generateUndergroundStructure(StructureList.DUNGEON_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceUndergroundDungeons, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.FOREST));
                    this.generateUndergroundStructure(StructureList.UNDERGROUND_BASE, world, random, blockX, blockZ, ConfigStructures.spawnchanceUndergroundBases, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.FOREST));
                    this.generateUndergroundStructure(StructureList.UNDERGROUND_VILLAGE, world, random, blockX, blockZ, ConfigStructures.spawnchanceUndergroundBases, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.FOREST));
                    this.generateUndergroundStructure(StructureList.UNDERGROUND_STOLLEN, world, random, blockX, blockZ, ConfigStructures.spawnchanceUndergroundBases, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.FOREST));
                    this.generateUndergroundStructure(StructureList.UNDERGROUND_PRISON, world, random, blockX, blockZ, ConfigStructures.spawnchanceUndergroundBases, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.FOREST));
                    this.generateUndergroundStructure(StructureList.SEWAGE_SYSTEM, world, random, blockX, blockZ, ConfigStructures.spawnchanceUndergroundBases, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.FOREST));
                    this.generateStructure(StructureList.RUIN, world, random, blockX, blockZ, ConfigStructures.spawnchanceRuins, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.FOREST));
                    this.generateUndergroundStructure(StructureList.TOMB, world, random, blockX, blockZ, ConfigStructures.spawnchanceTombs, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.FOREST));
                    this.generateUndergroundStructure(StructureList.TOMB_BIG, world, random, blockX, blockZ, ConfigStructures.spawnchanceTombs + 500, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.FOREST));
                    this.generateBuryStructure(StructureList.CHEST_TRAP, world, random, blockX, blockZ, ConfigStructures.spawnchanceTraps, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.FOREST));
                    this.generateUndergroundStructure(StructureList.UNDERGOUND_NETHER_PORTAL, world, random, blockX, blockZ, ConfigStructures.spawnchanceNetherPortals, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.FOREST));
                    this.generateDownsetStructure(StructureList.TOWER_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceTowers, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.FOREST));
                    this.generateDownsetStructure(StructureList.TOWER_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceTowers, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.FOREST));
                    this.generateStructure(StructureList.MUSHROOM, world, random, blockX, blockZ, ConfigStructures.spawnchanceMushrooms, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.FOREST));
                    this.generateDownsetStructure(StructureList.ALTAR_TOTEM_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceSpawnAltars, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.FOREST));
                    this.generateDownsetStructure(StructureList.ALTAR_TOTEM_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceSpawnAltars, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.FOREST));
                    this.generateDownsetStructure(StructureList.ALTAR_TOTEM_3, world, random, blockX, blockZ, ConfigStructures.spawnchanceSpawnAltars, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.FOREST));
                    this.generateStructure(StructureList.ROCK_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceRocks, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.PLAINS));
                    this.generateStructure(StructureList.ROCK_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceRocks, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.PLAINS));
                    this.generateStructure(StructureList.ROCK_3, world, random, blockX, blockZ, ConfigStructures.spawnchanceRocks, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.PLAINS));
                    this.generateDownsetStructure(StructureList.ROCK_4, world, random, blockX, blockZ, ConfigStructures.spawnchanceRocks, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.PLAINS));
                    this.generateDownsetStructure(StructureList.CAMP, world, random, blockX, blockZ, ConfigStructures.spawnchanceCamps, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.PLAINS));
                    this.generateStructure(StructureList.SCARECROW, world, random, blockX, blockZ, ConfigStructures.spawnchanceScarecrow, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.PLAINS));
                    this.generateStructure(StructureList.BUSH_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceBushes, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.PLAINS));
                    this.generateStructure(StructureList.BUSH_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceBushes, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.PLAINS));
                    this.generateStructure(StructureList.BUSH_3, world, random, blockX, blockZ, ConfigStructures.spawnchanceBushes, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.PLAINS));
                    this.generateBuryStructure(StructureList.GRAVE, world, random, blockX, blockZ, ConfigStructures.spawnchanceGrave, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.PLAINS));
                    this.generateBuryStructure(StructureList.MINE_ENTRY, world, random, blockX, blockZ, ConfigStructures.spawnchanceMineEntry, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.PLAINS));
                    this.generateStructure(StructureList.OAK_LOG_SHORT, world, random, blockX, blockZ, ConfigStructures.spawnchanceLogs, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.PLAINS));
                    this.generateStructure(StructureList.STONE_PILLAR, world, random, blockX, blockZ, ConfigStructures.spawnchanceStonePillars, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.PLAINS));
                    this.generateUndergroundStructure(StructureList.TOMB, world, random, blockX, blockZ, ConfigStructures.spawnchanceTombs, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.PLAINS));
                    this.generateStructure(StructureList.VILLAGER_HOUSE, world, random, blockX, blockZ, ConfigStructures.spawnchanceVillagerHouses, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.PLAINS));
                    this.generateStructure(StructureList.VILLAGER_HOUSE_SMALL, world, random, blockX, blockZ, ConfigStructures.spawnchanceVillagerHouses, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.PLAINS));
                    this.generateBuryStructure(StructureList.WALL_BIG, world, random, blockX, blockZ, ConfigStructures.spawnchanceWallRuins, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.PLAINS));
                    this.generateStructure(StructureList.WALL, world, random, blockX, blockZ, ConfigStructures.spawnchanceWallRuins, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.PLAINS));
                    this.generateStructure(StructureList.WHEAT_BALL, world, random, blockX, blockZ, ConfigStructures.spawnchanceWheatBalls, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.PLAINS));
                    this.generateBuryStructure(StructureList.WELL_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceWell, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.PLAINS));
                    this.generateBuryStructure(StructureList.WELL_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceWell, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.PLAINS));
                    this.generateDownsetStructure(StructureList.FARM, world, random, blockX, blockZ, ConfigStructures.spawnchanceFarm, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.PLAINS));
                    this.generateUndergroundStructure(StructureList.DUNGEON_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceUndergroundDungeons, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.PLAINS));
                    this.generateUndergroundStructure(StructureList.DUNGEON_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceUndergroundDungeons, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.PLAINS));
                    this.generateUndergroundStructure(StructureList.UNDERGROUND_BASE, world, random, blockX, blockZ, ConfigStructures.spawnchanceUndergroundBases, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.PLAINS));
                    this.generateUndergroundStructure(StructureList.TOMB_BIG, world, random, blockX, blockZ, ConfigStructures.spawnchanceTombs + 500, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.PLAINS));
                    this.generateUndergroundStructure(StructureList.UNDERGROUND_VILLAGE, world, random, blockX, blockZ, ConfigStructures.spawnchanceUndergroundBases, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.PLAINS));
                    this.generateUndergroundStructure(StructureList.UNDERGROUND_STOLLEN, world, random, blockX, blockZ, ConfigStructures.spawnchanceUndergroundBases, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.PLAINS));
                    this.generateUndergroundStructure(StructureList.UNDERGROUND_PRISON, world, random, blockX, blockZ, ConfigStructures.spawnchanceTombs, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.PLAINS));
                    this.generateUndergroundStructure(StructureList.SEWAGE_SYSTEM, world, random, blockX, blockZ, ConfigStructures.spawnchanceUndergroundBases, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.PLAINS));
                    this.generateStructure(StructureList.RUIN, world, random, blockX, blockZ, ConfigStructures.spawnchanceRuins, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.PLAINS));
                    this.generateBuryStructure(StructureList.STONE_CIRCLE_RUIN, world, random, blockX, blockZ, ConfigStructures.spawnchanceRuins, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.PLAINS));
                    this.generateDownsetStructure(StructureList.TOWER_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceTowers, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.PLAINS));
                    this.generateDownsetStructure(StructureList.TOWER_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceTowers, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.PLAINS));
                    this.generateStructure(StructureList.MUSHROOM, world, random, blockX, blockZ, ConfigStructures.spawnchanceMushrooms + 5000, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.PLAINS));
                    this.generateStructure(StructureList.ROCK_COBBLE_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceRocks, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN));
                    this.generateStructure(StructureList.ROCK_COBBLE_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceRocks, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN));
                    this.generateStructure(StructureList.ROCK_COBBLE_3, world, random, blockX, blockZ, ConfigStructures.spawnchanceRocks, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN));
                    this.generateStructure(StructureList.STONE_PILLAR, world, random, blockX, blockZ, ConfigStructures.spawnchanceStonePillars, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN));
                    this.generateBuryStructure(StructureList.LAVA_FOUNTAIN, world, random, blockX, blockZ, ConfigStructures.spawnchanceLavaFountain, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN));
                    this.generateBuryStructure(StructureList.METEOR, world, random, blockX, blockZ, ConfigStructures.spawnchanceMeteor, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN));
                    this.generateBuryStructure(StructureList.MINE_ENTRY, world, random, blockX, blockZ, ConfigStructures.spawnchanceMineEntry, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN));
                    this.generateUndergroundStructure(StructureList.TOMB, world, random, blockX, blockZ, ConfigStructures.spawnchanceTombs, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN));
                    this.generateBuryStructure(StructureList.FLAG, world, random, blockX, blockZ, ConfigStructures.spawnchanceOthers + 1500, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN));
                    this.generateUndergroundStructure(StructureList.SPIDER_NEST_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceSpiderNests, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN));
                    this.generateUndergroundStructure(StructureList.SPIDER_NEST_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceSpiderNests, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN));
                    this.generateUndergroundStructure(StructureList.SPIDER_NEST_3, world, random, blockX, blockZ, ConfigStructures.spawnchanceSpiderNests, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN));
                    this.generateUndergroundStructure(StructureList.UNDERGROUND_BASE, world, random, blockX, blockZ, ConfigStructures.spawnchanceUndergroundBases, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN));
                    this.generateUndergroundStructure(StructureList.UNDERGROUND_VILLAGE, world, random, blockX, blockZ, ConfigStructures.spawnchanceUndergroundBases, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN));
                    this.generateUndergroundStructure(StructureList.UNDERGROUND_STOLLEN, world, random, blockX, blockZ, ConfigStructures.spawnchanceUndergroundBases, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN));
                    this.generateUndergroundStructure(StructureList.UNDERGROUND_PRISON, world, random, blockX, blockZ, ConfigStructures.spawnchanceUndergroundBases, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN));
                    this.generateUndergroundStructure(StructureList.SEWAGE_SYSTEM, world, random, blockX, blockZ, ConfigStructures.spawnchanceUndergroundBases, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN));
                    this.generateUndergroundStructure(StructureList.DUNGEON_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceUndergroundDungeons, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN));
                    this.generateUndergroundStructure(StructureList.DUNGEON_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceUndergroundDungeons, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN));
                    this.generateUndergroundStructure(StructureList.TOMB_BIG, world, random, blockX, blockZ, ConfigStructures.spawnchanceTombs + 500, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN));
                    this.generateUndergroundStructure(StructureList.UNDERGOUND_NETHER_PORTAL, world, random, blockX, blockZ, ConfigStructures.spawnchanceNetherPortals, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN));
                    this.generateUndergroundStructure(StructureList.FALL_TRAP, world, random, blockX, blockZ, ConfigStructures.spawnchanceTombs, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN));
                    this.generateUndergroundStructure(StructureList.SILVERFISH_CLUSTER_SMALL, world, random, blockX, blockZ, ConfigStructures.spawnchanceSilverfishCluster, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN));
                    this.generateUndergroundStructure(StructureList.SILVERFISH_CLUSTER_BIG, world, random, blockX, blockZ, ConfigStructures.spawnchanceSilverfishCluster, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN));
                    this.generateStructure(StructureList.ACACIA_LOG, world, random, blockX, blockZ, ConfigStructures.spawnchanceLogs, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.MESA));
                    this.generateStructure(StructureList.SKULL, world, random, blockX, blockZ, ConfigStructures.spawnchanceSkulls, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.MESA));
                    this.generateStructure(StructureList.DEAD_TREE_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceDeadTrees, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.MESA));
                    this.generateStructure(StructureList.DEAD_TREE_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceDeadTrees, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.MESA));
                    this.generateStructure(StructureList.DEAD_TREE_3, world, random, blockX, blockZ, ConfigStructures.spawnchanceDeadTrees, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.MESA));
                    this.generateBuryStructure(StructureList.LAVA_FOUNTAIN, world, random, blockX, blockZ, ConfigStructures.spawnchanceLavaFountain, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.MESA));
                    this.generateStructure(StructureList.SAND_TOTEM_RED, world, random, blockX, blockZ, ConfigStructures.spawnchanceTotems, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.MESA));
                    this.generateDownsetStructure(StructureList.SAND_TOTEM_RED_BIG, world, random, blockX, blockZ, ConfigStructures.spawnchanceTotems, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.MESA));
                    this.generateDownsetStructure(StructureList.BOAT, world, random, blockX, blockZ, ConfigStructures.spawnchanceBoats, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.OCEAN));
                    this.generateDownsetStructure(StructureList.RAFT, world, random, blockX, blockZ, ConfigStructures.spawnchanceBoats, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.OCEAN));
                    this.generateDownsetStructure(StructureList.OAK_LOG, world, random, blockX, blockZ, ConfigStructures.spawnchanceFlotsam, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.OCEAN));
                    this.generateDownsetStructure(StructureList.FLOTSAM_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceFlotsam, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.OCEAN));
                    this.generateDownsetStructure(StructureList.FLOTSAM_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceFlotsam, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.OCEAN));
                    this.generateDownsetStructure(StructureList.FLOTSAM_3, world, random, blockX, blockZ, ConfigStructures.spawnchanceFlotsam, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.OCEAN));
                    this.generateStructure(StructureList.ACACIA_LOG, world, random, blockX, blockZ, ConfigStructures.spawnchanceLogs, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SAVANNA));
                    this.generateStructure(StructureList.SKULL, world, random, blockX, blockZ, ConfigStructures.spawnchanceSkulls, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SAVANNA));
                    this.generateStructure(StructureList.DEAD_TREE_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceDeadTrees, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SAVANNA));
                    this.generateStructure(StructureList.DEAD_TREE_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceDeadTrees, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SAVANNA));
                    this.generateStructure(StructureList.DEAD_TREE_3, world, random, blockX, blockZ, ConfigStructures.spawnchanceDeadTrees, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SAVANNA));
                    this.generateStructure(StructureList.FALLEN_DEAD_TREE_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceFallenTrees, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SAVANNA));
                    this.generateStructure(StructureList.FALLEN_DEAD_TREE_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceFallenTrees, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SAVANNA));
                    this.generateStructure(StructureList.FALLEN_DEAD_TREE_3, world, random, blockX, blockZ, ConfigStructures.spawnchanceFallenTrees, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SAVANNA));
                    this.generateStructure(StructureList.ACACIA_LOG, world, random, blockX, blockZ, ConfigStructures.spawnchanceLogs, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.WASTELAND));
                    this.generateStructure(StructureList.SKULL, world, random, blockX, blockZ, ConfigStructures.spawnchanceSkulls, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.WASTELAND));
                    this.generateStructure(StructureList.DEAD_TREE_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceDeadTrees, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.WASTELAND));
                    this.generateStructure(StructureList.DEAD_TREE_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceDeadTrees, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.WASTELAND));
                    this.generateStructure(StructureList.DEAD_TREE_3, world, random, blockX, blockZ, ConfigStructures.spawnchanceDeadTrees, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.WASTELAND));
                    this.generateBuryStructure(StructureList.HORCRUX, world, random, blockX, blockZ, ConfigStructures.spawnchanceSpecials, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.WASTELAND));
                    this.generateStructure(StructureList.FALLEN_DEAD_TREE_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceFallenTrees, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.WASTELAND));
                    this.generateStructure(StructureList.FALLEN_DEAD_TREE_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceFallenTrees, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.WASTELAND));
                    this.generateStructure(StructureList.FALLEN_DEAD_TREE_3, world, random, blockX, blockZ, ConfigStructures.spawnchanceFallenTrees, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.WASTELAND));
                    this.generateUndergroundStructure(StructureList.TOMB_BIG, world, random, blockX, blockZ, ConfigStructures.spawnchanceTombs + 500, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.WASTELAND));
                    this.generateUndergroundStructure(StructureList.UNDERGOUND_NETHER_PORTAL, world, random, blockX, blockZ, ConfigStructures.spawnchanceNetherPortals, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.WASTELAND));
                    this.generateUndergroundStructure(StructureList.FALL_TRAP, world, random, blockX, blockZ, ConfigStructures.spawnchanceTombs, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.WASTELAND));
                    this.generateDownsetStructure(StructureList.TOWER_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceTowers, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.WASTELAND));
                    this.generateDownsetStructure(StructureList.TOWER_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceTowers, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.WASTELAND));
                    this.generateDownsetStructure(StructureList.ALTAR_TOTEM_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceSpawnAltars, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.WASTELAND));
                    this.generateDownsetStructure(StructureList.ALTAR_TOTEM_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceSpawnAltars, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.WASTELAND));
                    this.generateDownsetStructure(StructureList.ALTAR_TOTEM_3, world, random, blockX, blockZ, ConfigStructures.spawnchanceSpawnAltars, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.WASTELAND));
                    this.generateUndergroundStructure(StructureList.SILVERFISH_CLUSTER_SMALL, world, random, blockX, blockZ, ConfigStructures.spawnchanceSilverfishCluster, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SPOOKY));
                    this.generateUndergroundStructure(StructureList.SILVERFISH_CLUSTER_BIG, world, random, blockX, blockZ, ConfigStructures.spawnchanceSilverfishCluster, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.HILLS));
                    this.generateUndergroundStructure(StructureList.UNDERGOUND_NETHER_PORTAL, world, random, blockX, blockZ, ConfigStructures.spawnchanceNetherPortals, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SPOOKY));
                    this.generateStructure(StructureList.SKULL, world, random, blockX, blockZ, ConfigStructures.spawnchanceSkulls, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SPOOKY));
                    this.generateDownsetStructure(StructureList.ALTAR_TOTEM_1, world, random, blockX, blockZ, ConfigStructures.spawnchanceSpawnAltars, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SPOOKY));
                    this.generateDownsetStructure(StructureList.ALTAR_TOTEM_2, world, random, blockX, blockZ, ConfigStructures.spawnchanceSpawnAltars, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SPOOKY));
                    this.generateDownsetStructure(StructureList.ALTAR_TOTEM_3, world, random, blockX, blockZ, ConfigStructures.spawnchanceSpawnAltars, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SPOOKY));
                }
            }
        }
    }

    private void generateStructure(WorldGenerator generator, World world, Random random, int blockX, int blockZ, int chance, Set<Biome> set) {
        int chanceModified = random.nextInt((int)Math.max(ConfigStructures.generationModifier * (float)chance, 1.0f));
        int blockY = StructureGenerator.getGroundFromAbove(world, blockX, blockZ);
        BlockPos pos = new BlockPos(blockX, blockY + 1, blockZ);
        Biome biome = world.func_175726_f(pos).func_177411_a(pos, world.func_72959_q());
        if (set.contains(biome) && chanceModified == 0) {
            generator.func_180709_b(world, random, pos);
        }
    }

    private void generateDownsetStructure(WorldGenerator generator, World world, Random random, int blockX, int blockZ, int chance, Set<Biome> set) {
        int chanceModified = random.nextInt((int)Math.max(ConfigStructures.generationModifier * (float)chance, 1.0f));
        int blockY = StructureGenerator.getGroundFromAbove(world, blockX, blockZ);
        BlockPos pos = new BlockPos(blockX, blockY, blockZ);
        Biome biome = world.func_175726_f(pos).func_177411_a(pos, world.func_72959_q());
        if (set.contains(biome) && chanceModified == 0) {
            generator.func_180709_b(world, random, pos);
        }
    }

    private void generateBuryStructure(WorldGenerator generator, World world, Random random, int blockX, int blockZ, int chance, Set<Biome> set) {
        int chanceModified = random.nextInt((int)Math.max(ConfigStructures.generationModifier * (float)chance, 1.0f));
        int blockY = StructureGenerator.getGroundFromAbove(world, blockX, blockZ);
        BlockPos pos = new BlockPos(blockX, blockY - 2, blockZ);
        Biome biome = world.func_175726_f(pos).func_177411_a(pos, world.func_72959_q());
        if (set.contains(biome) && chanceModified == 0) {
            generator.func_180709_b(world, random, pos);
        }
    }

    private void generateUndergroundStructure(WorldGenerator generator, World world, Random random, int blockX, int blockZ, int chance, Set<Biome> set) {
        int chanceModified = random.nextInt((int)Math.max(ConfigStructures.generationModifier * (float)chance, 1.0f));
        int blockY = StructureGenerator.getGroundFromAbove(world, blockX, blockZ);
        BlockPos pos = new BlockPos(blockX, (int)(Math.random() * (double)(blockY - 20 - 25 + 1)) + 25, blockZ);
        Biome biome = world.func_175726_f(pos).func_177411_a(pos, world.func_72959_q());
        if (set.contains(biome) && chanceModified == 0) {
            generator.func_180709_b(world, random, pos);
        }
    }

    private void generateFlyingStructure(WorldGenerator generator, World world, Random random, int blockX, int blockZ, int chance, Set<Biome> set) {
        int chanceModified = random.nextInt((int)Math.max(ConfigStructures.generationModifier * (float)chance, 1.0f));
        int blockY = StructureGenerator.getGroundFromAbove(world, blockX, blockZ);
        BlockPos pos = new BlockPos(blockX, random.nextInt(230) + blockY + 35, blockZ);
        Biome biome = world.func_175726_f(pos).func_177411_a(pos, world.func_72959_q());
        if (set.contains(biome) && chanceModified == 0) {
            generator.func_180709_b(world, random, pos);
        }
    }

    private static List<?> getBiomeList() {
        ArrayList<Class> biomeClassList = new ArrayList<Class>();
        for (Biome biome : biomeList) {
            if (biome == null) continue;
            biomeClassList.add(biome.func_150562_l());
        }
        return biomeClassList;
    }
}

