/*
 * Decompiled with CFR 0.152.
 */
package com.github.srwaggon.minecraft.block;

import com.github.srwaggon.minecraft.block.BlockType;
import com.github.srwaggon.minecraft.block.Material;
import com.github.srwaggon.minecraft.block.SingleBlockBrush;
import com.github.srwaggon.minecraft.block.decorative.AnvilBlock;
import com.github.srwaggon.minecraft.block.decorative.BedBlock;
import com.github.srwaggon.minecraft.block.decorative.CropBlock;
import com.github.srwaggon.minecraft.block.decorative.Plant;
import com.github.srwaggon.minecraft.block.decorative.PlantBlock;
import com.github.srwaggon.minecraft.block.decorative.PumpkinBlock;
import com.github.srwaggon.minecraft.block.decorative.TallPlant;
import com.github.srwaggon.minecraft.block.decorative.TallPlantBlock;
import com.github.srwaggon.minecraft.block.decorative.TorchBlock;
import com.github.srwaggon.minecraft.block.normal.ColoredBlock;
import com.github.srwaggon.minecraft.block.normal.InfestedBlock;
import com.github.srwaggon.minecraft.block.normal.Quartz;
import com.github.srwaggon.minecraft.block.normal.SlabBlock;
import com.github.srwaggon.minecraft.block.normal.StairsBlock;
import com.github.srwaggon.minecraft.block.normal.Stone;
import com.github.srwaggon.minecraft.block.normal.Wood;
import com.github.srwaggon.minecraft.block.redstone.ComparatorBlock;
import com.github.srwaggon.minecraft.block.redstone.DoorBlock;
import com.github.srwaggon.minecraft.block.redstone.LeverBlock;
import com.github.srwaggon.minecraft.block.redstone.RepeaterBlock;
import com.github.srwaggon.minecraft.block.redstone.TrapdoorBlock;
import com.google.gson.JsonElement;
import greymerk.roguelike.config.RogueConfig;
import greymerk.roguelike.util.DyeColor;
import greymerk.roguelike.worldgen.Direction;
import greymerk.roguelike.worldgen.MetaBlock1_2;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAnvil;
import net.minecraft.block.BlockBed;
import net.minecraft.block.BlockCocoa;
import net.minecraft.block.BlockColored;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockDropper;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockFurnace;
import net.minecraft.block.BlockHopper;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLever;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockNewLeaf;
import net.minecraft.block.BlockNewLog;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockPrismarine;
import net.minecraft.block.BlockPumpkin;
import net.minecraft.block.BlockQuartz;
import net.minecraft.block.BlockRedSandstone;
import net.minecraft.block.BlockRedstoneComparator;
import net.minecraft.block.BlockRedstoneRepeater;
import net.minecraft.block.BlockSand;
import net.minecraft.block.BlockSandStone;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.BlockSilverfish;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockStone;
import net.minecraft.block.BlockStoneBrick;
import net.minecraft.block.BlockStoneSlab;
import net.minecraft.block.BlockStoneSlabNew;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.BlockVine;
import net.minecraft.block.BlockWoodSlab;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;

public class BlockMapper1_12 {
    public static MetaBlock1_2 map(SingleBlockBrush block) {
        Direction facing = block.getFacing();
        EnumFacing enumFacing = facing.getFacing();
        switch (block.getBlockType()) {
            case ANVIL: {
                return BlockMapper1_12.getAnvil((AnvilBlock)block);
            }
            case ACACIA_LOG: {
                return BlockMapper1_12.getLogMetaBlock(Wood.ACACIA, facing);
            }
            case BIRCH_LOG: {
                return BlockMapper1_12.getLogMetaBlock(Wood.BIRCH, facing);
            }
            case DARK_OAK_LOG: {
                return BlockMapper1_12.getLogMetaBlock(Wood.DARK_OAK, facing);
            }
            case JUNGLE_LOG: {
                return BlockMapper1_12.getLogMetaBlock(Wood.JUNGLE, facing);
            }
            case OAK_LOG: {
                return BlockMapper1_12.getLogMetaBlock(Wood.OAK, facing);
            }
            case SPRUCE_LOG: {
                return BlockMapper1_12.getLogMetaBlock(Wood.SPRUCE, facing);
            }
            case ACACIA_FENCE: {
                return BlockMapper1_12.getFenceMetaBlock(Wood.ACACIA);
            }
            case BIRCH_FENCE: {
                return BlockMapper1_12.getFenceMetaBlock(Wood.BIRCH);
            }
            case DARK_OAK_FENCE: {
                return BlockMapper1_12.getFenceMetaBlock(Wood.DARK_OAK);
            }
            case JUNGLE_FENCE: {
                return BlockMapper1_12.getFenceMetaBlock(Wood.JUNGLE);
            }
            case OAK_FENCE: {
                return BlockMapper1_12.getFenceMetaBlock(Wood.OAK);
            }
            case SPRUCE_FENCE: {
                return BlockMapper1_12.getFenceMetaBlock(Wood.SPRUCE);
            }
            case ACACIA_PLANK: {
                return BlockMapper1_12.getPlankMetaBlock(Wood.ACACIA);
            }
            case BIRCH_PLANK: {
                return BlockMapper1_12.getPlankMetaBlock(Wood.BIRCH);
            }
            case DARK_OAK_PLANK: {
                return BlockMapper1_12.getPlankMetaBlock(Wood.DARK_OAK);
            }
            case JUNGLE_PLANK: {
                return BlockMapper1_12.getPlankMetaBlock(Wood.JUNGLE);
            }
            case OAK_PLANK: {
                return BlockMapper1_12.getPlankMetaBlock(Wood.OAK);
            }
            case SPRUCE_PLANK: {
                return BlockMapper1_12.getPlankMetaBlock(Wood.SPRUCE);
            }
            case OAK_LEAVES: {
                return BlockMapper1_12.getLeaves(Wood.OAK, true);
            }
            case SPRUCE_LEAVES: {
                return BlockMapper1_12.getLeaves(Wood.SPRUCE, true);
            }
            case BIRCH_LEAVES: {
                return BlockMapper1_12.getLeaves(Wood.BIRCH, true);
            }
            case JUNGLE_LEAVES: {
                return BlockMapper1_12.getLeaves(Wood.JUNGLE, true);
            }
            case ACACIA_LEAVES2: {
                return BlockMapper1_12.getLeaves(Wood.ACACIA, true);
            }
            case DARK_OAK_LEAVES: {
                return BlockMapper1_12.getLeaves(Wood.DARK_OAK, true);
            }
            case CARPET: 
            case CONCRETE: 
            case CONCRETE_POWDER: 
            case STAINED_GLASS: 
            case STAINED_GLASS_PANE: 
            case STAINED_HARDENED_CLAY: 
            case TERRACOTTA: 
            case WOOL: {
                return BlockMapper1_12.getColoredBlock((ColoredBlock)block);
            }
            case ACACIA_STAIRS: 
            case BIRCH_STAIRS: 
            case BRICK_STAIRS: 
            case DARK_OAK_STAIRS: 
            case JUNGLE_STAIRS: 
            case NETHER_BRICK_STAIRS: 
            case OAK_STAIRS: 
            case PURPUR_STAIRS: 
            case QUARTZ_STAIRS: 
            case RED_SANDSTONE_STAIRS: 
            case SANDSTONE_STAIRS: 
            case SPRUCE_STAIRS: 
            case STONE_BRICK_STAIRS: 
            case STONE_STAIRS: {
                return BlockMapper1_12.mapStairs((StairsBlock)block);
            }
            case ACACIA_SLAB: 
            case BIRCH_SLAB: 
            case BRICK_SLAB: 
            case COBBLE_SLAB: 
            case DARK_OAK_SLAB: 
            case JUNGLE_SLAB: 
            case LEGACY_OAK_SLAB: 
            case NETHERBRICK_SLAB: 
            case OAK_SLAB: 
            case QUARTZ_SLAB: 
            case RED_SANDSTONE_SLAB: 
            case SANDSTONE_SLAB: 
            case SMOOTH_RED_SANDSTONE_SLAB: 
            case SPRUCE_SLAB: 
            case STONEBRICK_SLAB: 
            case STONE_SLAB: {
                return BlockMapper1_12.getSlab((SlabBlock)block);
            }
            case IRON_DOOR: 
            case OAK_DOOR: 
            case BIRCH_DOOR: 
            case SPRUCE_DOOR: 
            case JUNGLE_DOOR: 
            case ACACIA_DOOR: 
            case DARK_OAK_DOOR: 
            case WARPED_DOOR: {
                return BlockMapper1_12.mapDoor((DoorBlock)block);
            }
            case CHISELED_QUARTZ: {
                return BlockMapper1_12.getQuartz(Quartz.CHISELED, facing);
            }
            case PILLAR_QUARTZ: {
                return BlockMapper1_12.getQuartz(Quartz.PILLAR, facing);
            }
            case SMOOTH_QUARTZ: {
                return BlockMapper1_12.getQuartz(Quartz.SMOOTH, facing);
            }
            case VINE: {
                return BlockMapper1_12.createVine(facing);
            }
            case CROP: {
                return BlockMapper1_12.getCrop((CropBlock)block);
            }
            case PUMPKIN: {
                return BlockMapper1_12.getPumpkin((PumpkinBlock)block);
            }
            case FLOWER_POT: {
                return new MetaBlock1_2(Blocks.field_150457_bL);
            }
            case BROWN_MUSHROOM: {
                return new MetaBlock1_2((Block)Blocks.field_150338_P);
            }
            case RED_MUSHROOM: {
                return new MetaBlock1_2((Block)Blocks.field_150337_Q);
            }
            case PLANT: {
                return BlockMapper1_12.getPlant((PlantBlock)block);
            }
            case TALL_PLANT: {
                return BlockMapper1_12.getTallPlant((TallPlantBlock)block);
            }
            case TRAPDOOR: {
                return BlockMapper1_12.getTrapdoor((TrapdoorBlock)block);
            }
            case LEVER: {
                return BlockMapper1_12.getLever((LeverBlock)block);
            }
            case TORCH: 
            case REDSTONE_TORCH: {
                return BlockMapper1_12.getTorch((TorchBlock)block);
            }
            case BED: {
                return BlockMapper1_12.getBed((BedBlock)block);
            }
            case FURNACE: {
                if (!RogueConfig.getBoolean(RogueConfig.FURNITURE)) {
                    return new MetaBlock1_2(Blocks.field_150347_e);
                }
                return new MetaBlock1_2(Blocks.field_150460_al).withProperty(BlockFurnace.field_176447_a, enumFacing);
            }
            case DISPENSER: {
                return new MetaBlock1_2(Blocks.field_150367_z).withProperty(BlockDispenser.field_176441_a, enumFacing);
            }
            case DROPPER: {
                return new MetaBlock1_2(Blocks.field_150409_cd).withProperty(BlockDropper.field_176441_a, enumFacing);
            }
            case HOPPER: {
                return new MetaBlock1_2((Block)Blocks.field_150438_bZ).withProperty(BlockHopper.field_176430_a, enumFacing);
            }
            case COMPARATOR: {
                return BlockMapper1_12.getComparator((ComparatorBlock)block);
            }
            case REPEATER: {
                return BlockMapper1_12.getRepeater((RepeaterBlock)block);
            }
            case PISTON: {
                return new MetaBlock1_2((Block)Blocks.field_150331_J).withProperty(BlockPistonBase.field_176387_N, enumFacing);
            }
            case STICKY_PISTON: {
                return new MetaBlock1_2((Block)Blocks.field_150320_F).withProperty(BlockPistonBase.field_176387_N, enumFacing);
            }
            case INFESTED_BLOCK: {
                return BlockMapper1_12.getInfestedBlock((InfestedBlock)block);
            }
        }
        return BlockMapper1_12.map(block.getBlockType());
    }

    private static MetaBlock1_2 getCrop(CropBlock cropBlock) {
        switch (cropBlock.getCrop()) {
            default: {
                return new MetaBlock1_2(Blocks.field_150464_aj);
            }
            case CARROTS: {
                return new MetaBlock1_2(Blocks.field_150459_bM);
            }
            case MELON_STEM: {
                return new MetaBlock1_2(Blocks.field_150394_bc);
            }
            case PUMPKIN_STEM: {
                return new MetaBlock1_2(Blocks.field_150393_bb);
            }
            case NETHER_WART: {
                return new MetaBlock1_2(Blocks.field_150388_bm);
            }
            case POTATOES: {
                return new MetaBlock1_2(Blocks.field_150469_bN);
            }
            case COCOA: 
        }
        return BlockMapper1_12.getCocoaBlock(cropBlock.getFacing());
    }

    private static MetaBlock1_2 getRepeater(RepeaterBlock block) {
        return new MetaBlock1_2((Block)(block.isPowered() ? Blocks.field_150416_aS : Blocks.field_150413_aR)).withProperty(BlockRedstoneRepeater.field_176410_b, block.getDelay()).withProperty(BlockRedstoneRepeater.field_185512_D, block.getFacing().getFacing());
    }

    private static MetaBlock1_2 getComparator(ComparatorBlock block) {
        return new MetaBlock1_2((Block)(block.isPowered() ? Blocks.field_150455_bV : Blocks.field_150441_bU)).withProperty(BlockRedstoneComparator.field_185512_D, block.getFacing().getFacing()).withProperty(BlockRedstoneComparator.field_176463_b, block.getMode() == ComparatorBlock.Mode.SUBTRACTION ? BlockRedstoneComparator.Mode.SUBTRACT : BlockRedstoneComparator.Mode.COMPARE);
    }

    private static MetaBlock1_2 getCocoaBlock(Direction facing) {
        return new MetaBlock1_2(Blocks.field_150375_by).withProperty(BlockCocoa.field_185512_D, facing.reverse().getFacing()).withProperty(BlockCocoa.field_176501_a, 2);
    }

    private static MetaBlock1_2 getLever(LeverBlock leverBlock) {
        Direction dir = leverBlock.getFacing();
        return new MetaBlock1_2(Blocks.field_150442_at).withProperty(BlockLever.field_176359_b, leverBlock.isActive()).withProperty(BlockLever.field_176360_a, dir == Direction.UP ? BlockLever.EnumOrientation.UP_X : (dir == Direction.DOWN ? BlockLever.EnumOrientation.DOWN_X : dir.reverse().getOrientation()));
    }

    public static MetaBlock1_2 map(BlockType blockType) {
        switch (blockType) {
            case WATER_STILL: {
                return new MetaBlock1_2((Block)Blocks.field_150355_j);
            }
            case WATER_FLOWING: {
                return new MetaBlock1_2((Block)Blocks.field_150358_i);
            }
            case LAVA_STILL: {
                return new MetaBlock1_2((Block)Blocks.field_150353_l);
            }
            case LAVA_FLOWING: {
                return new MetaBlock1_2((Block)Blocks.field_150356_k);
            }
            case FIRE: {
                return new MetaBlock1_2((Block)Blocks.field_150480_ab);
            }
            case IRON_BAR: {
                return new MetaBlock1_2(Blocks.field_150411_aY);
            }
            case STONE_SMOOTH: {
                return new MetaBlock1_2(Blocks.field_150348_b);
            }
            case GRANITE: {
                return new MetaBlock1_2(Blocks.field_150348_b, BlockStone.field_176247_a, BlockStone.EnumType.GRANITE);
            }
            case GRANITE_POLISHED: {
                return new MetaBlock1_2(Blocks.field_150348_b, BlockStone.field_176247_a, BlockStone.EnumType.GRANITE_SMOOTH);
            }
            case DIORITE: {
                return new MetaBlock1_2(Blocks.field_150348_b, BlockStone.field_176247_a, BlockStone.EnumType.DIORITE);
            }
            case DIORITE_POLISHED: {
                return new MetaBlock1_2(Blocks.field_150348_b, BlockStone.field_176247_a, BlockStone.EnumType.DIORITE_SMOOTH);
            }
            case ANDESITE: {
                return new MetaBlock1_2(Blocks.field_150348_b, BlockStone.field_176247_a, BlockStone.EnumType.ANDESITE);
            }
            case ANDESITE_POLISHED: {
                return new MetaBlock1_2(Blocks.field_150348_b, BlockStone.field_176247_a, BlockStone.EnumType.ANDESITE_SMOOTH);
            }
            case GRASS: {
                return new MetaBlock1_2((Block)Blocks.field_150349_c);
            }
            case DIRT: {
                return new MetaBlock1_2(Blocks.field_150346_d);
            }
            case DIRT_COARSE: {
                return new MetaBlock1_2(Blocks.field_150346_d, BlockDirt.field_176386_a, BlockDirt.DirtType.COARSE_DIRT);
            }
            case DIRT_PODZOL: {
                return new MetaBlock1_2(Blocks.field_150346_d, BlockDirt.field_176386_a, BlockDirt.DirtType.PODZOL);
            }
            case COBBLESTONE: {
                return new MetaBlock1_2(Blocks.field_150347_e);
            }
            case COBBLESTONE_WALL: {
                return new MetaBlock1_2(Blocks.field_150463_bK);
            }
            case BED: {
                return new MetaBlock1_2(Blocks.field_150324_C);
            }
            case BEDROCK: {
                return new MetaBlock1_2(Blocks.field_150357_h);
            }
            case SAND: {
                return new MetaBlock1_2((Block)Blocks.field_150354_m);
            }
            case SAND_RED: {
                return new MetaBlock1_2((Block)Blocks.field_150354_m, BlockSand.field_176504_a, BlockSand.EnumType.RED_SAND);
            }
            case GRAVEL: {
                return new MetaBlock1_2(Blocks.field_150351_n);
            }
            case ORE_GOLD: {
                return new MetaBlock1_2(Blocks.field_150352_o);
            }
            case ORE_IRON: {
                return new MetaBlock1_2(Blocks.field_150366_p);
            }
            case ORE_COAL: {
                return new MetaBlock1_2(Blocks.field_150402_ci);
            }
            case GLASS: {
                return new MetaBlock1_2(Blocks.field_150359_w);
            }
            case GLASS_PANE: {
                return new MetaBlock1_2(Blocks.field_150410_aZ);
            }
            case STAINED_GLASS: {
                return BlockMapper1_12.map(BlockType.STAINED_GLASS.getBrush());
            }
            case STAINED_GLASS_PANE: {
                return BlockMapper1_12.map(BlockType.STAINED_GLASS_PANE.getBrush());
            }
            case ORE_LAPIS: {
                return new MetaBlock1_2(Blocks.field_150369_x);
            }
            case LAPIS_BLOCK: {
                return new MetaBlock1_2(Blocks.field_150368_y);
            }
            case ORE_EMERALD: {
                return new MetaBlock1_2(Blocks.field_150412_bA);
            }
            case SANDSTONE: {
                return new MetaBlock1_2(Blocks.field_150322_A);
            }
            case CHISELED_SANDSTONE: {
                return new MetaBlock1_2(Blocks.field_150322_A, BlockSandStone.field_176297_a, BlockSandStone.EnumType.CHISELED);
            }
            case SANDSTONE_SMOOTH: {
                return new MetaBlock1_2(Blocks.field_150322_A, BlockSandStone.field_176297_a, BlockSandStone.EnumType.SMOOTH);
            }
            case GOLD_BLOCK: {
                return new MetaBlock1_2(Blocks.field_150340_R);
            }
            case IRON_BLOCK: {
                return new MetaBlock1_2(Blocks.field_150339_S);
            }
            case BRICK: {
                return new MetaBlock1_2(Blocks.field_150336_V);
            }
            case COBBLESTONE_MOSSY: {
                return new MetaBlock1_2(Blocks.field_150341_Y);
            }
            case OBSIDIAN: {
                return new MetaBlock1_2(Blocks.field_150343_Z);
            }
            case ORE_DIAMOND: {
                return new MetaBlock1_2(Blocks.field_150482_ag);
            }
            case DIAMOND_BLOCK: {
                return new MetaBlock1_2(Blocks.field_150484_ah);
            }
            case FARMLAND: {
                return new MetaBlock1_2(Blocks.field_150458_ak);
            }
            case ORE_REDSTONE: {
                return new MetaBlock1_2(Blocks.field_150450_ax);
            }
            case ICE: {
                return new MetaBlock1_2(Blocks.field_150432_aD);
            }
            case SNOW: {
                return new MetaBlock1_2(Blocks.field_150433_aE);
            }
            case CLAY: {
                return new MetaBlock1_2(Blocks.field_150435_aG);
            }
            case NETHERRACK: {
                return new MetaBlock1_2(Blocks.field_150424_aL);
            }
            case SOUL_SAND: {
                return new MetaBlock1_2(Blocks.field_150425_aM);
            }
            case GLOWSTONE: {
                return new MetaBlock1_2(Blocks.field_150426_aN);
            }
            case STONE_BRICK: {
                return new MetaBlock1_2(Blocks.field_150417_aV);
            }
            case STONE_BRICK_MOSSY: {
                return new MetaBlock1_2(Blocks.field_150417_aV, BlockStoneBrick.field_176249_a, BlockStoneBrick.EnumType.MOSSY);
            }
            case STONE_BRICK_CRACKED: {
                return new MetaBlock1_2(Blocks.field_150417_aV, BlockStoneBrick.field_176249_a, BlockStoneBrick.EnumType.CRACKED);
            }
            case STONE_BRICK_CHISELED: {
                return new MetaBlock1_2(Blocks.field_150417_aV, BlockStoneBrick.field_176249_a, BlockStoneBrick.EnumType.CHISELED);
            }
            case MYCELIUM: {
                return new MetaBlock1_2((Block)Blocks.field_150391_bh);
            }
            case NETHERBRICK: {
                return new MetaBlock1_2(Blocks.field_150385_bj);
            }
            case END_STONE: {
                return new MetaBlock1_2(Blocks.field_150377_bs);
            }
            case EMERALD_BLOCK: {
                return new MetaBlock1_2(Blocks.field_150475_bE);
            }
            case ORE_QUARTZ: {
                return new MetaBlock1_2(Blocks.field_150449_bY);
            }
            case PRISMITE: {
                return new MetaBlock1_2(Blocks.field_180397_cI, BlockPrismarine.field_176332_a, BlockPrismarine.EnumType.ROUGH);
            }
            case PRISMARINE: {
                return new MetaBlock1_2(Blocks.field_180397_cI, BlockPrismarine.field_176332_a, BlockPrismarine.EnumType.BRICKS);
            }
            case PRISMARINE_DARK: {
                return new MetaBlock1_2(Blocks.field_180397_cI, BlockPrismarine.field_176332_a, BlockPrismarine.EnumType.DARK);
            }
            case SEA_LANTERN: {
                return new MetaBlock1_2(Blocks.field_180398_cJ);
            }
            case COAL_BLOCK: {
                return new MetaBlock1_2(Blocks.field_150402_ci);
            }
            case ICE_PACKED: {
                return new MetaBlock1_2(Blocks.field_150403_cj);
            }
            case RED_SANDSTONE: {
                return new MetaBlock1_2(Blocks.field_180395_cM);
            }
            case CHISELED_RED_SANDSTONE: {
                return new MetaBlock1_2(Blocks.field_180395_cM, BlockRedSandstone.field_176336_a, BlockRedSandstone.EnumType.CHISELED);
            }
            case SMOOTH_RED_SANDSTONE: {
                return new MetaBlock1_2(Blocks.field_180395_cM, BlockRedSandstone.field_176336_a, BlockRedSandstone.EnumType.SMOOTH);
            }
            case QUARTZ: {
                return new MetaBlock1_2(Blocks.field_150371_ca);
            }
            case REDSTONE_BLOCK: {
                return new MetaBlock1_2(Blocks.field_150451_bX);
            }
            case PRESSURE_PLATE_STONE: {
                return new MetaBlock1_2(Blocks.field_150456_au);
            }
            case PRESSURE_PLATE_WOODEN: {
                return new MetaBlock1_2(Blocks.field_150452_aw);
            }
            case BOOKSHELF: {
                return new MetaBlock1_2(Blocks.field_150342_X);
            }
            case REDSTONE_WIRE: {
                return new MetaBlock1_2((Block)Blocks.field_150488_af);
            }
            case REEDS: {
                return new MetaBlock1_2((Block)Blocks.field_150436_aH);
            }
            case CRAFTING_TABLE: {
                return !RogueConfig.getBoolean(RogueConfig.FURNITURE) ? BlockMapper1_12.getPlankMetaBlock(Wood.OAK) : new MetaBlock1_2(Blocks.field_150462_ai);
            }
            case NOTEBLOCK: {
                return new MetaBlock1_2(Blocks.field_150323_B);
            }
            case REDSTONE_LAMP: {
                return new MetaBlock1_2(Blocks.field_150379_bu);
            }
            case REDSTONE_LAMP_LIT: {
                return new MetaBlock1_2(Blocks.field_150374_bv);
            }
            case JUKEBOX: {
                return new MetaBlock1_2(Blocks.field_150421_aI);
            }
            case TNT: {
                return new MetaBlock1_2(Blocks.field_150335_W);
            }
            case ENCHANTING_TABLE: {
                return new MetaBlock1_2(Blocks.field_150381_bn);
            }
            case FENCE_NETHER_BRICK: {
                return new MetaBlock1_2(Blocks.field_150386_bk);
            }
            case WEB: {
                return new MetaBlock1_2(Blocks.field_150321_G);
            }
            case VINE: {
                return new MetaBlock1_2(Blocks.field_150395_bd);
            }
            case PURPUR_BLOCK: {
                return new MetaBlock1_2(Blocks.field_185767_cT);
            }
            case PURPUR_PILLAR: {
                return new MetaBlock1_2(Blocks.field_185768_cU);
            }
            case PURPUR_STAIR: {
                return new MetaBlock1_2(Blocks.field_185769_cV);
            }
            case PURPUR_DOUBLE_SLAB: {
                return new MetaBlock1_2((Block)Blocks.field_185770_cW);
            }
            case PURPUR_SLAB: {
                return new MetaBlock1_2((Block)Blocks.field_185771_cX);
            }
            case ENDER_BRICK: {
                return new MetaBlock1_2(Blocks.field_185772_cY);
            }
            case MAGMA: {
                return new MetaBlock1_2(Blocks.field_189877_df);
            }
            case RED_NETHERBRICK: {
                return new MetaBlock1_2(Blocks.field_189879_dh);
            }
            case NETHER_WART_BLOCK: {
                return new MetaBlock1_2(Blocks.field_189878_dg);
            }
            case OAK_SAPLING: {
                return BlockMapper1_12.getSapling(Wood.OAK);
            }
            case SPRUCE_SAPLING: {
                return BlockMapper1_12.getSapling(Wood.SPRUCE);
            }
            case BIRCH_SAPLING: {
                return BlockMapper1_12.getSapling(Wood.BIRCH);
            }
            case BONE_BLOCK: {
                return new MetaBlock1_2(Blocks.field_189880_di);
            }
            case BREWING_STAND: {
                return new MetaBlock1_2(Blocks.field_150382_bo);
            }
            case BROWN_MUSHROOM: {
                return new MetaBlock1_2((Block)Blocks.field_150338_P);
            }
            case CACTUS: {
                return new MetaBlock1_2((Block)Blocks.field_150434_aF);
            }
            case CAKE: {
                return new MetaBlock1_2(Blocks.field_150414_aQ);
            }
            case CARPET: {
                return new MetaBlock1_2(Blocks.field_150404_cg);
            }
            case CHEST: {
                return new MetaBlock1_2((Block)Blocks.field_150486_ae);
            }
            case TRAPPED_CHEST: {
                return new MetaBlock1_2(Blocks.field_150447_bR);
            }
            case MOB_SPAWNER: {
                return new MetaBlock1_2(Blocks.field_150474_ac);
            }
            case CONCRETE: {
                return new MetaBlock1_2(Blocks.field_192443_dR);
            }
            case ENDER_CHEST: {
                return new MetaBlock1_2(Blocks.field_150477_bB);
            }
            case FURNACE: {
                return new MetaBlock1_2(Blocks.field_150460_al);
            }
            case RED_FLOWER: {
                return new MetaBlock1_2((Block)Blocks.field_150328_O);
            }
            case RED_MUSHROOM: {
                return new MetaBlock1_2((Block)Blocks.field_150337_Q);
            }
            case SKULL: {
                return new MetaBlock1_2((Block)Blocks.field_150465_bP);
            }
            case TALL_PLANT: {
                return new MetaBlock1_2((Block)Blocks.field_150329_H);
            }
            case COMPARATOR: {
                return new MetaBlock1_2((Block)Blocks.field_150441_bU);
            }
            case WOOL: {
                return new MetaBlock1_2(Blocks.field_150325_L);
            }
            case YELLOW_FLOWER: {
                return new MetaBlock1_2((Block)Blocks.field_150327_N);
            }
            case HOPPER: {
                return new MetaBlock1_2((Block)Blocks.field_150438_bZ);
            }
            case DISPENSER: {
                return new MetaBlock1_2(Blocks.field_150367_z);
            }
            case PISTON: {
                return new MetaBlock1_2((Block)Blocks.field_150331_J);
            }
            case JUNGLE_SAPLING: {
                return BlockMapper1_12.getSapling(Wood.JUNGLE);
            }
            case ACACIA_SAPLING: {
                return BlockMapper1_12.getSapling(Wood.ACACIA);
            }
            case DARK_OAK_SAPLING: {
                return BlockMapper1_12.getSapling(Wood.DARK_OAK);
            }
            case TORCH: {
                return BlockMapper1_12.map(BlockType.TORCH.getBrush());
            }
            case REDSTONE_TORCH: {
                return BlockMapper1_12.map(BlockType.REDSTONE_TORCH.getBrush());
            }
        }
        return new MetaBlock1_2(Blocks.field_150350_a);
    }

    private static MetaBlock1_2 getColoredBlock(ColoredBlock coloredBlock) {
        if (coloredBlock.getBlockType() == BlockType.TERRACOTTA) {
            return new MetaBlock1_2(BlockMapper1_12.getTerracottaByColor(coloredBlock.getColor()));
        }
        return new MetaBlock1_2(BlockMapper1_12.getBlock(coloredBlock.getBlockType())).withProperty(BlockColored.field_176581_a, DyeColor.get(coloredBlock.getColor()));
    }

    private static Block getBlock(BlockType type) {
        switch (type) {
            case STAINED_HARDENED_CLAY: {
                return Blocks.field_150406_ce;
            }
            case CARPET: {
                return Blocks.field_150404_cg;
            }
            case STAINED_GLASS: {
                return Blocks.field_150399_cn;
            }
            case STAINED_GLASS_PANE: {
                return Blocks.field_150397_co;
            }
            case CONCRETE: {
                return Blocks.field_192443_dR;
            }
            case CONCRETE_POWDER: {
                return Blocks.field_192444_dS;
            }
        }
        return Blocks.field_150325_L;
    }

    public static MetaBlock1_2 getBed(BedBlock bedBlock) {
        return new MetaBlock1_2(Blocks.field_150324_C).withProperty(BlockBed.field_185512_D, bedBlock.getFacing().getFacing()).withProperty(BlockBed.field_176472_a, bedBlock.isHead() ? BlockBed.EnumPartType.HEAD : BlockBed.EnumPartType.FOOT);
    }

    public static MetaBlock1_2 getPumpkin(PumpkinBlock block) {
        return new MetaBlock1_2(block.isLit() ? Blocks.field_150428_aP : Blocks.field_150423_aK).withProperty(BlockPumpkin.field_185512_D, block.getFacing().getFacing());
    }

    public static MetaBlock1_2 getAnvil(AnvilBlock block) {
        if (!RogueConfig.getBoolean(RogueConfig.FURNITURE)) {
            return BlockMapper1_12.map(BlockType.ANDESITE_POLISHED);
        }
        return new MetaBlock1_2(Blocks.field_150467_bQ).withProperty(BlockAnvil.field_176505_b, block.getDamage().ordinal()).withProperty(BlockAnvil.field_176506_a, block.getFacing().getFacing());
    }

    public static MetaBlock1_2 mapStairs(StairsBlock block) {
        JsonElement json = block.getJson();
        MetaBlock1_2 metaBlock1_2 = json != null ? new MetaBlock1_2(json) : new MetaBlock1_2(BlockMapper1_12.getBlockForStairs(block.getBlockType()));
        return metaBlock1_2.withProperty(BlockStairs.field_176309_a, block.getFacing().getFacing()).withProperty(BlockStairs.field_176308_b, block.isUpsideDown() ? BlockStairs.EnumHalf.TOP : BlockStairs.EnumHalf.BOTTOM);
    }

    public static Block getBlockForStairs(BlockType stairs) {
        switch (stairs) {
            case ACACIA_STAIRS: {
                return Blocks.field_150400_ck;
            }
            case BIRCH_STAIRS: {
                return Blocks.field_150487_bG;
            }
            case BRICK_STAIRS: {
                return Blocks.field_150389_bf;
            }
            case DARK_OAK_STAIRS: {
                return Blocks.field_150401_cl;
            }
            case JUNGLE_STAIRS: {
                return Blocks.field_150481_bH;
            }
            case NETHER_BRICK_STAIRS: {
                return Blocks.field_150387_bl;
            }
            case OAK_STAIRS: {
                return Blocks.field_150476_ad;
            }
            case PURPUR_STAIRS: {
                return Blocks.field_185769_cV;
            }
            case QUARTZ_STAIRS: {
                return Blocks.field_150370_cb;
            }
            case RED_SANDSTONE_STAIRS: {
                return Blocks.field_180396_cN;
            }
            case SANDSTONE_STAIRS: {
                return Blocks.field_150372_bz;
            }
            case SPRUCE_STAIRS: {
                return Blocks.field_150485_bF;
            }
            case STONE_BRICK_STAIRS: {
                return Blocks.field_150390_bg;
            }
        }
        return Blocks.field_150446_ar;
    }

    private static MetaBlock1_2 getTrapdoor(TrapdoorBlock block) {
        return new MetaBlock1_2((Block)(block.getMaterial() == Material.METAL ? Blocks.field_150454_av : Blocks.field_150415_aT)).withProperty(BlockTrapDoor.field_176285_M, block.isFlushWithTop() ? BlockTrapDoor.DoorHalf.TOP : BlockTrapDoor.DoorHalf.BOTTOM).withProperty(BlockTrapDoor.field_176283_b, block.isOpen()).withProperty(BlockTrapDoor.field_176284_a, block.getFacing().getFacing());
    }

    public static MetaBlock1_2 mapDoor(DoorBlock block) {
        JsonElement json = block.getJson();
        MetaBlock1_2 doorMetaBlock = json != null ? new MetaBlock1_2(json) : BlockMapper1_12.getDoorMetaBlock(block.getBlockType());
        return doorMetaBlock.withProperty(BlockDoor.field_176523_O, block.isTop() ? BlockDoor.EnumDoorHalf.UPPER : BlockDoor.EnumDoorHalf.LOWER).withProperty(BlockDoor.field_176520_a, block.getFacing().getFacing()).withProperty(BlockDoor.field_176519_b, block.isOpen()).withProperty(BlockDoor.field_176521_M, block.isHingeLeft() ? BlockDoor.EnumHingePosition.LEFT : BlockDoor.EnumHingePosition.RIGHT);
    }

    private static MetaBlock1_2 getDoorMetaBlock(BlockType type) {
        switch (type) {
            case IRON_DOOR: {
                return new MetaBlock1_2((Block)Blocks.field_150454_av);
            }
            case BIRCH_DOOR: {
                return new MetaBlock1_2((Block)Blocks.field_180412_aq);
            }
            case SPRUCE_DOOR: {
                return new MetaBlock1_2((Block)Blocks.field_180414_ap);
            }
            case JUNGLE_DOOR: {
                return new MetaBlock1_2((Block)Blocks.field_180411_ar);
            }
            case ACACIA_DOOR: {
                return new MetaBlock1_2((Block)Blocks.field_180410_as);
            }
            case DARK_OAK_DOOR: {
                return new MetaBlock1_2((Block)Blocks.field_180409_at);
            }
        }
        return new MetaBlock1_2((Block)Blocks.field_180413_ao);
    }

    private static MetaBlock1_2 getSlab(SlabBlock slabBlock) {
        Block minecraftBlock = BlockMapper1_12.getSlabMinecraftBlock(slabBlock.getBlockType(), slabBlock.isFullBlock());
        MetaBlock1_2 metaBlock = new MetaBlock1_2(minecraftBlock);
        switch (slabBlock.getBlockType()) {
            case STONE_SLAB: {
                metaBlock.withProperty(BlockStoneSlab.field_176556_M, BlockStoneSlab.EnumType.STONE);
                break;
            }
            case SANDSTONE_SLAB: {
                metaBlock.withProperty(BlockStoneSlab.field_176556_M, BlockStoneSlab.EnumType.SAND);
                break;
            }
            case LEGACY_OAK_SLAB: {
                metaBlock.withProperty(BlockStoneSlab.field_176556_M, BlockStoneSlab.EnumType.WOOD);
                break;
            }
            case COBBLE_SLAB: {
                metaBlock.withProperty(BlockStoneSlab.field_176556_M, BlockStoneSlab.EnumType.COBBLESTONE);
                break;
            }
            case BRICK_SLAB: {
                metaBlock.withProperty(BlockStoneSlab.field_176556_M, BlockStoneSlab.EnumType.BRICK);
                break;
            }
            case STONEBRICK_SLAB: {
                metaBlock.withProperty(BlockStoneSlab.field_176556_M, BlockStoneSlab.EnumType.SMOOTHBRICK);
                break;
            }
            case NETHERBRICK_SLAB: {
                metaBlock.withProperty(BlockStoneSlab.field_176556_M, BlockStoneSlab.EnumType.NETHERBRICK);
                break;
            }
            case QUARTZ_SLAB: {
                metaBlock.withProperty(BlockStoneSlab.field_176556_M, BlockStoneSlab.EnumType.QUARTZ);
                break;
            }
            case RED_SANDSTONE_SLAB: 
            case SMOOTH_RED_SANDSTONE_SLAB: {
                metaBlock.withProperty(BlockStoneSlabNew.field_176559_M, BlockStoneSlabNew.EnumType.RED_SANDSTONE);
                break;
            }
            case OAK_SLAB: {
                metaBlock.withProperty(BlockWoodSlab.field_176557_b, BlockPlanks.EnumType.OAK);
                break;
            }
            case SPRUCE_SLAB: {
                metaBlock.withProperty(BlockWoodSlab.field_176557_b, BlockPlanks.EnumType.SPRUCE);
                break;
            }
            case BIRCH_SLAB: {
                metaBlock.withProperty(BlockWoodSlab.field_176557_b, BlockPlanks.EnumType.BIRCH);
                break;
            }
            case JUNGLE_SLAB: {
                metaBlock.withProperty(BlockWoodSlab.field_176557_b, BlockPlanks.EnumType.JUNGLE);
                break;
            }
            case ACACIA_SLAB: {
                metaBlock.withProperty(BlockWoodSlab.field_176557_b, BlockPlanks.EnumType.ACACIA);
                break;
            }
            case DARK_OAK_SLAB: {
                metaBlock.withProperty(BlockWoodSlab.field_176557_b, BlockPlanks.EnumType.DARK_OAK);
                break;
            }
        }
        if (!slabBlock.isFullBlock() && slabBlock.isTop()) {
            metaBlock.withProperty(BlockWoodSlab.field_176554_a, BlockSlab.EnumBlockHalf.TOP);
        }
        if (slabBlock.isFullBlock() && slabBlock.isSeamless()) {
            metaBlock.withProperty(BlockStoneSlab.field_176555_b, true);
        }
        return metaBlock;
    }

    public static Block getSlabMinecraftBlock(BlockType blockType, boolean isFullBlock) {
        switch (blockType) {
            case BRICK_SLAB: 
            case COBBLE_SLAB: 
            case LEGACY_OAK_SLAB: 
            case NETHERBRICK_SLAB: 
            case QUARTZ_SLAB: 
            case SANDSTONE_SLAB: 
            case STONEBRICK_SLAB: 
            case STONE_SLAB: {
                return isFullBlock ? Blocks.field_150334_T : Blocks.field_150333_U;
            }
            case SMOOTH_RED_SANDSTONE_SLAB: 
            case RED_SANDSTONE: {
                return isFullBlock ? Blocks.field_180388_cO : Blocks.field_180389_cP;
            }
            case ACACIA_SLAB: 
            case BIRCH_SLAB: 
            case DARK_OAK_SLAB: 
            case JUNGLE_SLAB: 
            case OAK_SLAB: 
            case SPRUCE_SLAB: {
                return isFullBlock ? Blocks.field_150373_bw : Blocks.field_150376_bx;
            }
        }
        return Blocks.field_150333_U;
    }

    public static MetaBlock1_2 getTorch(TorchBlock torchBlock) {
        Block minecraftTorchBlock = !torchBlock.isLit() ? Blocks.field_150437_az : (torchBlock.getBlockType() == BlockType.REDSTONE_TORCH ? Blocks.field_150429_aA : Blocks.field_150478_aa);
        Direction dir = torchBlock.getFacing();
        EnumFacing facing = dir == Direction.UP ? EnumFacing.UP : (dir == Direction.DOWN ? EnumFacing.DOWN : dir.reverse().getFacing());
        return new MetaBlock1_2(minecraftTorchBlock).withProperty(BlockTorch.field_176596_a, facing);
    }

    public static Block getTerracottaByColor(DyeColor color) {
        switch (color) {
            case WHITE: {
                return Blocks.field_192427_dB;
            }
            case ORANGE: {
                return Blocks.field_192428_dC;
            }
            case MAGENTA: {
                return Blocks.field_192429_dD;
            }
            case LIGHT_BLUE: {
                return Blocks.field_192430_dE;
            }
            case YELLOW: {
                return Blocks.field_192431_dF;
            }
            case LIME: {
                return Blocks.field_192432_dG;
            }
            case PINK: {
                return Blocks.field_192433_dH;
            }
            case GRAY: {
                return Blocks.field_192434_dI;
            }
            case LIGHT_GRAY: {
                return Blocks.field_192435_dJ;
            }
            case CYAN: {
                return Blocks.field_192436_dK;
            }
            case PURPLE: {
                return Blocks.field_192437_dL;
            }
            case BLUE: {
                return Blocks.field_192438_dM;
            }
            case BROWN: {
                return Blocks.field_192439_dN;
            }
            case GREEN: {
                return Blocks.field_192440_dO;
            }
            case RED: {
                return Blocks.field_192441_dP;
            }
        }
        return Blocks.field_192442_dQ;
    }

    public static MetaBlock1_2 getLogMetaBlock(Wood type, Direction facing) {
        Block minecraftLogBlock = BlockMapper1_12.getMinecraftLogBlock(type);
        MetaBlock1_2 log = new MetaBlock1_2(minecraftLogBlock);
        MetaBlock1_2 logWithVariants = BlockMapper1_12.addLogVariants(log, type);
        return BlockMapper1_12.addLogFacing(logWithVariants, facing);
    }

    private static MetaBlock1_2 addLogFacing(MetaBlock1_2 log, Direction facing) {
        switch (facing) {
            case UP: 
            case DOWN: {
                return log.withProperty(BlockLog.field_176299_a, BlockLog.EnumAxis.Y);
            }
            case EAST: 
            case WEST: {
                return log.withProperty(BlockLog.field_176299_a, BlockLog.EnumAxis.X);
            }
            case NORTH: 
            case SOUTH: {
                return log.withProperty(BlockLog.field_176299_a, BlockLog.EnumAxis.Z);
            }
        }
        return log.withProperty(BlockLog.field_176299_a, BlockLog.EnumAxis.NONE);
    }

    public static Block getMinecraftLogBlock(Wood type) {
        switch (type) {
            default: {
                return Blocks.field_150364_r;
            }
            case ACACIA: 
            case DARK_OAK: 
        }
        return Blocks.field_150363_s;
    }

    private static MetaBlock1_2 addLogVariants(MetaBlock1_2 log, Wood wood) {
        switch (wood) {
            default: {
                return log.withProperty(BlockOldLog.field_176301_b, BlockMapper1_12.getWoodVariant(wood));
            }
            case ACACIA: 
            case DARK_OAK: 
        }
        return log.withProperty(BlockNewLog.field_176300_b, BlockMapper1_12.getWoodVariant(wood));
    }

    public static MetaBlock1_2 getPlankMetaBlock(Wood type) {
        MetaBlock1_2 plank = new MetaBlock1_2(Blocks.field_150344_f);
        switch (type) {
            default: {
                return plank.withProperty(BlockPlanks.field_176383_a, BlockPlanks.EnumType.OAK);
            }
            case SPRUCE: {
                return plank.withProperty(BlockPlanks.field_176383_a, BlockPlanks.EnumType.SPRUCE);
            }
            case BIRCH: {
                return plank.withProperty(BlockPlanks.field_176383_a, BlockPlanks.EnumType.BIRCH);
            }
            case JUNGLE: {
                return plank.withProperty(BlockPlanks.field_176383_a, BlockPlanks.EnumType.JUNGLE);
            }
            case ACACIA: {
                return plank.withProperty(BlockPlanks.field_176383_a, BlockPlanks.EnumType.ACACIA);
            }
            case DARK_OAK: 
        }
        return plank.withProperty(BlockPlanks.field_176383_a, BlockPlanks.EnumType.DARK_OAK);
    }

    public static MetaBlock1_2 getFenceMetaBlock(Wood type) {
        switch (type) {
            case SPRUCE: {
                return new MetaBlock1_2(Blocks.field_180408_aP);
            }
            case BIRCH: {
                return new MetaBlock1_2(Blocks.field_180404_aQ);
            }
            case JUNGLE: {
                return new MetaBlock1_2(Blocks.field_180403_aR);
            }
            case ACACIA: {
                return new MetaBlock1_2(Blocks.field_180405_aT);
            }
            case DARK_OAK: {
                return new MetaBlock1_2(Blocks.field_180406_aS);
            }
        }
        return new MetaBlock1_2(Blocks.field_180407_aO);
    }

    public static MetaBlock1_2 getSapling(Wood type) {
        MetaBlock1_2 sapling = new MetaBlock1_2(Blocks.field_150345_g);
        switch (type) {
            default: {
                return sapling.withProperty(BlockSapling.field_176480_a, BlockPlanks.EnumType.OAK);
            }
            case SPRUCE: {
                return sapling.withProperty(BlockSapling.field_176480_a, BlockPlanks.EnumType.SPRUCE);
            }
            case BIRCH: {
                return sapling.withProperty(BlockSapling.field_176480_a, BlockPlanks.EnumType.BIRCH);
            }
            case JUNGLE: {
                return sapling.withProperty(BlockSapling.field_176480_a, BlockPlanks.EnumType.JUNGLE);
            }
            case ACACIA: {
                return sapling.withProperty(BlockSapling.field_176480_a, BlockPlanks.EnumType.ACACIA);
            }
            case DARK_OAK: 
        }
        return sapling.withProperty(BlockSapling.field_176480_a, BlockPlanks.EnumType.DARK_OAK);
    }

    public static MetaBlock1_2 getLeaves(Wood type, boolean decay) {
        Block base = BlockMapper1_12.getBlockId(type);
        PropertyEnum variantType = base == Blocks.field_150362_t ? BlockOldLeaf.field_176239_P : BlockNewLeaf.field_176240_P;
        return new MetaBlock1_2(base).withProperty(variantType, BlockMapper1_12.getWoodVariant(type)).withProperty(BlockLeaves.field_176237_a, decay);
    }

    private static Block getBlockId(Wood type) {
        switch (type) {
            case OAK: 
            case JUNGLE: 
            case BIRCH: 
            case SPRUCE: {
                return Blocks.field_150362_t;
            }
            case ACACIA: 
            case DARK_OAK: {
                return Blocks.field_150361_u;
            }
        }
        return Blocks.field_150364_r;
    }

    private static BlockPlanks.EnumType getWoodVariant(Wood type) {
        switch (type) {
            case SPRUCE: {
                return BlockPlanks.EnumType.SPRUCE;
            }
            case BIRCH: {
                return BlockPlanks.EnumType.BIRCH;
            }
            case JUNGLE: {
                return BlockPlanks.EnumType.JUNGLE;
            }
            case ACACIA: {
                return BlockPlanks.EnumType.ACACIA;
            }
            case DARK_OAK: {
                return BlockPlanks.EnumType.DARK_OAK;
            }
        }
        return BlockPlanks.EnumType.OAK;
    }

    public static MetaBlock1_2 createVine(Direction dir) {
        MetaBlock1_2 vine = new MetaBlock1_2(Blocks.field_150395_bd);
        vine.withProperty(BlockVine.field_176277_a, dir == Direction.UP);
        vine.withProperty(BlockVine.field_176273_b, dir == Direction.NORTH);
        vine.withProperty(BlockVine.field_176278_M, dir == Direction.EAST);
        vine.withProperty(BlockVine.field_176279_N, dir == Direction.SOUTH);
        vine.withProperty(BlockVine.field_176280_O, dir == Direction.WEST);
        return vine;
    }

    private static MetaBlock1_2 getPlant(PlantBlock block) {
        return BlockMapper1_12.getPlant(block.getPlant());
    }

    public static MetaBlock1_2 getPlant(Plant type) {
        switch (type) {
            case POPPY: {
                return new MetaBlock1_2((Block)Blocks.field_150328_O);
            }
            case ORCHID: {
                return new MetaBlock1_2((Block)Blocks.field_150328_O).withProperty(Blocks.field_150328_O.func_176494_l(), BlockFlower.EnumFlowerType.BLUE_ORCHID);
            }
            case ALLIUM: {
                return new MetaBlock1_2((Block)Blocks.field_150328_O).withProperty(Blocks.field_150328_O.func_176494_l(), BlockFlower.EnumFlowerType.ALLIUM);
            }
            case BLUET: {
                return new MetaBlock1_2((Block)Blocks.field_150328_O).withProperty(Blocks.field_150328_O.func_176494_l(), BlockFlower.EnumFlowerType.HOUSTONIA);
            }
            case REDTULIP: {
                return new MetaBlock1_2((Block)Blocks.field_150328_O).withProperty(Blocks.field_150328_O.func_176494_l(), BlockFlower.EnumFlowerType.RED_TULIP);
            }
            case ORANGETULIP: {
                return new MetaBlock1_2((Block)Blocks.field_150328_O).withProperty(Blocks.field_150328_O.func_176494_l(), BlockFlower.EnumFlowerType.ORANGE_TULIP);
            }
            case WHITETULIP: {
                return new MetaBlock1_2((Block)Blocks.field_150328_O).withProperty(Blocks.field_150328_O.func_176494_l(), BlockFlower.EnumFlowerType.WHITE_TULIP);
            }
            case PINKTULIP: {
                return new MetaBlock1_2((Block)Blocks.field_150328_O).withProperty(Blocks.field_150328_O.func_176494_l(), BlockFlower.EnumFlowerType.PINK_TULIP);
            }
            case DAISY: {
                return new MetaBlock1_2((Block)Blocks.field_150328_O).withProperty(Blocks.field_150328_O.func_176494_l(), BlockFlower.EnumFlowerType.OXEYE_DAISY);
            }
            case RED_MUSHROOM: {
                return new MetaBlock1_2((Block)Blocks.field_150337_Q);
            }
            case BROWN_MUSHROOM: {
                return new MetaBlock1_2((Block)Blocks.field_150338_P);
            }
            case CACTUS: {
                return new MetaBlock1_2((Block)Blocks.field_150434_aF);
            }
            case OAK_SAPLING: {
                return BlockMapper1_12.getSapling(Wood.OAK);
            }
            case SPRUCE_SAPLING: {
                return BlockMapper1_12.getSapling(Wood.SPRUCE);
            }
            case BIRCH_SAPLING: {
                return BlockMapper1_12.getSapling(Wood.BIRCH);
            }
            case JUNGLE_SAPLING: {
                return BlockMapper1_12.getSapling(Wood.JUNGLE);
            }
            case ACACIA_SAPLING: {
                return BlockMapper1_12.getSapling(Wood.ACACIA);
            }
            case DARKOAK_SAPLING: {
                return BlockMapper1_12.getSapling(Wood.DARK_OAK);
            }
            case SHRUB: {
                return new MetaBlock1_2((Block)Blocks.field_150329_H).withProperty(BlockTallGrass.field_176497_a, BlockTallGrass.EnumType.DEAD_BUSH);
            }
            case FERN: {
                return new MetaBlock1_2((Block)Blocks.field_150329_H).withProperty(BlockTallGrass.field_176497_a, BlockTallGrass.EnumType.FERN);
            }
        }
        return new MetaBlock1_2((Block)Blocks.field_150327_N);
    }

    private static MetaBlock1_2 getInfestedBlock(InfestedBlock block) {
        MetaBlock1_2 block1 = new MetaBlock1_2(Blocks.field_150418_aU);
        Stone stone = block.getStone();
        switch (stone) {
            default: {
                return block1.withProperty(BlockSilverfish.field_176378_a, BlockSilverfish.EnumType.STONE);
            }
            case COBBLE: {
                return block1.withProperty(BlockSilverfish.field_176378_a, BlockSilverfish.EnumType.COBBLESTONE);
            }
            case STONEBRICK: {
                return block1.withProperty(BlockSilverfish.field_176378_a, BlockSilverfish.EnumType.STONEBRICK);
            }
            case STONEBRICK_MOSSY: {
                return block1.withProperty(BlockSilverfish.field_176378_a, BlockSilverfish.EnumType.MOSSY_STONEBRICK);
            }
            case STONEBRICK_CRACKED: {
                return block1.withProperty(BlockSilverfish.field_176378_a, BlockSilverfish.EnumType.CRACKED_STONEBRICK);
            }
            case STONEBRICK_CHISELED: 
        }
        return block1.withProperty(BlockSilverfish.field_176378_a, BlockSilverfish.EnumType.CHISELED_STONEBRICK);
    }

    public static MetaBlock1_2 getQuartz(Quartz type, Direction facing) {
        MetaBlock1_2 block = new MetaBlock1_2(Blocks.field_150371_ca);
        switch (type) {
            case CHISELED: {
                block = block.withProperty(BlockQuartz.field_176335_a, BlockQuartz.EnumType.CHISELED);
                return BlockMapper1_12.addPillarLines(block, facing);
            }
            case PILLAR: {
                return BlockMapper1_12.addPillarLines(block, facing);
            }
        }
        return block;
    }

    public static MetaBlock1_2 addPillarLines(MetaBlock1_2 block, Direction facing) {
        switch (facing) {
            case EAST: 
            case WEST: {
                return block.withProperty(BlockQuartz.field_176335_a, BlockQuartz.EnumType.LINES_X);
            }
            case NORTH: 
            case SOUTH: {
                return block.withProperty(BlockQuartz.field_176335_a, BlockQuartz.EnumType.LINES_Z);
            }
        }
        return block.withProperty(BlockQuartz.field_176335_a, BlockQuartz.EnumType.LINES_Y);
    }

    public static MetaBlock1_2 getTallPlant(TallPlantBlock tallPlantBlock) {
        return new MetaBlock1_2((Block)Blocks.field_150398_cm).withProperty(BlockDoublePlant.field_176493_a, BlockMapper1_12.getTallPlantMinecraftBlock(tallPlantBlock.getTallPlant())).withProperty(BlockDoublePlant.field_181084_N, tallPlantBlock.getFacing().getFacing()).withProperty(BlockDoublePlant.field_176492_b, tallPlantBlock.isTop() ? BlockDoublePlant.EnumBlockHalf.UPPER : BlockDoublePlant.EnumBlockHalf.LOWER);
    }

    public static BlockDoublePlant.EnumPlantType getTallPlantMinecraftBlock(TallPlant type) {
        switch (type) {
            default: {
                return BlockDoublePlant.EnumPlantType.GRASS;
            }
            case SUNFLOWER: {
                return BlockDoublePlant.EnumPlantType.SUNFLOWER;
            }
            case LILAC: {
                return BlockDoublePlant.EnumPlantType.SYRINGA;
            }
            case LARGE_FERN: {
                return BlockDoublePlant.EnumPlantType.FERN;
            }
            case ROSE_BUSH: {
                return BlockDoublePlant.EnumPlantType.ROSE;
            }
            case PEONY: 
        }
        return BlockDoublePlant.EnumPlantType.PAEONIA;
    }
}

