/*
 * Decompiled with CFR 0.152.
 */
package com.github.srwaggon.minecraft.block.decorative;

import com.github.srwaggon.minecraft.block.BlockType;
import com.github.srwaggon.minecraft.block.SingleBlockBrush;
import com.github.srwaggon.minecraft.block.normal.ColoredBlock;
import greymerk.roguelike.config.RogueConfig;
import greymerk.roguelike.util.DyeColor;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.WorldEditor;

public class BedBlock
extends SingleBlockBrush {
    private DyeColor color = DyeColor.RED;
    private boolean isHead = true;

    public BedBlock() {
        super(BlockType.BED);
    }

    public BedBlock setColor(DyeColor color) {
        this.color = color;
        return this;
    }

    public DyeColor getColor() {
        return this.color;
    }

    public boolean isHead() {
        return this.isHead;
    }

    public BedBlock setHead(boolean head) {
        this.isHead = head;
        return this;
    }

    private BedBlock getFoot() {
        BedBlock bedBlock = BedBlock.bed().setColor(this.getColor()).setHead(false);
        bedBlock.setFacing(this.getFacing());
        return bedBlock;
    }

    private BedBlock getHead() {
        BedBlock bedBlock = BedBlock.bed().setColor(this.getColor()).setHead(true);
        bedBlock.setFacing(this.getFacing());
        return bedBlock;
    }

    @Override
    public boolean stroke(WorldEditor editor, Coord pos, boolean fillAir, boolean replaceSolid) {
        Coord cursor = pos.copy();
        if (!RogueConfig.getBoolean(RogueConfig.FURNITURE)) {
            ColoredBlock.wool().setColor(DyeColor.WHITE).stroke(editor, cursor);
            cursor.translate(this.getFacing());
            ColoredBlock.wool().setColor(DyeColor.RED).stroke(editor, cursor);
            return true;
        }
        editor.setBlock(cursor, this, fillAir, replaceSolid);
        editor.setBedColorAt(cursor, this.color);
        cursor.translate(this.getFacing());
        editor.setBlock(cursor, this.getFoot(), fillAir, replaceSolid);
        editor.setBedColorAt(cursor, this.color);
        return true;
    }

    public static BedBlock bed() {
        return new BedBlock();
    }
}

