/*
 * Decompiled with CFR 0.152.
 */
package com.github.srwaggon.minecraft.item;

import com.github.srwaggon.minecraft.EffectType;
import com.github.srwaggon.minecraft.item.Potion;
import com.github.srwaggon.minecraft.item.RldItem;
import com.github.srwaggon.minecraft.item.RldItemStack;
import com.google.gson.JsonObject;
import greymerk.roguelike.dungeon.settings.DungeonSettingParseException;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;

public class PotionMapper1_12 {
    public static ItemStack map(RldItemStack rldItemStack) {
        RldItem item = rldItemStack.getItem();
        return PotionMapper1_12.map((Potion)item);
    }

    public static ItemStack map(Potion potion) {
        ItemPotion itemPotion = PotionMapper1_12.map(potion.getForm());
        ItemStack itemStack = new ItemStack((Item)itemPotion);
        PotionType data = PotionMapper1_12.map(potion.getType(), potion.isAmplified(), potion.isExtended());
        ItemStack potionWithData = PotionUtils.func_185188_a((ItemStack)itemStack, (PotionType)data);
        potion.getEffects().forEach(effect -> PotionMapper1_12.addCustomEffect(potionWithData, effect.getType(), effect.getAmplification(), effect.getDuration()));
        return potionWithData;
    }

    private static void addCustomEffect(ItemStack itemStack, EffectType type, int amplifier, int duration) {
        int ticksPerSecond = 20;
        String CUSTOM = "CustomPotionEffects";
        NBTTagCompound tag = itemStack.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
            itemStack.func_77982_d(tag);
        }
        NBTTagCompound toAdd = new NBTTagCompound();
        toAdd.func_74774_a("Id", (byte)type.getEffectID());
        toAdd.func_74774_a("Amplifier", (byte)amplifier);
        toAdd.func_74768_a("Duration", duration * 20);
        toAdd.func_74757_a("Ambient", true);
        NBTTagList effects = tag.func_150295_c("CustomPotionEffects", 10);
        effects.func_74742_a((NBTBase)toAdd);
        tag.func_74782_a("CustomPotionEffects", (NBTBase)effects);
        itemStack.func_77982_d(tag);
    }

    private static ItemPotion map(Potion.Form form) {
        return form == Potion.Form.REGULAR ? Items.field_151068_bn : (form == Potion.Form.SPLASH ? Items.field_185155_bH : Items.field_185156_bI);
    }

    public static PotionType map(Potion.Type effect, boolean isAmplified, boolean isExtended) {
        switch (effect) {
            case HEALING: {
                return isAmplified ? PotionTypes.field_185251_w : PotionTypes.field_185250_v;
            }
            case HARMING: {
                return isAmplified ? PotionTypes.field_185253_y : PotionTypes.field_185252_x;
            }
            case REGENERATION: {
                return isExtended ? PotionTypes.field_185221_D : (isAmplified ? PotionTypes.field_185222_E : PotionTypes.field_185220_C);
            }
            case POISON: {
                return isExtended ? PotionTypes.field_185218_A : (isAmplified ? PotionTypes.field_185219_B : PotionTypes.field_185254_z);
            }
            case STRENGTH: {
                return isExtended ? PotionTypes.field_185224_G : (isAmplified ? PotionTypes.field_185225_H : PotionTypes.field_185223_F);
            }
            case WEAKNESS: {
                return isExtended ? PotionTypes.field_185227_J : PotionTypes.field_185226_I;
            }
            case SLOWNESS: {
                return isExtended ? PotionTypes.field_185247_s : PotionTypes.field_185246_r;
            }
            case SWIFTNESS: {
                return isExtended ? PotionTypes.field_185244_p : (isAmplified ? PotionTypes.field_185245_q : PotionTypes.field_185243_o);
            }
            case FIRE_RESISTANCE: {
                return isExtended ? PotionTypes.field_185242_n : PotionTypes.field_185241_m;
            }
            case INVISIBILITY: {
                return isExtended ? PotionTypes.field_185237_i : PotionTypes.field_185236_h;
            }
            case LEAPING: {
                return isExtended ? PotionTypes.field_185239_k : PotionTypes.field_185238_j;
            }
            case NIGHT_VISION: {
                return isExtended ? PotionTypes.field_185235_g : PotionTypes.field_185234_f;
            }
            case WATER_BREATHING: {
                return isExtended ? PotionTypes.field_185249_u : PotionTypes.field_185248_t;
            }
        }
        return PotionTypes.field_185233_e;
    }

    public static ItemStack parsePotion(JsonObject data) throws DungeonSettingParseException {
        if (!data.has("name")) {
            throw new DungeonSettingParseException("Potion missing name field");
        }
        String nameString = data.get("name").getAsString().toUpperCase();
        PotionType type = PotionType.func_185168_a((String)nameString);
        ItemPotion item = !data.has("form") ? Items.field_151068_bn : PotionMapper1_12.map(Potion.Form.valueOf(data.get("form").getAsString().toUpperCase()));
        ItemStack itemStack = new ItemStack((Item)item);
        return PotionUtils.func_185188_a((ItemStack)itemStack, (PotionType)type);
    }
}

