/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike;

import com.github.srwaggon.minecraft.block.BlockType;
import com.github.srwaggon.minecraft.block.SingleBlockBrush;
import greymerk.roguelike.treasure.ChestPlacementException;
import greymerk.roguelike.treasure.TreasureChest;
import greymerk.roguelike.treasure.TreasureManager;
import greymerk.roguelike.treasure.loot.ChestType;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.Direction;
import greymerk.roguelike.worldgen.WorldEditor;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;

public class TreasureChestEditor {
    private final WorldEditor worldEditor;
    private final TreasureManager treasureManager;
    private final Random random;

    public TreasureChestEditor(WorldEditor worldEditor, Random random) {
        this.worldEditor = worldEditor;
        this.random = random;
        this.treasureManager = new TreasureManager(random);
    }

    public TreasureManager getTreasureManager() {
        return this.treasureManager;
    }

    public List<TreasureChest> createChests(List<Coord> chestLocations, boolean isTrapped, int level, ChestType ... chestTypes) {
        return chestLocations.stream().map(chestLocation -> this.createChest((Coord)chestLocation, isTrapped, level, chestTypes)).collect(Collectors.toList());
    }

    public TreasureChest createChest(Coord chestLocation, boolean isTrapped, int level, ChestType ... chestTypes) {
        if (!this.isValidChestSpace(chestLocation, this.worldEditor)) {
            return null;
        }
        try {
            return this.generateTreasureChest(chestLocation, isTrapped, level, ChestType.chooseRandomAmong(this.random, chestTypes));
        }
        catch (ChestPlacementException chestPlacementException) {
            return null;
        }
    }

    private TreasureChest generateTreasureChest(Coord pos, boolean isTrapped, int level, ChestType chestType) throws ChestPlacementException {
        SingleBlockBrush chestBlock = (isTrapped ? BlockType.TRAPPED_CHEST : BlockType.CHEST).getBrush();
        boolean success = chestBlock.stroke(this.worldEditor, pos);
        if (!success) {
            throw new ChestPlacementException("Failed to place chest in world");
        }
        TreasureChest treasureChest = new TreasureChest(chestType, level, pos, this.worldEditor);
        this.getTreasureManager().addChest(treasureChest);
        return treasureChest;
    }

    private boolean isValidChestSpace(Coord coord, WorldEditor worldEditor) {
        return worldEditor.isAirBlock(coord) && worldEditor.isSolidBlock(coord.add(Direction.DOWN)) && worldEditor.getTreasureChestEditor().isNotNextToChest(coord, worldEditor);
    }

    private boolean isNotNextToChest(Coord coord, WorldEditor worldEditor) {
        return Direction.CARDINAL.stream().noneMatch(dir -> worldEditor.isBlockOfTypeAt(BlockType.CHEST, coord.add((Direction)((Object)dir))));
    }
}

