/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon;

import com.github.srwaggon.minecraft.block.SingleBlockBrush;
import greymerk.roguelike.dungeon.DungeonLevel;
import greymerk.roguelike.dungeon.segment.ISegment;
import greymerk.roguelike.dungeon.segment.SegmentGenerator;
import greymerk.roguelike.dungeon.settings.LevelSettings;
import greymerk.roguelike.theme.ThemeBase;
import greymerk.roguelike.worldgen.BlockBrush;
import greymerk.roguelike.worldgen.BlockJumble;
import greymerk.roguelike.worldgen.BoundingBox;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.Direction;
import greymerk.roguelike.worldgen.IBounded;
import greymerk.roguelike.worldgen.WorldEditor;
import greymerk.roguelike.worldgen.shapes.IShape;
import greymerk.roguelike.worldgen.shapes.RectHollow;
import greymerk.roguelike.worldgen.shapes.RectSolid;
import greymerk.roguelike.worldgen.shapes.Shape;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Random;

public class DungeonTunnel
implements Iterable<Coord>,
IBounded {
    private Coord start;
    private Coord end;
    private List<ISegment> segments;
    private List<Coord> tunnel;

    public DungeonTunnel(Coord start, Coord end) {
        this.start = start;
        this.end = end;
        this.tunnel = new RectSolid(start, end).get();
        this.segments = new ArrayList<ISegment>();
    }

    @Override
    public Iterator<Coord> iterator() {
        return this.tunnel.iterator();
    }

    public void encase(WorldEditor editor, ThemeBase theme) {
        Direction dir = this.getDirection();
        Coord s = this.start.copy();
        Coord e = this.end.copy();
        s.translate(dir.antiClockwise(), 3);
        s.up(3);
        e.translate(dir.clockwise(), 3);
        e.down(3);
        RectSolid.newRect(s, e).fill(editor, theme.getPrimary().getWall());
    }

    public void construct(WorldEditor editor, LevelSettings settings) {
        BlockBrush wallBlocks = settings.getTheme().getPrimary().getWall();
        BlockBrush floor = settings.getTheme().getPrimary().getFloor();
        BlockJumble bridgeBlocks = new BlockJumble();
        bridgeBlocks.addBlock(floor);
        bridgeBlocks.addBlock(SingleBlockBrush.AIR);
        Coord s = this.start.copy();
        s.north();
        s.east();
        Coord e = this.end.copy();
        e.south();
        e.west();
        e.up(2);
        RectSolid.newRect(s, e).fill(editor, SingleBlockBrush.AIR);
        s.north();
        s.east();
        s.down();
        e.south();
        e.west();
        e.up();
        RectHollow.newRect(s, e).fill(editor, wallBlocks, false, true);
        s = this.start.copy();
        s.north();
        s.east();
        s.down();
        e = this.end.copy();
        e.south();
        e.west();
        e.down();
        RectSolid.newRect(s, e).fill(editor, floor, false, true);
        RectSolid.newRect(s, e).fill(editor, bridgeBlocks, true, false);
        Direction dir = this.getDirection();
        Coord location = this.end.copy();
        location.translate(dir, 1);
        Coord start = location.copy();
        Direction[] orth = dir.orthogonals();
        start.translate(orth[0], 2);
        start.up(2);
        Coord end = location.copy();
        end.translate(orth[1], 2);
        end.down(2);
        RectSolid.newRect(start, end).fill(editor, wallBlocks, false, true);
    }

    public Coord[] getEnds() {
        Coord[] toReturn = new Coord[]{this.start.copy(), this.end.copy()};
        return toReturn;
    }

    public Direction getDirection() {
        return this.start.dirTo(this.end);
    }

    public void genSegments(WorldEditor editor, Random rand, DungeonLevel level) {
        LevelSettings settings = level.getSettings();
        SegmentGenerator segGen = settings.getSegments();
        for (Coord c : this) {
            this.segments.addAll(segGen.genSegment(editor, rand, level, this.getDirection(), c));
        }
    }

    public List<ISegment> getSegments() {
        return this.segments;
    }

    @Override
    public BoundingBox getBoundingBox() {
        Direction dir = this.getDirection();
        Coord s = this.start.copy();
        Coord e = this.end.copy();
        s.translate(dir.antiClockwise(), 2);
        s.up(3);
        e.translate(dir.clockwise(), 2);
        e.down();
        return new BoundingBox(s, e);
    }

    public boolean hasEnd(Coord pos) {
        return pos.equals(this.start) || pos.equals(this.end);
    }

    @Override
    public boolean collide(IBounded other) {
        return this.getBoundingBox().collide(other);
    }

    @Override
    public IShape getShape(Shape type) {
        return this.getBoundingBox().getShape(type);
    }

    @Override
    public Coord getStart() {
        return this.getBoundingBox().getStart();
    }

    @Override
    public Coord getEnd() {
        return this.getBoundingBox().getEnd();
    }

    Optional<Direction> getEntrance(Coord vertex) {
        Coord start = this.getStart();
        Coord end = this.getEnd();
        if (vertex.equals(start)) {
            return Optional.of(start.dirTo(end));
        }
        if (vertex.equals(end)) {
            return Optional.of(end.dirTo(start));
        }
        return Optional.empty();
    }
}

