/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.rooms;

import greymerk.roguelike.dungeon.base.DungeonBase;
import greymerk.roguelike.dungeon.base.RoomType;
import greymerk.roguelike.dungeon.rooms.Frequency;
import greymerk.roguelike.dungeon.rooms.prototype.BrickRoom;
import greymerk.roguelike.dungeon.rooms.prototype.CornerRoom;
import greymerk.roguelike.dungeon.rooms.prototype.DungeonAshlea;
import greymerk.roguelike.dungeon.rooms.prototype.DungeonAvidya;
import greymerk.roguelike.dungeon.rooms.prototype.DungeonBTeam;
import greymerk.roguelike.dungeon.rooms.prototype.DungeonBedRoom;
import greymerk.roguelike.dungeon.rooms.prototype.DungeonBlaze;
import greymerk.roguelike.dungeon.rooms.prototype.DungeonDarkHall;
import greymerk.roguelike.dungeon.rooms.prototype.DungeonEniko;
import greymerk.roguelike.dungeon.rooms.prototype.DungeonEtho;
import greymerk.roguelike.dungeon.rooms.prototype.DungeonFirework;
import greymerk.roguelike.dungeon.rooms.prototype.DungeonLab;
import greymerk.roguelike.dungeon.rooms.prototype.DungeonLibrary;
import greymerk.roguelike.dungeon.rooms.prototype.DungeonLinker;
import greymerk.roguelike.dungeon.rooms.prototype.DungeonLinkerTop;
import greymerk.roguelike.dungeon.rooms.prototype.DungeonMess;
import greymerk.roguelike.dungeon.rooms.prototype.DungeonOssuary;
import greymerk.roguelike.dungeon.rooms.prototype.DungeonPyramidCorner;
import greymerk.roguelike.dungeon.rooms.prototype.DungeonPyramidSpawner;
import greymerk.roguelike.dungeon.rooms.prototype.DungeonPyramidTomb;
import greymerk.roguelike.dungeon.rooms.prototype.DungeonReward;
import greymerk.roguelike.dungeon.rooms.prototype.DungeonStorage;
import greymerk.roguelike.dungeon.rooms.prototype.DungeonTreetho;
import greymerk.roguelike.dungeon.rooms.prototype.DungeonsCreeperDen;
import greymerk.roguelike.dungeon.rooms.prototype.DungeonsCrypt;
import greymerk.roguelike.dungeon.rooms.prototype.DungeonsEnchant;
import greymerk.roguelike.dungeon.rooms.prototype.DungeonsEnder;
import greymerk.roguelike.dungeon.rooms.prototype.DungeonsFire;
import greymerk.roguelike.dungeon.rooms.prototype.DungeonsMusic;
import greymerk.roguelike.dungeon.rooms.prototype.DungeonsNetherBrick;
import greymerk.roguelike.dungeon.rooms.prototype.DungeonsPit;
import greymerk.roguelike.dungeon.rooms.prototype.DungeonsPrison;
import greymerk.roguelike.dungeon.rooms.prototype.DungeonsSlime;
import greymerk.roguelike.dungeon.rooms.prototype.DungeonsSmithy;
import greymerk.roguelike.dungeon.rooms.prototype.DungeonsSpiderNest;
import greymerk.roguelike.dungeon.rooms.prototype.DungeonsWood;
import greymerk.roguelike.dungeon.rooms.prototype.NetherFortressRoom;
import greymerk.roguelike.dungeon.rooms.prototype.ObsidianRoom;
import greymerk.roguelike.dungeon.settings.LevelSettings;
import greymerk.roguelike.treasure.loot.ChestType;
import greymerk.roguelike.worldgen.WorldEditor;
import java.util.List;
import java.util.Optional;

public class RoomSetting {
    private final RoomType roomType;
    private final String spawnerId;
    private final Frequency frequency;
    private final int weight;
    private final int count;
    private final List<Integer> levels;
    private final Optional<ChestType> chestType;

    public RoomSetting(RoomType roomType, String spawnerId, Frequency frequency, int weight, int count, List<Integer> levels, Optional<ChestType> chestType) {
        this.roomType = roomType;
        this.spawnerId = spawnerId;
        this.frequency = frequency;
        this.weight = weight;
        this.count = count;
        this.levels = levels;
        this.chestType = chestType;
    }

    public boolean isRandom() {
        return this.frequency.isRandom();
    }

    public boolean isSecret() {
        return this.frequency.isSecret();
    }

    public boolean isSingle() {
        return this.frequency.isSingle();
    }

    public boolean isOnFloorLevel(int floorLevel) {
        return this.getLevels() != null && this.getLevels().contains(floorLevel);
    }

    public DungeonBase instantiate(LevelSettings levelSettings, WorldEditor worldEditor) {
        switch (this.getRoomType()) {
            default: {
                return new BrickRoom(this, levelSettings, worldEditor);
            }
            case ASHLEA: {
                return new DungeonAshlea(this, levelSettings, worldEditor);
            }
            case AVIDYA: {
                return new DungeonAvidya(this, levelSettings, worldEditor);
            }
            case BEDROOM: {
                return new DungeonBedRoom(this, levelSettings, worldEditor);
            }
            case BLAZE: {
                return new DungeonBlaze(this, levelSettings, worldEditor);
            }
            case BTEAM: {
                return new DungeonBTeam(this, levelSettings, worldEditor);
            }
            case CAKE: {
                return new DungeonsWood(this, levelSettings, worldEditor);
            }
            case CORNER: {
                return new CornerRoom(this, levelSettings, worldEditor);
            }
            case CREEPER: {
                return new DungeonsCreeperDen(this, levelSettings, worldEditor);
            }
            case CRYPT: {
                return new DungeonsCrypt(this, levelSettings, worldEditor);
            }
            case DARKHALL: {
                return new DungeonDarkHall(this, levelSettings, worldEditor);
            }
            case ENCHANT: {
                return new DungeonsEnchant(this, levelSettings, worldEditor);
            }
            case ENDER: {
                return new DungeonsEnder(this, levelSettings, worldEditor);
            }
            case ENIKO: {
                return new DungeonEniko(this, levelSettings, worldEditor);
            }
            case ETHO: {
                return new DungeonEtho(this, levelSettings, worldEditor);
            }
            case FIRE: {
                return new DungeonsFire(this, levelSettings, worldEditor);
            }
            case FIREWORK: {
                return new DungeonFirework(this, levelSettings, worldEditor);
            }
            case NETHERFORT: {
                return new NetherFortressRoom(this, levelSettings, worldEditor);
            }
            case LAB: {
                return new DungeonLab(this, levelSettings, worldEditor);
            }
            case LIBRARY: {
                return new DungeonLibrary(this, levelSettings, worldEditor);
            }
            case LINKER: {
                return new DungeonLinker(this, levelSettings, worldEditor);
            }
            case LINKERTOP: {
                return new DungeonLinkerTop(this, levelSettings, worldEditor);
            }
            case MESS: {
                return new DungeonMess(this, levelSettings, worldEditor);
            }
            case MUSIC: {
                return new DungeonsMusic(this, levelSettings, worldEditor);
            }
            case NETHER: {
                return new DungeonsNetherBrick(this, levelSettings, worldEditor);
            }
            case OBSIDIAN: {
                return new ObsidianRoom(this, levelSettings, worldEditor);
            }
            case OSSUARY: {
                return new DungeonOssuary(this, levelSettings, worldEditor);
            }
            case PIT: {
                return new DungeonsPit(this, levelSettings, worldEditor);
            }
            case PRISON: {
                return new DungeonsPrison(this, levelSettings, worldEditor);
            }
            case PYRAMIDCORNER: {
                return new DungeonPyramidCorner(this, levelSettings, worldEditor);
            }
            case PYRAMIDSPAWNER: {
                return new DungeonPyramidSpawner(this, levelSettings, worldEditor);
            }
            case PYRAMIDTOMB: {
                return new DungeonPyramidTomb(this, levelSettings, worldEditor);
            }
            case REWARD: {
                return new DungeonReward(this, levelSettings, worldEditor);
            }
            case SLIME: {
                return new DungeonsSlime(this, levelSettings, worldEditor);
            }
            case SMITH: {
                return new DungeonsSmithy(this, levelSettings, worldEditor);
            }
            case SPIDER: {
                return new DungeonsSpiderNest(this, levelSettings, worldEditor);
            }
            case STORAGE: {
                return new DungeonStorage(this, levelSettings, worldEditor);
            }
            case TREETHO: 
        }
        return new DungeonTreetho(this, levelSettings, worldEditor);
    }

    public String toString() {
        return "RoomSetting(roomType=" + (Object)((Object)this.getRoomType()) + ", spawnerId=" + this.getSpawnerId() + ", frequency=" + (Object)((Object)this.getFrequency()) + ", weight=" + this.getWeight() + ", count=" + this.getCount() + ", levels=" + this.getLevels() + ", chestType=" + this.getChestType() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RoomSetting)) {
            return false;
        }
        RoomSetting other = (RoomSetting)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RoomType this$roomType = this.getRoomType();
        RoomType other$roomType = other.getRoomType();
        if (this$roomType == null ? other$roomType != null : !((Object)((Object)this$roomType)).equals((Object)other$roomType)) {
            return false;
        }
        String this$spawnerId = this.getSpawnerId();
        String other$spawnerId = other.getSpawnerId();
        if (this$spawnerId == null ? other$spawnerId != null : !this$spawnerId.equals(other$spawnerId)) {
            return false;
        }
        Frequency this$frequency = this.getFrequency();
        Frequency other$frequency = other.getFrequency();
        if (this$frequency == null ? other$frequency != null : !((Object)((Object)this$frequency)).equals((Object)other$frequency)) {
            return false;
        }
        if (this.getWeight() != other.getWeight()) {
            return false;
        }
        if (this.getCount() != other.getCount()) {
            return false;
        }
        List<Integer> this$levels = this.getLevels();
        List<Integer> other$levels = other.getLevels();
        if (this$levels == null ? other$levels != null : !((Object)this$levels).equals(other$levels)) {
            return false;
        }
        Optional<ChestType> this$chestType = this.getChestType();
        Optional<ChestType> other$chestType = other.getChestType();
        return !(this$chestType == null ? other$chestType != null : !((Object)this$chestType).equals(other$chestType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RoomSetting;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RoomType $roomType = this.getRoomType();
        result = result * 59 + ($roomType == null ? 43 : ((Object)((Object)$roomType)).hashCode());
        String $spawnerId = this.getSpawnerId();
        result = result * 59 + ($spawnerId == null ? 43 : $spawnerId.hashCode());
        Frequency $frequency = this.getFrequency();
        result = result * 59 + ($frequency == null ? 43 : ((Object)((Object)$frequency)).hashCode());
        result = result * 59 + this.getWeight();
        result = result * 59 + this.getCount();
        List<Integer> $levels = this.getLevels();
        result = result * 59 + ($levels == null ? 43 : ((Object)$levels).hashCode());
        Optional<ChestType> $chestType = this.getChestType();
        result = result * 59 + ($chestType == null ? 43 : ((Object)$chestType).hashCode());
        return result;
    }

    public RoomType getRoomType() {
        return this.roomType;
    }

    public String getSpawnerId() {
        return this.spawnerId;
    }

    public Frequency getFrequency() {
        return this.frequency;
    }

    public int getWeight() {
        return this.weight;
    }

    public int getCount() {
        return this.count;
    }

    public List<Integer> getLevels() {
        return this.levels;
    }

    public Optional<ChestType> getChestType() {
        return this.chestType;
    }
}

