/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.rooms.prototype;

import com.github.srwaggon.minecraft.block.SingleBlockBrush;
import com.github.srwaggon.minecraft.block.normal.StairsBlock;
import greymerk.roguelike.dungeon.Dungeon;
import greymerk.roguelike.dungeon.base.DungeonBase;
import greymerk.roguelike.dungeon.rooms.RoomSetting;
import greymerk.roguelike.dungeon.settings.LevelSettings;
import greymerk.roguelike.theme.ThemeBase;
import greymerk.roguelike.treasure.loot.ChestType;
import greymerk.roguelike.worldgen.BlockBrush;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.Direction;
import greymerk.roguelike.worldgen.WorldEditor;
import greymerk.roguelike.worldgen.shapes.RectHollow;
import greymerk.roguelike.worldgen.shapes.RectSolid;
import greymerk.roguelike.worldgen.spawners.MobType;
import java.util.ArrayList;
import java.util.List;

public class BrickRoom
extends DungeonBase {
    public BrickRoom(RoomSetting roomSetting, LevelSettings levelSettings, WorldEditor worldEditor) {
        super(roomSetting, levelSettings, worldEditor);
    }

    @Override
    public DungeonBase generate(Coord origin, List<Direction> entrances) {
        int x = origin.getX();
        int y = origin.getY();
        int z = origin.getZ();
        ThemeBase theme = this.levelSettings.getTheme();
        StairsBlock stair = theme.getPrimary().getStair();
        BlockBrush blocks = theme.getPrimary().getWall();
        BlockBrush pillar = theme.getPrimary().getPillar();
        RectSolid.newRect(new Coord(x - 3, y, z - 3), new Coord(x + 3, y + 3, z + 3)).fill(this.worldEditor, SingleBlockBrush.AIR);
        RectSolid.newRect(new Coord(x - 1, y + 4, z - 1), new Coord(x + 1, y + 4, z + 1)).fill(this.worldEditor, SingleBlockBrush.AIR);
        RectHollow.newRect(new Coord(x - 4, y - 1, z - 4), new Coord(x + 4, y + 4, z + 4)).fill(this.worldEditor, blocks, false, true);
        RectSolid.newRect(new Coord(x - 4, y - 1, z - 4), new Coord(x + 4, y - 1, z + 4)).fill(this.worldEditor, theme.getPrimary().getFloor(), false, true);
        Coord cursor = new Coord(x, y, z);
        cursor.translate(Direction.UP, 5);
        SingleBlockBrush.AIR.stroke(this.worldEditor, cursor);
        cursor.translate(Direction.UP, 1);
        blocks.stroke(this.worldEditor, cursor);
        ArrayList<Coord> potentialChestLocations = new ArrayList<Coord>();
        for (Direction dir : Direction.CARDINAL) {
            cursor = new Coord(x, y, z);
            cursor.translate(dir, 1);
            cursor.translate(Direction.UP, 5);
            stair.setUpsideDown(true).setFacing(dir.reverse());
            stair.stroke(this.worldEditor, cursor, false, true);
            cursor.translate(dir.antiClockwise(), 1);
            blocks.stroke(this.worldEditor, cursor, false, true);
            cursor = new Coord(x, y, z);
            cursor.translate(dir, 2);
            cursor.translate(Direction.UP, 4);
            SingleBlockBrush.AIR.stroke(this.worldEditor, cursor);
            cursor.translate(Direction.UP, 1);
            blocks.stroke(this.worldEditor, cursor, false, true);
            cursor = new Coord(x, y, z);
            cursor.translate(dir, 3);
            cursor.translate(dir.antiClockwise(), 3);
            Coord start = cursor.copy();
            cursor.translate(Direction.UP, 2);
            Coord end = cursor.copy();
            RectSolid.newRect(start, end).fill(this.worldEditor, pillar);
            cursor.translate(Direction.UP, 1);
            blocks.stroke(this.worldEditor, cursor);
            for (Direction orthogonals : dir.orthogonals()) {
                cursor = new Coord(x, y, z);
                cursor.translate(dir, 3);
                cursor.translate(orthogonals, 2);
                cursor.translate(Direction.UP, 3);
                stair.setUpsideDown(true).setFacing(orthogonals.reverse());
                stair.stroke(this.worldEditor, cursor);
            }
            cursor = new Coord(x, y, z);
            cursor.translate(dir, 2);
            cursor.translate(dir.antiClockwise(), 2);
            cursor.translate(Direction.UP, 4);
            blocks.stroke(this.worldEditor, cursor, false, true);
            for (Direction orthogonals : dir.orthogonals()) {
                cursor = new Coord(x, y, z);
                cursor.translate(Direction.UP, 4);
                cursor.translate(dir, 2);
                cursor.translate(orthogonals, 1);
                stair.setUpsideDown(true).setFacing(orthogonals.reverse());
                stair.stroke(this.worldEditor, cursor, false, true);
            }
            cursor = new Coord(x, y, z);
            cursor.translate(dir, 1);
            cursor.translate(dir.antiClockwise(), 1);
            cursor.translate(Direction.UP, 5);
            blocks.stroke(this.worldEditor, cursor, false, true);
            for (Direction orthogonals : dir.orthogonals()) {
                cursor = origin.copy();
                cursor.translate(dir, 3);
                cursor.translate(orthogonals, 2);
                potentialChestLocations.add(cursor);
            }
        }
        List<Coord> chestLocations = this.chooseRandomLocations(1, potentialChestLocations);
        int level = Dungeon.getLevel(origin.getY());
        ChestType chestType = this.getRoomSetting().getChestType().orElse(ChestType.chooseRandomAmong(this.worldEditor.getRandom(cursor), ChestType.COMMON_TREASURES));
        this.worldEditor.getTreasureChestEditor().createChests(chestLocations, false, level, chestType);
        this.generateSpawner(origin, new MobType[0]);
        return this;
    }

    @Override
    public int getSize() {
        return 6;
    }
}

