/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.rooms.prototype;

import com.github.srwaggon.minecraft.block.BlockType;
import com.github.srwaggon.minecraft.block.decorative.BedBlock;
import com.github.srwaggon.minecraft.block.decorative.FlowerPotBlock;
import com.github.srwaggon.minecraft.block.decorative.TorchBlock;
import com.github.srwaggon.minecraft.block.normal.StairsBlock;
import greymerk.roguelike.dungeon.Dungeon;
import greymerk.roguelike.dungeon.base.DungeonBase;
import greymerk.roguelike.dungeon.rooms.RoomSetting;
import greymerk.roguelike.dungeon.settings.LevelSettings;
import greymerk.roguelike.theme.ThemeBase;
import greymerk.roguelike.treasure.loot.ChestType;
import greymerk.roguelike.util.DyeColor;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.Direction;
import greymerk.roguelike.worldgen.WorldEditor;
import greymerk.roguelike.worldgen.shapes.RectHollow;
import greymerk.roguelike.worldgen.shapes.RectSolid;
import java.util.List;
import java.util.Random;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public class DungeonBedRoom
extends DungeonBase {
    public DungeonBedRoom(RoomSetting roomSetting, LevelSettings levelSettings, WorldEditor worldEditor) {
        super(roomSetting, levelSettings, worldEditor);
    }

    public void pillar(WorldEditor editor, Direction dir, ThemeBase theme, Coord base) {
        Coord start = base.copy();
        Coord end = base.copy();
        end.up(2);
        RectSolid.newRect(start, end).fill(editor, theme.getSecondary().getPillar());
        StairsBlock stair = theme.getSecondary().getStair();
        stair.setUpsideDown(true).setFacing(dir.reverse());
        end.translate(dir.reverse());
        stair.stroke(editor, end);
    }

    @Override
    public DungeonBase generate(Coord origin, List<Direction> entrances) {
        Coord cursor;
        Random rand = this.worldEditor.getRandom();
        ThemeBase theme = this.levelSettings.getTheme();
        Direction dir = entrances.get(0);
        Coord start = origin.copy();
        Coord end = origin.copy();
        start.translate(dir.antiClockwise(), 4);
        end.translate(dir.clockwise(), 4);
        start.translate(dir.reverse(), 4);
        end.translate(dir, 4);
        start.down();
        end.up(4);
        RectHollow.newRect(start, end).fill(this.worldEditor, theme.getPrimary().getWall(), false, true);
        start = origin.copy();
        start.down();
        end = start.copy();
        start.translate(dir.antiClockwise(), 1);
        end.translate(dir.clockwise(), 1);
        start.translate(dir.reverse(), 2);
        end.translate(dir, 2);
        RectSolid.newRect(start, end).fill(this.worldEditor, theme.getSecondary().getWall());
        for (Direction o : dir.orthogonals()) {
            StairsBlock stair = theme.getSecondary().getStair();
            stair.setUpsideDown(true).setFacing(o.reverse());
            start = origin.copy();
            start.translate(o, 3);
            end = start.copy();
            start.translate(o.antiClockwise(), 2);
            end.translate(o.clockwise(), 2);
            RectSolid.newRect(start, end).fill(this.worldEditor, stair);
            start.up(2);
            end.up(2);
            RectSolid.newRect(start, end).fill(this.worldEditor, stair);
            start.up();
            end.up();
            RectSolid.newRect(start, end).fill(this.worldEditor, theme.getPrimary().getWall());
            start.translate(o.reverse());
            end.translate(o.reverse());
            RectSolid.newRect(start, end).fill(this.worldEditor, stair);
        }
        for (Direction o : dir.orthogonals()) {
            cursor = origin.copy();
            cursor.translate(o, 3);
            this.pillar(this.worldEditor, o, theme, cursor);
            for (Direction p : o.orthogonals()) {
                Coord c = cursor.copy();
                c.translate(p, 3);
                this.pillar(this.worldEditor, o, theme, c);
            }
        }
        cursor = origin.copy();
        cursor.up(3);
        cursor.translate(dir.reverse(), 3);
        for (int i = 0; i < 3; ++i) {
            start = cursor.copy();
            end = cursor.copy();
            start.translate(dir.antiClockwise(), 2);
            end.translate(dir.clockwise(), 2);
            RectSolid.newRect(start, end).fill(this.worldEditor, theme.getSecondary().getWall());
            cursor.translate(dir, 3);
        }
        Direction side = rand.nextBoolean() ? dir.antiClockwise() : dir.clockwise();
        cursor = origin.copy();
        cursor.translate(dir, 3);
        BedBlock.bed().setColor(DyeColor.chooseRandom(this.worldEditor.getRandom(cursor))).setFacing(dir.reverse()).stroke(this.worldEditor, cursor);
        cursor.translate(side, 2);
        BlockType.BOOKSHELF.getBrush().stroke(this.worldEditor, cursor);
        cursor.up();
        FlowerPotBlock.flowerPot().withRandomContent(this.worldEditor.getRandom(cursor)).stroke(this.worldEditor, cursor);
        cursor.translate(side.reverse(), 3);
        cursor.down();
        StairsBlock stair = theme.getSecondary().getStair();
        stair.setUpsideDown(true).setFacing(dir.reverse());
        stair.stroke(this.worldEditor, cursor);
        cursor.up();
        TorchBlock.torch().setFacing(Direction.UP).stroke(this.worldEditor, cursor);
        side = dir.orthogonals()[rand.nextBoolean() ? 1 : 0];
        cursor = origin.copy();
        cursor.translate(dir);
        cursor.translate(side, 3);
        this.worldEditor.getTreasureChestEditor().createChest(cursor.add(Direction.UP), false, Dungeon.getLevel(cursor.getY()), this.getRoomSetting().getChestType().orElse(ChestType.STARTER));
        cursor.translate(side.reverse(), 6);
        if (rand.nextBoolean()) {
            cursor.up();
            TorchBlock.torch().setFacing(Direction.UP).stroke(this.worldEditor, cursor);
            cursor.down();
            cursor.translate(dir);
            BlockType.CRAFTING_TABLE.getBrush().stroke(this.worldEditor, cursor);
        } else {
            BlockType.CRAFTING_TABLE.getBrush().stroke(this.worldEditor, cursor);
            cursor.translate(dir);
            cursor.up();
            TorchBlock.torch().setFacing(Direction.UP).stroke(this.worldEditor, cursor);
            cursor.down();
        }
        side = rand.nextBoolean() ? dir.antiClockwise() : dir.clockwise();
        cursor = origin.copy();
        cursor.translate(dir.reverse());
        cursor.translate(side, 3);
        if (rand.nextBoolean()) {
            cursor.translate(dir.reverse());
        }
        BlockType.FURNACE.getBrush().setFacing(side.reverse()).stroke(this.worldEditor, cursor);
        this.worldEditor.setItem(cursor, 1, new ItemStack(Items.field_151044_h, 2 + rand.nextInt(3)));
        return this;
    }

    @Override
    public int getSize() {
        return 5;
    }

    @Override
    public boolean validLocation(WorldEditor editor, Direction dir, Coord pos) {
        Coord start = pos.copy();
        Coord end = start.copy();
        start.translate(dir.reverse(), 5);
        end.translate(dir, 5);
        start.translate(dir.antiClockwise(), 5);
        end.translate(dir.clockwise(), 5);
        start.down();
        end.up(3);
        for (Coord c : new RectHollow(start, end)) {
            if (!editor.isAirBlock(c)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DungeonBedRoom)) {
            return false;
        }
        DungeonBedRoom other = (DungeonBedRoom)o;
        return other.canEqual(this);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DungeonBedRoom;
    }

    @Override
    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

