/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.rooms.prototype;

import com.github.srwaggon.minecraft.block.BlockType;
import com.github.srwaggon.minecraft.block.SingleBlockBrush;
import com.github.srwaggon.minecraft.block.normal.Wood;
import greymerk.roguelike.dungeon.Dungeon;
import greymerk.roguelike.dungeon.base.DungeonBase;
import greymerk.roguelike.dungeon.rooms.RoomSetting;
import greymerk.roguelike.dungeon.settings.LevelSettings;
import greymerk.roguelike.treasure.loot.ChestType;
import greymerk.roguelike.worldgen.BlockBrush;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.Direction;
import greymerk.roguelike.worldgen.WorldEditor;
import greymerk.roguelike.worldgen.shapes.RectHollow;
import greymerk.roguelike.worldgen.shapes.RectSolid;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class DungeonsWood
extends DungeonBase {
    public DungeonsWood(RoomSetting roomSetting, LevelSettings levelSettings, WorldEditor worldEditor) {
        super(roomSetting, levelSettings, worldEditor);
    }

    @Override
    public DungeonBase generate(Coord origin, List<Direction> entrances) {
        Random random = this.worldEditor.getRandom(origin);
        int x = origin.getX();
        int y = origin.getY();
        int z = origin.getZ();
        int HEIGHT = 3;
        int WIDTH = random.nextInt(2) + 2;
        int LENGTH = random.nextInt(2) + 3;
        Wood wood = Wood.values()[random.nextInt(Wood.values().length)];
        BlockBrush pillar = wood.getLog();
        SingleBlockBrush planks = Wood.OAK.getPlanks();
        BlockBrush glowstone = this.levelSettings.getTheme().getPrimary().getLightBlock();
        RectSolid.newRect(new Coord(x - WIDTH, y, z - LENGTH), new Coord(x + WIDTH, y + 3, z + LENGTH)).fill(this.worldEditor, SingleBlockBrush.AIR);
        RectHollow.newRect(new Coord(x - WIDTH - 1, y - 1, z - LENGTH - 1), new Coord(x + WIDTH + 1, y + 3 + 1, z + LENGTH + 1)).fill(this.worldEditor, planks, false, true);
        RectSolid.newRect(new Coord(x - WIDTH, y, z - LENGTH), new Coord(x - WIDTH, y + 3, z - LENGTH)).fill(this.worldEditor, pillar);
        RectSolid.newRect(new Coord(x - WIDTH, y, z + LENGTH), new Coord(x - WIDTH, y + 3, z + LENGTH)).fill(this.worldEditor, pillar);
        RectSolid.newRect(new Coord(x + WIDTH, y, z - LENGTH), new Coord(x + WIDTH, y + 3, z - LENGTH)).fill(this.worldEditor, pillar);
        RectSolid.newRect(new Coord(x + WIDTH, y, z + LENGTH), new Coord(x + WIDTH, y + 3, z + LENGTH)).fill(this.worldEditor, pillar);
        glowstone.stroke(this.worldEditor, new Coord(x - WIDTH + 1, y - 1, z - LENGTH + 1));
        glowstone.stroke(this.worldEditor, new Coord(x - WIDTH + 1, y - 1, z + LENGTH - 1));
        glowstone.stroke(this.worldEditor, new Coord(x + WIDTH - 1, y - 1, z - LENGTH + 1));
        glowstone.stroke(this.worldEditor, new Coord(x + WIDTH - 1, y - 1, z + LENGTH - 1));
        planks.stroke(this.worldEditor, new Coord(x, y, z));
        BlockType.CAKE.getBrush().stroke(this.worldEditor, new Coord(x, y + 1, z));
        ArrayList<Coord> spaces = new ArrayList<Coord>();
        spaces.add(new Coord(x - WIDTH, y, z - LENGTH + 1));
        spaces.add(new Coord(x - WIDTH, y, z + LENGTH - 1));
        spaces.add(new Coord(x + WIDTH, y, z - LENGTH + 1));
        spaces.add(new Coord(x + WIDTH, y, z + LENGTH - 1));
        List<Coord> chestLocations = this.chooseRandomLocations(1, spaces);
        this.worldEditor.getTreasureChestEditor().createChests(chestLocations, false, Dungeon.getLevel(y), this.getRoomSetting().getChestType().orElse(ChestType.FOOD));
        return this;
    }

    @Override
    public int getSize() {
        return 6;
    }
}

