/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.segment;

import com.github.srwaggon.minecraft.block.normal.StairsBlock;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import greymerk.roguelike.dungeon.DungeonLevel;
import greymerk.roguelike.dungeon.segment.ISegment;
import greymerk.roguelike.dungeon.segment.ISegmentGenerator;
import greymerk.roguelike.dungeon.segment.Segment;
import greymerk.roguelike.theme.ThemeBase;
import greymerk.roguelike.util.WeightedChoice;
import greymerk.roguelike.util.WeightedRandomizer;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.Direction;
import greymerk.roguelike.worldgen.WorldEditor;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class SegmentGenerator
implements ISegmentGenerator {
    protected Segment arch = Segment.ARCH;
    protected WeightedRandomizer<Segment> segments;

    public SegmentGenerator() {
        this(Segment.ARCH);
    }

    public SegmentGenerator(Segment arch) {
        this.segments = new WeightedRandomizer();
        this.arch = arch;
    }

    public SegmentGenerator(JsonObject json) {
        String archType = json.get("arch").getAsString();
        this.arch = Segment.valueOf(archType);
        this.segments = new WeightedRandomizer();
        JsonArray segmentList = json.get("segments").getAsJsonArray();
        for (JsonElement jsonElement : segmentList) {
            if (jsonElement.isJsonNull()) continue;
            JsonObject segData = jsonElement.getAsJsonObject();
            this.add(segData);
        }
    }

    public static SegmentGenerator getRandom(Random rand, int count) {
        SegmentGenerator segments = new SegmentGenerator(Segment.ARCH);
        for (int i = 0; i < count; ++i) {
            segments.add(Segment.getRandom(rand), 1);
        }
        return segments;
    }

    public void add(JsonObject entry) {
        String segType = entry.get("type").getAsString();
        Segment segment = Segment.valueOf(segType);
        if (entry.has("arch")) {
            boolean a = entry.get("arch").getAsBoolean();
            if (a) {
                this.arch = segment;
            }
            return;
        }
        int weight = entry.has("weight") ? entry.get("weight").getAsInt() : 1;
        this.segments.add(new WeightedChoice<Segment>(segment, weight));
    }

    public SegmentGenerator inherit(SegmentGenerator toInherit) {
        SegmentGenerator segmentGenerator = new SegmentGenerator();
        segmentGenerator.add(toInherit);
        segmentGenerator.add(this);
        return segmentGenerator;
    }

    public void add(SegmentGenerator segmentGenerator) {
        this.arch = segmentGenerator.arch;
        this.segments.merge(segmentGenerator.segments);
    }

    public void add(Segment segment, int weight) {
        this.segments.add(new WeightedChoice<Segment>(segment, weight));
    }

    @Override
    public List<ISegment> genSegment(WorldEditor editor, Random rand, DungeonLevel level, Direction dir, Coord pos) {
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        ArrayList<ISegment> segments = new ArrayList<ISegment>();
        for (Direction direction : dir.orthogonals()) {
            ISegment segment = this.pickSegment(rand, dir, pos);
            if (segment == null) {
                return segments;
            }
            segment.generate(editor, rand, level, direction, level.getSettings().getTheme(), pos.copy());
            segments.add(segment);
        }
        if (!level.hasNearbyNode(pos) && rand.nextInt(3) == 0) {
            this.addSupport(editor, rand, level.getSettings().getTheme(), x, y, z);
        }
        return segments;
    }

    private ISegment pickSegment(Random rand, Direction dir, Coord pos) {
        int x = pos.getX();
        int z = pos.getZ();
        if ((dir == Direction.NORTH || dir == Direction.SOUTH) && z % 3 == 0) {
            if (z % 6 == 0) {
                return Segment.getSegment(this.arch);
            }
            return this.segments.isEmpty() ? Segment.getSegment(Segment.WALL) : Segment.getSegment(this.segments.get(rand));
        }
        if ((dir == Direction.WEST || dir == Direction.EAST) && x % 3 == 0) {
            if (x % 6 == 0) {
                return Segment.getSegment(this.arch);
            }
            return this.segments.isEmpty() ? Segment.getSegment(Segment.WALL) : Segment.getSegment(this.segments.get(rand));
        }
        return null;
    }

    private void addSupport(WorldEditor editor, Random rand, ThemeBase theme, int x, int y, int z) {
        if (!editor.isAirBlock(new Coord(x, y - 2, z))) {
            return;
        }
        editor.fillDown(new Coord(x, y - 2, z), theme.getPrimary().getPillar());
        StairsBlock stair = theme.getPrimary().getStair();
        stair.setUpsideDown(true).setFacing(Direction.WEST).stroke(editor, new Coord(x - 1, y - 2, z));
        stair.setUpsideDown(true).setFacing(Direction.EAST).stroke(editor, new Coord(x + 1, y - 2, z));
        stair.setUpsideDown(true).setFacing(Direction.SOUTH).stroke(editor, new Coord(x, y - 2, z + 1));
        stair.setUpsideDown(true).setFacing(Direction.NORTH).stroke(editor, new Coord(x, y - 2, z - 1));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SegmentGenerator)) {
            return false;
        }
        SegmentGenerator other = (SegmentGenerator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Segment this$arch = this.arch;
        Segment other$arch = other.arch;
        if (this$arch == null ? other$arch != null : !((Object)((Object)this$arch)).equals((Object)other$arch)) {
            return false;
        }
        WeightedRandomizer<Segment> this$segments = this.segments;
        WeightedRandomizer<Segment> other$segments = other.segments;
        return !(this$segments == null ? other$segments != null : !((Object)this$segments).equals(other$segments));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SegmentGenerator;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Segment $arch = this.arch;
        result = result * 59 + ($arch == null ? 43 : ((Object)((Object)$arch)).hashCode());
        WeightedRandomizer<Segment> $segments = this.segments;
        result = result * 59 + ($segments == null ? 43 : ((Object)$segments).hashCode());
        return result;
    }

    public String toString() {
        return "SegmentGenerator(arch=" + (Object)((Object)this.arch) + ", segments=" + this.segments + ")";
    }
}

