/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.segment;

import com.github.srwaggon.minecraft.block.normal.StairsBlock;
import greymerk.roguelike.dungeon.DungeonLevel;
import greymerk.roguelike.dungeon.segment.ISegment;
import greymerk.roguelike.dungeon.segment.ISegmentGenerator;
import greymerk.roguelike.dungeon.segment.Segment;
import greymerk.roguelike.theme.ThemeBase;
import greymerk.roguelike.util.WeightedChoice;
import greymerk.roguelike.util.WeightedRandomizer;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.Direction;
import greymerk.roguelike.worldgen.WorldEditor;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class SegmentGeneratorBase
implements ISegmentGenerator {
    protected Segment arch;
    protected WeightedRandomizer<Segment> segments = new WeightedRandomizer();

    public SegmentGeneratorBase() {
        this.segments.add(new WeightedChoice<Segment>(Segment.SHELF, 1));
        this.segments.add(new WeightedChoice<Segment>(Segment.INSET, 1));
        this.segments.add(new WeightedChoice<Segment>(Segment.DOOR, 1));
        this.segments.add(new WeightedChoice<Segment>(Segment.FIREPLACE, 1));
        this.arch = Segment.ARCH;
    }

    public void add(Segment toAdd, int weight) {
        this.segments.add(new WeightedChoice<Segment>(toAdd, weight));
    }

    @Override
    public List<ISegment> genSegment(WorldEditor editor, Random rand, DungeonLevel level, Direction dir, Coord pos) {
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        ArrayList<ISegment> segs = new ArrayList<ISegment>();
        for (Direction orth : dir.orthogonals()) {
            ISegment seg = this.pickSegment(editor, rand, level, dir, pos);
            if (seg == null) {
                return segs;
            }
            seg.generate(editor, rand, level, orth, level.getSettings().getTheme(), pos.copy());
            segs.add(seg);
        }
        if (!level.hasNearbyNode(pos) && rand.nextInt(3) == 0) {
            this.addSupport(editor, rand, level.getSettings().getTheme(), x, y, z);
        }
        return segs;
    }

    private ISegment pickSegment(WorldEditor editor, Random rand, DungeonLevel level, Direction dir, Coord pos) {
        int x = pos.getX();
        int z = pos.getZ();
        if ((dir == Direction.NORTH || dir == Direction.SOUTH) && z % 3 == 0) {
            if (z % 6 == 0) {
                return Segment.getSegment(this.arch);
            }
            return Segment.getSegment(this.segments.get(rand));
        }
        if ((dir == Direction.WEST || dir == Direction.EAST) && x % 3 == 0) {
            if (x % 6 == 0) {
                return Segment.getSegment(this.arch);
            }
            return Segment.getSegment(this.segments.get(rand));
        }
        return null;
    }

    private void addSupport(WorldEditor editor, Random rand, ThemeBase theme, int x, int y, int z) {
        if (!editor.isAirBlock(new Coord(x, y - 2, z))) {
            return;
        }
        editor.fillDown(new Coord(x, y - 2, z), theme.getPrimary().getPillar());
        StairsBlock stair = theme.getPrimary().getStair();
        stair.setUpsideDown(true).setFacing(Direction.WEST);
        stair.stroke(editor, new Coord(x - 1, y - 2, z));
        stair.setUpsideDown(true).setFacing(Direction.EAST);
        stair.stroke(editor, new Coord(x + 1, y - 2, z));
        stair.setUpsideDown(true).setFacing(Direction.SOUTH);
        stair.stroke(editor, new Coord(x, y - 2, z + 1));
        stair.setUpsideDown(true).setFacing(Direction.NORTH);
        stair.stroke(editor, new Coord(x, y - 2, z - 1));
    }
}

