/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.settings;

import greymerk.roguelike.dungeon.LevelGenerator;
import greymerk.roguelike.dungeon.base.RoomsSetting;
import greymerk.roguelike.dungeon.base.SecretsSetting;
import greymerk.roguelike.dungeon.segment.SegmentGenerator;
import greymerk.roguelike.dungeon.settings.DungeonSettings;
import greymerk.roguelike.dungeon.settings.LevelSettings;
import greymerk.roguelike.dungeon.settings.TowerSettings;
import greymerk.roguelike.dungeon.towers.Tower;
import greymerk.roguelike.theme.Theme;
import greymerk.roguelike.treasure.loot.ChestType;
import greymerk.roguelike.treasure.loot.Equipment;
import greymerk.roguelike.treasure.loot.ILoot;
import greymerk.roguelike.treasure.loot.Loot;
import greymerk.roguelike.treasure.loot.Quality;
import greymerk.roguelike.treasure.loot.provider.ItemEnchBook;
import greymerk.roguelike.treasure.loot.provider.ItemSpecialty;
import greymerk.roguelike.treasure.loot.rule.ForEachLootRule;
import greymerk.roguelike.treasure.loot.rule.SingleUseLootRule;
import greymerk.roguelike.treasure.loot.rule.TypedForEachLootRule;
import java.util.Random;
import java.util.stream.IntStream;

public class SettingsRandom
extends DungeonSettings {
    public SettingsRandom(Random rand) {
        this.setTowerSettings(new TowerSettings(Tower.randomTower(rand), Theme.randomTheme()));
        IntStream.range(0, 5).forEach(i -> this.getLevelSettings().put(i, this.createRandomLevel(rand, i)));
        ILoot loot = Loot.getLoot();
        this.getLootRules().add(new TypedForEachLootRule(ChestType.STARTER, loot.get(Loot.WEAPON, 0), 0, 2));
        this.getLootRules().add(new TypedForEachLootRule(ChestType.STARTER, loot.get(Loot.FOOD, 0), 0, 2));
        this.getLootRules().add(new TypedForEachLootRule(ChestType.STARTER, loot.get(Loot.TOOL, 0), 0, 2));
        this.getLootRules().add(new TypedForEachLootRule(ChestType.STARTER, loot.get(Loot.SUPPLY, 0), 0, 2));
        this.getLootRules().add(new TypedForEachLootRule(ChestType.STARTER, new ItemSpecialty(0, 0, Equipment.LEGS, Quality.WOOD), 0, 2));
        for (int i2 = 0; i2 < 5; ++i2) {
            this.getLootRules().add(new TypedForEachLootRule(ChestType.ARMOUR, loot.get(Loot.POTION, i2), i2, 1));
            this.getLootRules().add(new TypedForEachLootRule(ChestType.ARMOUR, loot.get(Loot.ARMOUR, i2), i2, 1));
            this.getLootRules().add(new TypedForEachLootRule(ChestType.ARMOUR, loot.get(Loot.FOOD, i2), i2, 1));
            this.getLootRules().add(new TypedForEachLootRule(ChestType.WEAPONS, loot.get(Loot.POTION, i2), i2, 1));
            this.getLootRules().add(new TypedForEachLootRule(ChestType.WEAPONS, loot.get(Loot.WEAPON, i2), i2, 1));
            this.getLootRules().add(new TypedForEachLootRule(ChestType.WEAPONS, loot.get(Loot.FOOD, i2), i2, 1));
            this.getLootRules().add(new TypedForEachLootRule(ChestType.BLOCKS, loot.get(Loot.BLOCK, i2), i2, 6));
            this.getLootRules().add(new TypedForEachLootRule(ChestType.WEAPONS, loot.get(Loot.FOOD, i2), i2, 1));
            this.getLootRules().add(new TypedForEachLootRule(ChestType.ENCHANTING, loot.get(Loot.ENCHANTBONUS, i2), i2, 2));
            this.getLootRules().add(new TypedForEachLootRule(ChestType.ENCHANTING, loot.get(Loot.ENCHANTBOOK, i2), i2, 1));
            this.getLootRules().add(new TypedForEachLootRule(ChestType.FOOD, loot.get(Loot.FOOD, i2), i2, 8));
            this.getLootRules().add(new TypedForEachLootRule(ChestType.ORE, loot.get(Loot.ORE, i2), i2, 5));
            this.getLootRules().add(new TypedForEachLootRule(ChestType.POTIONS, loot.get(Loot.POTION, i2), i2, 6));
            this.getLootRules().add(new TypedForEachLootRule(ChestType.TOOLS, loot.get(Loot.ORE, i2), i2, 1));
            this.getLootRules().add(new TypedForEachLootRule(ChestType.TOOLS, loot.get(Loot.TOOL, i2), i2, 1));
            this.getLootRules().add(new TypedForEachLootRule(ChestType.TOOLS, loot.get(Loot.BLOCK, i2), i2, 1));
            this.getLootRules().add(new TypedForEachLootRule(ChestType.SUPPLIES, loot.get(Loot.SUPPLY, i2), i2, 6));
            this.getLootRules().add(new TypedForEachLootRule(ChestType.SMITH, loot.get(Loot.ORE, i2), i2, 6));
            this.getLootRules().add(new TypedForEachLootRule(ChestType.SMITH, loot.get(Loot.SMITHY, i2), i2, 1));
            this.getLootRules().add(new TypedForEachLootRule(ChestType.MUSIC, loot.get(Loot.MUSIC, i2), i2, 1));
            this.getLootRules().add(new TypedForEachLootRule(ChestType.REWARD, loot.get(Loot.REWARD, i2), i2, 1));
            this.getLootRules().add(new ForEachLootRule(loot.get(Loot.JUNK, i2), i2, 6));
            this.getLootRules().add(new SingleUseLootRule(new ItemSpecialty(0, i2, Quality.get(i2)), i2, 3));
            this.getLootRules().add(new SingleUseLootRule(new ItemEnchBook(0, i2), i2, i2 * 2 + 5));
        }
    }

    private LevelSettings createRandomLevel(Random rand, int i) {
        LevelSettings level = new LevelSettings();
        level.setDifficulty(i);
        level.setGenerator(LevelGenerator.CLASSIC);
        level.setNumRooms(15);
        level.setRange(60);
        level.setRooms(RoomsSetting.getRandom(rand, 8));
        level.setScatter(15);
        level.setSecrets(SecretsSetting.getRandom(rand, 2));
        level.setSegments(SegmentGenerator.getRandom(rand, 12));
        level.setTheme(Theme.randomTheme());
        return level;
    }
}

