/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.settings.base;

import com.google.common.collect.Lists;
import greymerk.roguelike.dungeon.settings.DungeonSettings;
import greymerk.roguelike.dungeon.settings.SettingIdentifier;
import greymerk.roguelike.treasure.loot.Book;
import greymerk.roguelike.treasure.loot.ChestType;
import greymerk.roguelike.treasure.loot.Equipment;
import greymerk.roguelike.treasure.loot.ILoot;
import greymerk.roguelike.treasure.loot.Loot;
import greymerk.roguelike.treasure.loot.LootTableRule;
import greymerk.roguelike.treasure.loot.Quality;
import greymerk.roguelike.treasure.loot.provider.ItemEnchBook;
import greymerk.roguelike.treasure.loot.provider.ItemSpecialty;
import greymerk.roguelike.treasure.loot.rule.ForEachLootRule;
import greymerk.roguelike.treasure.loot.rule.SingleUseLootRule;
import greymerk.roguelike.treasure.loot.rule.TypedForEachLootRule;
import greymerk.roguelike.util.WeightedChoice;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootTableList;

public class SettingsLootRules
extends DungeonSettings {
    public static final SettingIdentifier ID = new SettingIdentifier("builtin", "loot");

    public SettingsLootRules() {
        super(ID);
        ILoot loot = Loot.getLoot();
        this.addStarterLoot(loot);
        this.addRewardLoot();
        for (int i = 0; i < 5; ++i) {
            this.getLootRules().add(new TypedForEachLootRule(ChestType.ARMOUR, loot.get(Loot.POTION, i), i, 1));
            this.getLootRules().add(new TypedForEachLootRule(ChestType.ARMOUR, loot.get(Loot.ARMOUR, i), i, 1));
            this.getLootRules().add(new TypedForEachLootRule(ChestType.ARMOUR, loot.get(Loot.FOOD, i), i, 1));
            this.getLootRules().add(new TypedForEachLootRule(ChestType.WEAPONS, loot.get(Loot.POTION, i), i, 1));
            this.getLootRules().add(new TypedForEachLootRule(ChestType.WEAPONS, loot.get(Loot.WEAPON, i), i, 1));
            this.getLootRules().add(new TypedForEachLootRule(ChestType.WEAPONS, loot.get(Loot.FOOD, i), i, 1));
            this.getLootRules().add(new TypedForEachLootRule(ChestType.WEAPONS, loot.get(Loot.FOOD, i), i, 1));
            this.getLootRules().add(new TypedForEachLootRule(ChestType.BLOCKS, loot.get(Loot.BLOCK, i), i, 6));
            this.getLootRules().add(new TypedForEachLootRule(ChestType.ENCHANTING, loot.get(Loot.ENCHANTBONUS, i), i, 2));
            this.getLootRules().add(new TypedForEachLootRule(ChestType.ENCHANTING, loot.get(Loot.ENCHANTBOOK, i), i, 1));
            this.getLootRules().add(new TypedForEachLootRule(ChestType.FOOD, loot.get(Loot.FOOD, i), i, 8));
            this.getLootRules().add(new TypedForEachLootRule(ChestType.ORE, loot.get(Loot.ORE, i), i, 5));
            this.getLootRules().add(new TypedForEachLootRule(ChestType.POTIONS, loot.get(Loot.POTION, i), i, 6));
            this.getLootRules().add(new TypedForEachLootRule(ChestType.BREWING, loot.get(Loot.BREWING, i), i, 8));
            this.getLootRules().add(new TypedForEachLootRule(ChestType.TOOLS, loot.get(Loot.ORE, i), i, 1));
            this.getLootRules().add(new TypedForEachLootRule(ChestType.TOOLS, loot.get(Loot.TOOL, i), i, 1));
            this.getLootRules().add(new TypedForEachLootRule(ChestType.TOOLS, loot.get(Loot.BLOCK, i), i, 1));
            this.getLootRules().add(new TypedForEachLootRule(ChestType.SUPPLIES, loot.get(Loot.SUPPLY, i), i, 6));
            this.getLootRules().add(new TypedForEachLootRule(ChestType.SMITH, loot.get(Loot.ORE, i), i, 6));
            this.getLootRules().add(new TypedForEachLootRule(ChestType.SMITH, loot.get(Loot.SMITHY, i), i, 1));
            this.getLootRules().add(new TypedForEachLootRule(ChestType.MUSIC, loot.get(Loot.MUSIC, i), i, 1));
            this.getLootRules().add(new TypedForEachLootRule(ChestType.REWARD, loot.get(Loot.REWARD, i), i, 1));
            this.getLootRules().add(new ForEachLootRule(loot.get(Loot.JUNK, i), i, 6));
            this.getLootRules().add(new SingleUseLootRule(new ItemSpecialty(0, i, Quality.get(i)), i, 3));
            this.getLootRules().add(new SingleUseLootRule(new ItemEnchBook(0, i), i, i * 2 + 5));
        }
    }

    private void addRewardLoot() {
        this.useLootTableForLevel(LootTableList.field_186422_d, 0);
        this.useLootTableForLevel(LootTableList.field_186429_k, 1);
        this.useLootTableForLevel(LootTableList.field_186430_l, 2);
        this.useLootTableForLevel(LootTableList.field_186425_g, 3);
        this.useLootTableForLevel(LootTableList.field_186421_c, 4);
    }

    private void useLootTableForLevel(ResourceLocation chestsSimpleDungeon, int level) {
        this.getLootTables().add(new LootTableRule(Lists.newArrayList((Object[])new Integer[]{level}), chestsSimpleDungeon.func_110623_a(), Lists.newArrayList((Object[])new ChestType[]{ChestType.REWARD})));
    }

    private void addStarterLoot(ILoot loot) {
        this.getLootRules().add(new TypedForEachLootRule(ChestType.STARTER, new WeightedChoice<ItemStack>(Book.get(Book.CREDITS), 1), 0, 1));
        this.getLootRules().add(new TypedForEachLootRule(ChestType.STARTER, loot.get(Loot.WEAPON, 0), 0, 2));
        this.getLootRules().add(new TypedForEachLootRule(ChestType.STARTER, loot.get(Loot.FOOD, 0), 0, 2));
        this.getLootRules().add(new TypedForEachLootRule(ChestType.STARTER, loot.get(Loot.TOOL, 0), 0, 2));
        this.getLootRules().add(new TypedForEachLootRule(ChestType.STARTER, loot.get(Loot.SUPPLY, 0), 0, 2));
        this.getLootRules().add(new TypedForEachLootRule(ChestType.STARTER, new ItemSpecialty(0, 0, Equipment.LEGS, Quality.WOOD), 0, 2));
    }
}

