/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.settings.base;

import com.google.common.collect.Lists;
import greymerk.roguelike.dungeon.base.RoomType;
import greymerk.roguelike.dungeon.base.RoomsSetting;
import greymerk.roguelike.dungeon.rooms.RoomSetting;
import greymerk.roguelike.dungeon.settings.DungeonSettings;
import greymerk.roguelike.dungeon.settings.LevelSettings;
import greymerk.roguelike.dungeon.settings.SettingIdentifier;
import java.util.List;

public class SettingsRooms
extends DungeonSettings {
    public static final SettingIdentifier ID = new SettingIdentifier("builtin", "rooms");

    public SettingsRooms() {
        super(ID);
        this.addRoomsToLevel(0, this.getLevel0Rooms());
        this.addRoomsToLevel(1, this.getLevel1Rooms());
        this.addRoomsToLevel(2, this.getLevel2Rooms());
        this.addRoomsToLevel(3, this.getLevel3Rooms());
        this.addRoomsToLevel(4, this.getLevel4Rooms());
    }

    private void addRoomsToLevel(int i, List<RoomSetting> rooms) {
        RoomsSetting roomSetting = new RoomsSetting();
        rooms.forEach(roomSetting::add);
        LevelSettings level = new LevelSettings();
        level.setRooms(roomSetting);
        this.getLevelSettings().put(i, level);
    }

    private List<RoomSetting> getLevel0Rooms() {
        return Lists.newArrayList((Object[])new RoomSetting[]{RoomType.CAKE.newSingleRoomSetting(), RoomType.FIRE.newSingleRoomSetting(), RoomType.BRICK.newRandomRoomSetting(4), RoomType.CORNER.newRandomRoomSetting(2), RoomType.REWARD.newSingleRoomSetting()});
    }

    private List<RoomSetting> getLevel1Rooms() {
        return Lists.newArrayList((Object[])new RoomSetting[]{RoomType.PIT.newSingleRoomSetting(), RoomType.CORNER.newRandomRoomSetting(10), RoomType.BRICK.newRandomRoomSetting(3), RoomType.REWARD.newSingleRoomSetting()});
    }

    private List<RoomSetting> getLevel2Rooms() {
        return Lists.newArrayList((Object[])new RoomSetting[]{RoomType.OSSUARY.newSingleRoomSetting(), RoomType.CRYPT.newSingleRoomSetting(), RoomType.CREEPER.newSingleRoomSetting(), RoomType.FIRE.newSingleRoomSetting(), RoomType.SPIDER.newSingleRoomSetting(), RoomType.PRISON.newSingleRoomSetting(), RoomType.CRYPT.newRandomRoomSetting(5), RoomType.CORNER.newRandomRoomSetting(5), RoomType.BRICK.newRandomRoomSetting(3), RoomType.REWARD.newSingleRoomSetting()});
    }

    private List<RoomSetting> getLevel3Rooms() {
        return Lists.newArrayList((Object[])new RoomSetting[]{RoomType.OSSUARY.newSingleRoomSetting(), RoomType.ENDER.newSingleRoomSetting(), RoomType.CRYPT.newSingleRoomSetting(), RoomType.PRISON.newRandomRoomSetting(3), RoomType.SLIME.newRandomRoomSetting(5), RoomType.CREEPER.newRandomRoomSetting(1), RoomType.SPIDER.newRandomRoomSetting(1), RoomType.PIT.newRandomRoomSetting(1), RoomType.REWARD.newSingleRoomSetting()});
    }

    private List<RoomSetting> getLevel4Rooms() {
        return Lists.newArrayList((Object[])new RoomSetting[]{RoomType.OBSIDIAN.newSingleRoomSetting(), RoomType.BLAZE.newSingleRoomSetting(), RoomType.PRISON.newSingleRoomSetting(), RoomType.DARKHALL.newSingleRoomSetting(), RoomType.NETHERFORT.newSingleRoomSetting(), RoomType.SLIME.newRandomRoomSetting(10), RoomType.BLAZE.newRandomRoomSetting(3), RoomType.NETHER.newRandomRoomSetting(3), RoomType.SPIDER.newRandomRoomSetting(2), RoomType.REWARD.newSingleRoomSetting()});
    }
}

