/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.settings.builtin;

import com.google.common.collect.Lists;
import greymerk.roguelike.dungeon.base.RoomType;
import greymerk.roguelike.dungeon.base.RoomsSetting;
import greymerk.roguelike.dungeon.base.SecretsSetting;
import greymerk.roguelike.dungeon.segment.Segment;
import greymerk.roguelike.dungeon.segment.SegmentGenerator;
import greymerk.roguelike.dungeon.settings.DungeonSettings;
import greymerk.roguelike.dungeon.settings.LevelSettings;
import greymerk.roguelike.dungeon.settings.SettingIdentifier;
import greymerk.roguelike.dungeon.settings.TowerSettings;
import greymerk.roguelike.dungeon.settings.base.SettingsBase;
import greymerk.roguelike.dungeon.towers.Tower;
import greymerk.roguelike.theme.Theme;
import greymerk.roguelike.worldgen.filter.Filter;
import net.minecraftforge.common.BiomeDictionary;

public class SettingsMountainTheme
extends DungeonSettings {
    public static final SettingIdentifier ID = new SettingIdentifier("builtin", "mountain");

    public SettingsMountainTheme() {
        super(ID);
        this.setExclusive(true);
        this.getInherit().add(SettingsBase.ID);
        this.getCriteria().setBiomeTypes(Lists.newArrayList((Object[])new BiomeDictionary.Type[]{BiomeDictionary.Type.MOUNTAIN}));
        this.setTowerSettings(new TowerSettings(Tower.ENIKO, Theme.OAK));
        Theme[] themes = new Theme[]{Theme.ENIKO, Theme.ENIKO2, Theme.SEWER, Theme.MOSSY, Theme.NETHER};
        for (int i = 0; i < 5; ++i) {
            SecretsSetting secrets;
            RoomsSetting factory;
            LevelSettings level = new LevelSettings();
            level.setTheme(themes[i].getThemeBase());
            if (i == 0) {
                level.setScatter(16);
                level.setRange(60);
                level.setNumRooms(10);
                factory = new RoomsSetting();
                factory.add(RoomType.LIBRARY.newSingleRoomSetting());
                factory.add(RoomType.FIRE.newSingleRoomSetting());
                RoomType.ENIKO.newRandomRoomSetting(10);
                RoomType.CORNER.newRandomRoomSetting(3);
                level.setRooms(factory);
                secrets = new SecretsSetting();
                secrets.add(RoomType.BEDROOM.newSingleRoomSetting());
                secrets.add(RoomType.BEDROOM.newSingleRoomSetting());
                secrets.add(RoomType.SMITH.newSingleRoomSetting());
                level.setSecrets(secrets);
                SegmentGenerator segments = new SegmentGenerator(Segment.ARCH);
                segments.add(Segment.DOOR, 7);
                segments.add(Segment.ANKH, 2);
                segments.add(Segment.PLANT, 3);
                segments.add(Segment.LAMP, 1);
                segments.add(Segment.FLOWERS, 1);
                level.setSegments(segments);
            }
            if (i == 1) {
                level.setScatter(16);
                level.setRange(80);
                level.setNumRooms(20);
                factory = new RoomsSetting();
                factory.add(RoomType.FIRE.newSingleRoomSetting());
                factory.add(RoomType.MESS.newSingleRoomSetting());
                factory.add(RoomType.LIBRARY.newSingleRoomSetting());
                factory.add(RoomType.LAB.newSingleRoomSetting());
                factory.add(RoomType.ENIKO.newRandomRoomSetting(10));
                factory.add(RoomType.CORNER.newRandomRoomSetting(3));
                level.setRooms(factory);
                secrets = new SecretsSetting();
                secrets.add(RoomType.ENCHANT.newSingleRoomSetting());
                level.setSecrets(secrets);
            }
            if (i == 2) {
                level.setDifficulty(4);
                SegmentGenerator segments = new SegmentGenerator(Segment.SEWERARCH);
                segments.add(Segment.SEWER, 7);
                segments.add(Segment.SEWERDRAIN, 4);
                segments.add(Segment.SEWERDOOR, 2);
                level.setSegments(segments);
                RoomsSetting factory2 = new RoomsSetting();
                factory2.add(RoomType.BRICK.newRandomRoomSetting(4));
                factory2.add(RoomType.SLIME.newRandomRoomSetting(7));
                factory2.add(RoomType.CORNER.newRandomRoomSetting(3));
                factory2.add(RoomType.SPIDER.newRandomRoomSetting(2));
                factory2.add(RoomType.PIT.newRandomRoomSetting(2));
                factory2.add(RoomType.PRISON.newRandomRoomSetting(3));
                level.setRooms(factory2);
            }
            this.getLevelSettings().put(i, level);
        }
        this.getLevelSettings().get(3).addFilter(Filter.VINE);
    }
}

