/*
 * Decompiled with CFR 0.152.
 */
package com.github.fnar.roguelike.dungeon.rooms;

import com.github.fnar.minecraft.block.SingleBlockBrush;
import com.github.fnar.minecraft.block.normal.StairsBlock;
import com.github.fnar.minecraft.worldgen.generatables.NetherPortal;
import greymerk.roguelike.dungeon.base.DungeonBase;
import greymerk.roguelike.dungeon.rooms.RoomSetting;
import greymerk.roguelike.dungeon.settings.LevelSettings;
import greymerk.roguelike.worldgen.BlockBrush;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.Direction;
import greymerk.roguelike.worldgen.WorldEditor;
import greymerk.roguelike.worldgen.shapes.RectHollow;
import greymerk.roguelike.worldgen.shapes.RectSolid;
import greymerk.roguelike.worldgen.spawners.MobType;
import java.util.List;
import java.util.stream.Stream;

public class NetherPortalRoom
extends DungeonBase {
    public NetherPortalRoom(RoomSetting roomsSetting, LevelSettings levelSettings, WorldEditor worldEditor) {
        super(roomsSetting, levelSettings, worldEditor);
    }

    @Override
    public DungeonBase generate(Coord origin, List<Direction> entrances) {
        Direction front = entrances.get(0);
        this.generateWalls(origin, front);
        this.theFloorsAreFloors(origin, front);
        this.generateCatwalks(origin);
        this.theFloorIsLava(origin, front);
        this.createPathFromEachEntranceToTheCenterOverTheLiquid(origin, entrances);
        this.ceilingChan(origin, front);
        this.generateNetherPortalWithPlatform(origin, entrances);
        this.generateDoorways(origin, entrances, this.getSize());
        return null;
    }

    private void generateWalls(Coord origin, Direction front) {
        BlockBrush walls = this.levelSettings.getTheme().getPrimary().getWall();
        RectHollow.newRect(origin.copy().translate(front.left(), this.getSize()).translate(front, this.getSize()).copy().down(3), origin.copy().translate(front.right(), this.getSize()).translate(front.back(), this.getSize()).copy().up(this.getHeight())).fill(this.worldEditor, walls);
    }

    private void theFloorsAreFloors(Coord origin, Direction front) {
        BlockBrush floors = this.levelSettings.getTheme().getPrimary().getFloor();
        RectSolid.newRect(origin.copy().translate(front.left(), 3).translate(front, 3).down(), origin.copy().translate(front.right(), 3).translate(front.back(), 3).down(2)).fill(this.worldEditor, floors);
    }

    private void generateCatwalks(Coord origin) {
        BlockBrush floors = this.levelSettings.getTheme().getPrimary().getFloor();
        StairsBlock stair = this.levelSettings.getTheme().getPrimary().getStair();
        for (Direction side : Direction.cardinals()) {
            Coord catwalkOrigin = origin.copy().translate(side, this.getSize() - 1);
            RectSolid.newRect(catwalkOrigin.copy().translate(side.left(), this.getSize()), catwalkOrigin.copy().translate(side.right(), this.getSize()).translate(side.back()).down(2)).fill(this.worldEditor, floors);
            RectSolid.newRect(catwalkOrigin.copy().translate(side.left(), 2), catwalkOrigin.copy().translate(side.right(), 2).translate(side.back())).fill(this.worldEditor, SingleBlockBrush.AIR);
            for (Direction orthogonal : side.orthogonals()) {
                stair.setUpsideDown(false).setFacing(orthogonal.reverse());
                stair.stroke(this.worldEditor, catwalkOrigin.copy().translate(orthogonal, 3));
                stair.stroke(this.worldEditor, catwalkOrigin.copy().translate(orthogonal, 3).translate(side.back()));
            }
        }
    }

    private void theFloorIsLava(Coord origin, Direction front) {
        BlockBrush liquid = this.levelSettings.getTheme().getPrimary().getLiquid();
        RectSolid.newRect(origin.copy().translate(front, this.getSize() - 1).translate(front.left(), this.getSize() - 1).down(), origin.copy().translate(front.back(), this.getSize() - 1).translate(front.right(), this.getSize() - 1).down(2)).fill(this.worldEditor, liquid, true, false);
    }

    private void createPathFromEachEntranceToTheCenterOverTheLiquid(Coord origin, List<Direction> entrances) {
        BlockBrush floors = this.levelSettings.getTheme().getPrimary().getFloor();
        Direction.cardinals().stream().filter(direction -> !entrances.contains(direction)).forEach(direction -> RectSolid.newRect(origin.copy().translate(direction.left()).down(), origin.copy().translate(direction.right()).translate((Direction)((Object)direction), this.getSize()).down(2)).fill(this.worldEditor, floors));
    }

    private void ceilingChan(Coord origin, Direction front) {
        BlockBrush floors = this.levelSettings.getTheme().getPrimary().getFloor();
        RectSolid.newRect(origin.copy().translate(front.left(), this.getSize()).translate(front, this.getSize()).up(this.getHeight()), origin.copy().translate(front.right(), this.getSize()).translate(front.back(), this.getSize()).up(this.getHeight())).fill(this.worldEditor, floors);
    }

    private void generateNetherPortalWithPlatform(Coord origin, List<Direction> entrances) {
        Direction front = entrances.get(0);
        BlockBrush pillar = this.levelSettings.getTheme().getPrimary().getPillar();
        RectSolid.newRect(origin.copy().translate(front).translate(front.left(), 3), origin.copy().translate(front.back()).translate(front.right(), 3).up(this.getHeight() - 1)).fill(this.worldEditor, pillar);
        RectSolid.newRect(origin.copy().translate(front.left(), 2).translate(front, 2), origin.copy().translate(front.right(), 2).translate(front.back(), 2)).fill(this.worldEditor, pillar);
        StairsBlock stairsBrush = this.levelSettings.getTheme().getPrimary().getStair();
        Stream.of(front, front.reverse()).forEach(side -> {
            Coord platformStairs = origin.copy().translate((Direction)((Object)side), 2);
            stairsBrush.setUpsideDown(false);
            stairsBrush.setFacing((Direction)((Object)side));
            stairsBrush.stroke(this.worldEditor, platformStairs);
            stairsBrush.stroke(this.worldEditor, platformStairs.copy().translate(front.left()));
            stairsBrush.stroke(this.worldEditor, platformStairs.copy().translate(front.right()));
        });
        Coord portalBase = origin.copy();
        new NetherPortal(this.worldEditor).generate(portalBase, front, 5, 7);
        for (Direction orthogonal : front.orthogonals()) {
            this.generateSpawner(portalBase.copy().down().translate(orthogonal), new MobType[0]);
        }
    }

    private int getHeight() {
        return 8;
    }

    @Override
    public int getSize() {
        return 10;
    }
}

