/*
 * Decompiled with CFR 0.152.
 */
package com.github.fnar.roguelike.dungeon.rooms;

import com.github.fnar.minecraft.block.SingleBlockBrush;
import com.github.fnar.minecraft.block.normal.StairsBlock;
import com.github.fnar.minecraft.worldgen.BlockPattern;
import com.github.fnar.minecraft.worldgen.shape.FnarLine;
import greymerk.roguelike.dungeon.base.DungeonBase;
import greymerk.roguelike.dungeon.rooms.RoomSetting;
import greymerk.roguelike.dungeon.settings.LevelSettings;
import greymerk.roguelike.worldgen.BlockBrush;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.Direction;
import greymerk.roguelike.worldgen.WorldEditor;
import greymerk.roguelike.worldgen.shapes.RectHollow;
import greymerk.roguelike.worldgen.shapes.RectSolid;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class PlatformsRoom
extends DungeonBase {
    public PlatformsRoom(RoomSetting roomSetting, LevelSettings levelSettings, WorldEditor worldEditor) {
        super(roomSetting, levelSettings, worldEditor);
    }

    @Override
    public DungeonBase generate(Coord origin, List<Direction> entrances) {
        Direction front = entrances.get(0);
        this.generateWalls(origin, front);
        this.generateDoorways(origin, entrances, this.getSize());
        this.generateIslands(origin, front);
        this.theFloorIsLava(origin, front);
        this.generateCeilingDecoration(origin);
        return null;
    }

    private void generateIslands(Coord origin, Direction front) {
        BlockBrush pillar = this.levelSettings.getTheme().getPrimary().getPillar();
        Map<Character, BlockBrush> blockBrushMap = Stream.of({Character.valueOf('.'), SingleBlockBrush.AIR}, {Character.valueOf('x'), pillar}).collect(Collectors.toMap(data -> (Character)data[0], data -> (BlockBrush)data[1]));
        for (int x = 0; x < 2; ++x) {
            for (int z = 0; z < 2; ++z) {
                int xOffset = (x == 0 ? -1 : 1) * (this.getSize() / 2);
                int zOffset = (z == 0 ? -1 : 1) * (this.getSize() / 2);
                Coord location = origin.copy().down(2).translate(front.left()).translate(front).translate(front.left(), xOffset).translate(front, zOffset);
                BlockPattern blockPattern = new BlockPattern(this.worldEditor, this.chooseRandomBlockPattern(), blockBrushMap);
                blockPattern.stroke(location, front, true, false);
                blockPattern.stroke(location.up(), front, true, false);
                if (!this.worldEditor.getRandom().nextBoolean()) continue;
                blockPattern.stroke(location.up(), front, true, false);
            }
        }
    }

    private String chooseRandomBlockPattern() {
        String[] patterns = this.blockPatternStrings();
        return patterns[(int)(Math.random() * (double)patterns.length)];
    }

    private String[] blockPatternStrings() {
        String blankPattern = "";
        String plusPatternString = ". x . \nx x x \n. x . \n";
        String squarePatternString = "x x x \nx x x \nx x x \n";
        String diamondPatternString = ". x x \nx x x \nx x . \n";
        return new String[]{blankPattern, plusPatternString, squarePatternString, diamondPatternString};
    }

    private void generateWalls(Coord origin, Direction front) {
        int depth = this.worldEditor.getRandom().nextBoolean() ? 2 : 3;
        BlockBrush walls = this.levelSettings.getTheme().getPrimary().getWall();
        RectHollow.newRect(origin.copy().translate(front.left(), this.getSize()).translate(front, this.getSize()).copy().down(depth), origin.copy().translate(front.right(), this.getSize()).translate(front.back(), this.getSize()).copy().up(this.getHeight())).fill(this.worldEditor, walls);
    }

    private void theFloorIsLava(Coord origin, Direction front) {
        BlockBrush liquid = this.levelSettings.getTheme().getPrimary().getLiquid();
        RectSolid.newRect(origin.copy().translate(front, this.getSize() - 1).translate(front.left(), this.getSize() - 1).down(), origin.copy().translate(front.back(), this.getSize() - 1).translate(front.right(), this.getSize() - 1).down(2)).fill(this.worldEditor, liquid, true, false);
    }

    private void generateCeilingDecoration(Coord origin) {
        BlockBrush pillar = this.levelSettings.getTheme().getSecondary().getPillar();
        StairsBlock stair = this.levelSettings.getTheme().getPrimary().getStair();
        Direction.cardinals().forEach(direction -> {
            Coord beamStart = origin.copy().translate((Direction)((Object)direction), this.getSize() / 2 - 1).translate(direction.left(), this.getSize() - 1).up(this.getHeight() - 2);
            Coord beamEnd = origin.copy().translate((Direction)((Object)direction), this.getSize() / 2 - 1).translate(direction.right(), this.getSize() - 1).up(this.getHeight() - 2);
            pillar.setFacing(direction.right());
            new FnarLine(beamStart, beamEnd).fill(this.worldEditor, pillar);
            stair.setUpsideDown(true);
            stair.setFacing(direction.right());
            stair.stroke(this.worldEditor, beamStart.down(2));
            pillar.stroke(this.worldEditor, beamStart.up());
            stair.stroke(this.worldEditor, beamStart.translate(direction.right()));
            stair.setUpsideDown(true);
            stair.setFacing(direction.left());
            stair.stroke(this.worldEditor, beamEnd.down(2));
            pillar.stroke(this.worldEditor, beamEnd.up());
            stair.stroke(this.worldEditor, beamEnd.translate(direction.left()));
        });
    }

    private int getHeight() {
        return 7;
    }

    @Override
    public int getSize() {
        return 7;
    }
}

