/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.rooms.prototype;

import com.github.fnar.minecraft.block.normal.StairsBlock;
import greymerk.roguelike.dungeon.base.DungeonBase;
import greymerk.roguelike.dungeon.rooms.RoomSetting;
import greymerk.roguelike.dungeon.settings.LevelSettings;
import greymerk.roguelike.theme.Theme;
import greymerk.roguelike.worldgen.BlockBrush;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.Direction;
import greymerk.roguelike.worldgen.WorldEditor;
import greymerk.roguelike.worldgen.shapes.RectHollow;
import greymerk.roguelike.worldgen.shapes.RectSolid;
import java.util.List;

public class DungeonLinkerTop
extends DungeonBase {
    public DungeonLinkerTop(RoomSetting roomSetting, LevelSettings levelSettings, WorldEditor worldEditor) {
        super(roomSetting, levelSettings, worldEditor);
    }

    @Override
    public DungeonBase generate(Coord origin, List<Direction> entrances) {
        Theme theme = this.levelSettings.getTheme();
        BlockBrush pillar = theme.getPrimary().getPillar();
        BlockBrush wall = theme.getPrimary().getWall();
        BlockBrush floor = theme.getPrimary().getFloor();
        StairsBlock stair = theme.getPrimary().getStair();
        Coord start = origin.copy();
        Coord end = origin.copy();
        start.translate(new Coord(-4, -1, -4));
        end.translate(new Coord(4, 5, 4));
        RectHollow.newRect(start, end).fill(this.worldEditor, wall, false, true);
        Coord cursor = origin.copy();
        cursor.up(5);
        this.levelSettings.getTheme().getPrimary().getLightBlock().stroke(this.worldEditor, cursor);
        start = origin.copy();
        end = origin.copy();
        start.translate(new Coord(-4, -1, -4));
        end.translate(new Coord(4, -1, 4));
        RectSolid.newRect(start, end).fill(this.worldEditor, floor);
        for (Direction dir : Direction.CARDINAL) {
            start = origin.copy();
            end = origin.copy();
            start.translate(dir, 3);
            start.translate(dir.antiClockwise(), 3);
            end.translate(dir, 4);
            end.translate(dir.antiClockwise(), 4);
            end.up(4);
            RectSolid.newRect(start, end).fill(this.worldEditor, pillar);
            start = origin.copy();
            start.translate(dir, 3);
            start.translate(dir.antiClockwise(), 2);
            start.up(4);
            end = start.copy();
            end.translate(dir.clockwise(), 4);
            RectSolid.newRect(start, end).fill(this.worldEditor, wall);
            start.translate(dir.reverse());
            end.translate(dir.reverse());
            RectSolid.newRect(start, end).fill(this.worldEditor, stair.setUpsideDown(true).setFacing(dir.reverse()));
            for (Direction o : dir.orthogonals()) {
                cursor = origin.copy();
                cursor.translate(dir, 3);
                cursor.up(2);
                cursor.translate(o, 2);
                stair.setUpsideDown(true).setFacing(o.reverse()).stroke(this.worldEditor, cursor);
                cursor.up();
                wall.stroke(this.worldEditor, cursor);
                cursor.translate(o.reverse());
                stair.setUpsideDown(true).setFacing(o.reverse()).stroke(this.worldEditor, cursor);
            }
        }
        this.generateDoorways(origin, entrances);
        return this;
    }

    @Override
    public int getSize() {
        return 6;
    }
}

