/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.rooms.prototype;

import com.github.fnar.minecraft.block.SingleBlockBrush;
import greymerk.roguelike.dungeon.Dungeon;
import greymerk.roguelike.dungeon.base.DungeonBase;
import greymerk.roguelike.dungeon.rooms.RoomSetting;
import greymerk.roguelike.dungeon.settings.LevelSettings;
import greymerk.roguelike.theme.Theme;
import greymerk.roguelike.treasure.loot.ChestType;
import greymerk.roguelike.worldgen.BlockBrush;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.Direction;
import greymerk.roguelike.worldgen.WorldEditor;
import greymerk.roguelike.worldgen.shapes.RectHollow;
import greymerk.roguelike.worldgen.shapes.RectSolid;
import greymerk.roguelike.worldgen.spawners.MobType;
import java.util.ArrayList;
import java.util.List;

public class DungeonPyramidSpawner
extends DungeonBase {
    public DungeonPyramidSpawner(RoomSetting roomSetting, LevelSettings levelSettings, WorldEditor worldEditor) {
        super(roomSetting, levelSettings, worldEditor);
    }

    @Override
    public DungeonBase generate(Coord origin, List<Direction> entrances) {
        int x = origin.getX();
        int y = origin.getY();
        int z = origin.getZ();
        Theme theme = this.levelSettings.getTheme();
        BlockBrush blocks = theme.getPrimary().getWall();
        BlockBrush pillar = theme.getPrimary().getPillar();
        RectSolid.newRect(new Coord(x - 3, y, z - 3), new Coord(x + 3, y + 3, z + 3)).fill(this.worldEditor, SingleBlockBrush.AIR);
        RectHollow.newRect(new Coord(x - 4, y - 1, z - 4), new Coord(x + 4, y + 4, z + 4)).fill(this.worldEditor, blocks, false, true);
        RectSolid.newRect(new Coord(x - 3, y + 4, z - 3), new Coord(x + 3, y + 6, z + 3)).fill(this.worldEditor, blocks, false, true);
        RectSolid.newRect(new Coord(x - 2, y + 4, z - 2), new Coord(x + 2, y + 4, z + 2)).fill(this.worldEditor, SingleBlockBrush.AIR);
        RectSolid.newRect(new Coord(x - 4, y - 1, z - 4), new Coord(x + 4, y - 1, z + 4)).fill(this.worldEditor, theme.getPrimary().getFloor(), false, true);
        Coord cursor = new Coord(x, y, z);
        cursor.up(5);
        SingleBlockBrush.AIR.stroke(this.worldEditor, cursor);
        cursor.up();
        blocks.stroke(this.worldEditor, cursor);
        cursor = new Coord(x, y, z);
        cursor.up(5);
        SingleBlockBrush.AIR.stroke(this.worldEditor, cursor);
        cursor.up();
        SingleBlockBrush.AIR.stroke(this.worldEditor, cursor);
        ArrayList<Coord> space = new ArrayList<Coord>();
        for (Direction dir : Direction.CARDINAL) {
            cursor = new Coord(x, y, z);
            cursor.translate(dir, 3);
            cursor.translate(dir.antiClockwise(), 3);
            Coord start = cursor.copy();
            cursor.up(3);
            Coord end = cursor.copy();
            RectSolid.newRect(start, end).fill(this.worldEditor, pillar);
            cursor.up();
            blocks.stroke(this.worldEditor, cursor);
            cursor = new Coord(x, y, z);
            cursor.up(4);
            cursor.translate(dir, 2);
            blocks.stroke(this.worldEditor, cursor);
            cursor.translate(dir.antiClockwise(), 2);
            blocks.stroke(this.worldEditor, cursor);
            cursor = new Coord(x, y, z);
            cursor.up(5);
            cursor.translate(dir.antiClockwise());
            SingleBlockBrush.AIR.stroke(this.worldEditor, cursor);
            cursor.up();
            SingleBlockBrush.AIR.stroke(this.worldEditor, cursor);
            for (Direction orthogonals : dir.orthogonals()) {
                cursor = new Coord(x, y, z);
                cursor.up(3);
                cursor.translate(orthogonals);
                cursor.translate(dir, 3);
                blocks.stroke(this.worldEditor, cursor);
                cursor = new Coord(x, y, z);
                cursor.up(4);
                cursor.translate(dir, 2);
                blocks.stroke(this.worldEditor, cursor);
                cursor = new Coord(x, y, z);
                cursor.translate(dir, 3);
                cursor.translate(orthogonals, 2);
                space.add(cursor);
            }
        }
        List<Coord> chestLocations = this.chooseRandomLocations(1, space);
        ChestType chestType = this.getRoomSetting().getChestType().orElse(ChestType.chooseRandomAmong(this.worldEditor.getRandom(cursor), ChestType.COMMON_TREASURES));
        this.worldEditor.getTreasureChestEditor().createChests(chestLocations, false, Dungeon.getLevel(origin.getY()), entrances.get(0).reverse(), chestType);
        Coord cursor1 = new Coord(x, y, z);
        this.generateSpawner(cursor1, MobType.COMMON_MOBS);
        return this;
    }

    @Override
    public int getSize() {
        return 4;
    }
}

