/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.rooms.prototype;

import com.github.fnar.minecraft.block.BlockType;
import com.github.fnar.minecraft.block.SingleBlockBrush;
import greymerk.roguelike.dungeon.Dungeon;
import greymerk.roguelike.dungeon.base.DungeonBase;
import greymerk.roguelike.dungeon.rooms.RoomSetting;
import greymerk.roguelike.dungeon.settings.LevelSettings;
import greymerk.roguelike.theme.Theme;
import greymerk.roguelike.treasure.loot.ChestType;
import greymerk.roguelike.worldgen.BlockBrush;
import greymerk.roguelike.worldgen.BlockWeightedRandom;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.Direction;
import greymerk.roguelike.worldgen.WorldEditor;
import greymerk.roguelike.worldgen.shapes.RectHollow;
import greymerk.roguelike.worldgen.shapes.RectSolid;
import greymerk.roguelike.worldgen.spawners.MobType;
import java.util.List;
import java.util.Random;

public class DungeonsNetherBrick
extends DungeonBase {
    public DungeonsNetherBrick(RoomSetting roomSetting, LevelSettings levelSettings, WorldEditor worldEditor) {
        super(roomSetting, levelSettings, worldEditor);
    }

    @Override
    public DungeonBase generate(Coord origin, List<Direction> entrances) {
        Random random = this.worldEditor.getRandom(origin);
        int x = origin.getX();
        int y = origin.getY();
        int z = origin.getZ();
        Theme theme = this.levelSettings.getTheme();
        int height = 3;
        int length = 2 + random.nextInt(3);
        int width = 2 + random.nextInt(3);
        BlockBrush walls = theme.getPrimary().getWall();
        RectHollow.newRect(new Coord(x - length - 1, y - 1, z - width - 1), new Coord(x + length + 1, y + height + 1, z + width + 1)).fill(this.worldEditor, walls, false, true);
        BlockBrush floor = theme.getPrimary().getFloor();
        RectSolid.newRect(new Coord(x - length - 1, y - 1, z - width - 1), new Coord(x + length + 1, y - 1, z + width + 1)).fill(this.worldEditor, floor);
        BlockWeightedRandom subFloor = new BlockWeightedRandom();
        subFloor.addBlock(theme.getPrimary().getLiquid(), 8);
        subFloor.addBlock(BlockType.OBSIDIAN.getBrush(), 3);
        RectSolid.newRect(new Coord(x - length, y - 5, z - width), new Coord(x + length, y - 2, z + width)).fill(this.worldEditor, subFloor);
        BlockWeightedRandom ceiling = new BlockWeightedRandom();
        ceiling.addBlock(BlockType.FENCE_NETHER_BRICK.getBrush(), 10);
        ceiling.addBlock(SingleBlockBrush.AIR, 5);
        RectSolid.newRect(new Coord(x - length, y + height, z - width), new Coord(x + length, y + height, z + width)).fill(this.worldEditor, ceiling);
        List<Coord> chestLocations = this.chooseRandomLocations(1, new RectSolid(new Coord(x - length, y, z - width), new Coord(x + length, y, z + width)).get());
        this.worldEditor.getTreasureChestEditor().createChests(chestLocations, false, Dungeon.getLevel(y), entrances.get(0), this.getRoomSetting().getChestType().orElse(ChestType.chooseRandomAmong(random, ChestType.COMMON_TREASURES)));
        Coord cursor = new Coord(x - length - 1, y + random.nextInt(2), z - width - 1);
        this.generateSpawner(cursor, MobType.COMMON_MOBS);
        Coord cursor1 = new Coord(x - length - 1, y + random.nextInt(2), z + width + 1);
        this.generateSpawner(cursor1, MobType.COMMON_MOBS);
        Coord cursor2 = new Coord(x + length + 1, y + random.nextInt(2), z - width - 1);
        this.generateSpawner(cursor2, MobType.COMMON_MOBS);
        Coord cursor3 = new Coord(x + length + 1, y + random.nextInt(2), z + width + 1);
        this.generateSpawner(cursor3, MobType.COMMON_MOBS);
        return this;
    }

    @Override
    public int getSize() {
        return 6;
    }
}

