/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.settings;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import greymerk.roguelike.dungeon.settings.DungeonSettingParseException;
import greymerk.roguelike.dungeon.towers.Tower;
import greymerk.roguelike.theme.Theme;
import greymerk.roguelike.theme.ThemeParser;
import greymerk.roguelike.theme.Themes;
import greymerk.roguelike.theme.builtin.ThemeTower;

public class TowerSettings {
    private Tower type;
    private Theme theme;

    public TowerSettings(Tower type, Themes theme) {
        this.type = type;
        this.theme = theme.getThemeBase();
    }

    public TowerSettings(JsonElement e) throws Exception {
        JsonObject data = e.getAsJsonObject();
        this.type = data.has("type") ? Tower.get(data.get("type").getAsString()) : null;
        try {
            this.theme = data.has("theme") ? ThemeParser.parse(data.get("theme").getAsJsonObject()) : null;
        }
        catch (DungeonSettingParseException exception) {
            throw new DungeonSettingParseException("While parsing tower: " + exception.getMessage());
        }
    }

    public TowerSettings(TowerSettings base, TowerSettings override) {
        if (base == null) {
            this.type = override.type;
            this.theme = override.theme;
            return;
        }
        if (override == null) {
            this.type = base.type;
            this.theme = base.theme;
            return;
        }
        this.type = override.type == null ? base.type : override.type;
        this.theme = override.theme == null ? base.theme : override.theme;
    }

    public TowerSettings(TowerSettings toCopy) {
        this.type = toCopy.type;
        this.theme = toCopy.theme;
    }

    public Tower getType() {
        if (this.type == null) {
            return Tower.ROGUE;
        }
        return this.type;
    }

    public Theme getTheme() {
        if (this.theme == null) {
            return new ThemeTower();
        }
        return this.theme;
    }
}

