/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.settings.base;

import com.google.common.collect.Lists;
import greymerk.roguelike.dungeon.base.RoomType;
import greymerk.roguelike.dungeon.base.RoomsSetting;
import greymerk.roguelike.dungeon.rooms.RoomSetting;
import greymerk.roguelike.dungeon.settings.DungeonSettings;
import greymerk.roguelike.dungeon.settings.LevelSettings;
import greymerk.roguelike.dungeon.settings.SettingIdentifier;
import java.util.ArrayList;
import java.util.List;

public class SettingsRooms
extends DungeonSettings {
    public static final SettingIdentifier ID = new SettingIdentifier("builtin", "rooms");

    public SettingsRooms() {
        super(ID);
        this.addRoomsToLevel(0, this.getLevel0Rooms());
        this.addRoomsToLevel(1, this.getLevel1Rooms());
        this.addRoomsToLevel(2, this.getLevel2Rooms());
        this.addRoomsToLevel(3, this.getLevel3Rooms());
        this.addRoomsToLevel(4, this.getLevel4Rooms());
    }

    private void addRoomsToLevel(int i, List<RoomSetting> rooms) {
        RoomsSetting roomSetting = new RoomsSetting();
        rooms.forEach(roomSetting::add);
        LevelSettings level = new LevelSettings();
        level.setRooms(roomSetting);
        this.getLevelSettings().put(i, level);
    }

    private List<RoomSetting> getLevel0Rooms() {
        return Lists.newArrayList((Object[])new RoomSetting[]{RoomType.CAKE.newSingleRoomSetting(), RoomType.FIRE.newSingleRoomSetting(), RoomType.REWARD.newSingleRoomSetting(), RoomType.BRICK.newRandomRoomSetting(2), RoomType.CORNER.newRandomRoomSetting(2)});
    }

    private List<RoomSetting> getLevel1Rooms() {
        return Lists.newArrayList((Object[])new RoomSetting[]{RoomType.PIT.newSingleRoomSetting(), RoomType.REWARD.newSingleRoomSetting(), RoomType.BRICK.newRandomRoomSetting(3), RoomType.CORNER.newRandomRoomSetting(10)});
    }

    private List<RoomSetting> getLevel2Rooms() {
        return Lists.newArrayList((Object[])new RoomSetting[]{RoomType.OSSUARY.newSingleRoomSetting(), RoomType.CRYPT.newSingleRoomSetting(), RoomType.CREEPER.newSingleRoomSetting(), RoomType.FIRE.newSingleRoomSetting(), RoomType.SPIDER.newSingleRoomSetting(), RoomType.PRISON.newSingleRoomSetting(), RoomType.REWARD.newSingleRoomSetting(), RoomType.CRYPT.newRandomRoomSetting(5), RoomType.CORNER.newRandomRoomSetting(5), RoomType.BRICK.newRandomRoomSetting(3)});
    }

    private List<RoomSetting> getLevel3Rooms() {
        return Lists.newArrayList((Object[])new RoomSetting[]{RoomType.OSSUARY.newSingleRoomSetting(), RoomType.CRYPT.newSingleRoomSetting(), RoomType.REWARD.newSingleRoomSetting(), RoomType.SLIME.newRandomRoomSetting(5), RoomType.PRISON.newRandomRoomSetting(3), RoomType.PLATFORMS.newRandomRoomSetting(2), RoomType.CREEPER.newRandomRoomSetting(1), RoomType.SPIDER.newRandomRoomSetting(1), RoomType.PIT.newRandomRoomSetting(1), RoomType.ENDER.newRandomRoomSetting(1)});
    }

    private List<RoomSetting> getLevel4Rooms() {
        ArrayList rooms = Lists.newArrayList((Object[])new RoomSetting[]{RoomType.REWARD.newSingleRoomSetting(), RoomType.OBSIDIAN.newSingleRoomSetting(), RoomType.DARKHALL.newSingleRoomSetting(), RoomType.NETHERFORT.newSingleRoomSetting(), RoomType.BRICK.newRandomRoomSetting(2), RoomType.CORNER.newRandomRoomSetting(2), RoomType.PLATFORMS.newRandomRoomSetting(2), RoomType.SLIME.newRandomRoomSetting(2), RoomType.NETHER.newRandomRoomSetting(2), RoomType.BLAZE.newRandomRoomSetting(1), RoomType.OBSIDIAN.newRandomRoomSetting(1), RoomType.NETHER_PORTAL.newRandomRoomSetting(1)});
        RoomType[] flavours = new RoomType[]{RoomType.BLAZE, RoomType.BRICK, RoomType.CRYPT, RoomType.NETHER, RoomType.PRISON, RoomType.SLIME};
        RoomType chosenFlavour = flavours[(int)(Math.random() * (double)flavours.length)];
        rooms.add(chosenFlavour.newRandomRoomSetting(10));
        return rooms;
    }
}

