/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.settings.builtin;

import com.google.common.collect.Lists;
import greymerk.roguelike.dungeon.segment.Segment;
import greymerk.roguelike.dungeon.segment.SegmentGenerator;
import greymerk.roguelike.dungeon.settings.DungeonSettings;
import greymerk.roguelike.dungeon.settings.LevelSettings;
import greymerk.roguelike.dungeon.settings.SettingIdentifier;
import greymerk.roguelike.dungeon.settings.TowerSettings;
import greymerk.roguelike.dungeon.settings.base.SettingsBase;
import greymerk.roguelike.dungeon.towers.Tower;
import greymerk.roguelike.theme.Themes;
import greymerk.roguelike.treasure.loot.WeightedRandomLoot;
import greymerk.roguelike.treasure.loot.rule.SingleUseLootRule;
import greymerk.roguelike.worldgen.filter.Filter;
import net.minecraft.init.Items;
import net.minecraftforge.common.BiomeDictionary;

public class SettingsJungleTheme
extends DungeonSettings {
    public static final SettingIdentifier ID = new SettingIdentifier("builtin", "jungle");

    public SettingsJungleTheme() {
        super(ID);
        this.setExclusive(true);
        this.getInherit().add(SettingsBase.ID);
        this.getCriteria().setBiomeTypes(Lists.newArrayList((Object[])new BiomeDictionary.Type[]{BiomeDictionary.Type.JUNGLE}));
        this.setTowerSettings(new TowerSettings(Tower.JUNGLE, Themes.JUNGLE));
        for (int i = 0; i < 5; ++i) {
            this.getLootRules().add(new SingleUseLootRule(new WeightedRandomLoot(Items.field_151166_bC, 0, 1, 1 + i, 1), i, 6));
            this.getLootRules().add(new SingleUseLootRule(new WeightedRandomLoot(Items.field_151045_i, 1), i, 3 + i * 3));
        }
        Themes[] themes = new Themes[]{Themes.JUNGLE, Themes.JUNGLE, Themes.MOSSY, Themes.MOSSY, Themes.NETHER};
        for (int i = 0; i < 5; ++i) {
            LevelSettings level = new LevelSettings();
            if (i < 4) {
                level.setDifficulty(3);
                SegmentGenerator segments = new SegmentGenerator(Segment.MOSSYARCH);
                segments.add(Segment.SHELF, 2);
                segments.add(Segment.INSET, 2);
                segments.add(Segment.JUNGLE, 5);
                segments.add(Segment.SKULL, 1);
                segments.add(Segment.ARROW, 1);
                segments.add(Segment.CELL, 1);
                segments.add(Segment.SILVERFISH, 1);
                segments.add(Segment.CHEST, 1);
                segments.add(Segment.SPAWNER, 2);
                level.setSegments(segments);
                level.addFilter(Filter.VINE);
            }
            level.setTheme(themes[i].getThemeBase());
            this.getLevelSettings().put(i, level);
        }
    }
}

