/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.towers;

import com.github.fnar.minecraft.block.SingleBlockBrush;
import com.github.fnar.minecraft.block.normal.StairsBlock;
import greymerk.roguelike.dungeon.towers.ITower;
import greymerk.roguelike.dungeon.towers.Tower;
import greymerk.roguelike.theme.Theme;
import greymerk.roguelike.worldgen.BlockBrush;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.Direction;
import greymerk.roguelike.worldgen.WorldEditor;
import greymerk.roguelike.worldgen.shapes.RectHollow;
import greymerk.roguelike.worldgen.shapes.RectSolid;
import java.util.Random;

public class EthoTower
implements ITower {
    /*
     * WARNING - void declaration
     */
    @Override
    public void generate(WorldEditor editor, Random rand, Theme theme, Coord dungeon) {
        void var15_19;
        Coord cursor;
        BlockBrush primary = theme.getPrimary().getWall();
        BlockBrush pillar = theme.getSecondary().getPillar();
        StairsBlock stair = theme.getSecondary().getStair();
        Coord floor = Tower.getBaseCoord(editor, dungeon);
        Coord start = floor.copy();
        Coord end = start.copy();
        int x = dungeon.getX();
        int z = dungeon.getZ();
        start.north(3);
        start.west(3);
        end.south(3);
        end.east(3);
        end.up(4);
        start.north();
        start.west();
        start.down();
        end.south();
        end.east();
        end.up();
        RectHollow.newRect(start, end).fill(editor, primary);
        for (Direction direction : Direction.CARDINAL) {
            Direction[] orthogonals = direction.orthogonals();
            start = floor.copy();
            start.translate(direction, 3);
            start.translate(orthogonals[0], 3);
            end = start.copy();
            end.up(6);
            RectSolid.newRect(start, end).fill(editor, pillar);
            for (Direction o : orthogonals) {
                start = floor.copy();
                start.translate(direction, 5);
                start.translate(o, 4);
                end = start.copy();
                end.up(4);
                start.down(10);
                RectSolid.newRect(start, end).fill(editor, pillar);
                end.up();
                stair.setUpsideDown(false).setFacing(direction).stroke(editor, end);
                end.translate(direction.reverse());
                end.translate(o.reverse());
                stair.setUpsideDown(false).setFacing(o.reverse()).stroke(editor, end);
                end.translate(o.reverse());
                start = end.copy();
                start.translate(o.reverse(), 2);
                RectSolid.newRect(start, end).fill(editor, stair.setUpsideDown(false).setFacing(direction));
                end.translate(direction.reverse());
                end.up();
                start.translate(direction.reverse());
                start.up();
                RectSolid.newRect(start, end).fill(editor, stair.setUpsideDown(false).setFacing(direction));
                stair.setUpsideDown(false).setFacing(o.reverse()).stroke(editor, end);
                start = floor.copy();
                start.translate(direction, 3);
                start.up(4);
                end = start.copy();
                end.translate(o, 2);
                RectSolid.newRect(start, end).fill(editor, stair.setUpsideDown(true).setFacing(direction.reverse()));
                start.translate(direction.reverse());
                start.up();
                end = start.copy();
                end.translate(o, 2);
                RectSolid.newRect(start, end).fill(editor, stair.setUpsideDown(true).setFacing(direction.reverse()));
                start.up();
                end.up();
                RectSolid.newRect(start, end).fill(editor, pillar);
                cursor = end.copy();
                start = end.copy();
                start.up(3);
                RectSolid.newRect(start, end).fill(editor, pillar);
                cursor.translate(o.reverse());
                cursor.up();
                stair.setUpsideDown(false).setFacing(o.reverse()).stroke(editor, cursor);
                cursor.up(2);
                stair.setUpsideDown(true).setFacing(o.reverse()).stroke(editor, cursor);
                start.up();
                end = start.copy();
                end.translate(o.reverse(), 2);
                RectSolid.newRect(start, end).fill(editor, stair.setUpsideDown(false).setFacing(direction));
                cursor = end.copy();
                cursor.translate(direction.reverse());
                stair.setUpsideDown(true).setFacing(direction.reverse()).stroke(editor, cursor);
                cursor.translate(o);
                stair.setUpsideDown(true).setFacing(direction.reverse()).stroke(editor, cursor);
                cursor.up();
                stair.setUpsideDown(false).setFacing(direction).stroke(editor, cursor);
                cursor.translate(o.reverse());
                stair.setUpsideDown(false).setFacing(direction).stroke(editor, cursor);
            }
        }
        Direction front = Direction.NORTH;
        for (Direction dir : Direction.CARDINAL) {
            cursor = floor.copy();
            cursor.translate(dir, 6);
            if (!editor.isAirBlock(cursor)) continue;
            front = dir;
            break;
        }
        for (Direction dir : Direction.CARDINAL) {
            if (dir == front) {
                for (Direction o : dir.orthogonals()) {
                    cursor = floor.copy();
                    cursor.translate(dir, 5);
                    cursor.translate(o, 2);
                    primary.stroke(editor, cursor);
                    cursor.translate(o);
                    stair.setUpsideDown(false).setFacing(o).stroke(editor, cursor);
                    cursor.translate(dir);
                    stair.setUpsideDown(false).setFacing(o).stroke(editor, cursor);
                    cursor.translate(o.reverse());
                    stair.setUpsideDown(false).setFacing(dir).stroke(editor, cursor);
                    cursor.translate(dir.reverse());
                    cursor.up();
                    stair.setUpsideDown(false).setFacing(o.reverse()).stroke(editor, cursor);
                    cursor.up();
                    stair.setUpsideDown(false).setFacing(dir).stroke(editor, cursor);
                    cursor.translate(o);
                    stair.setUpsideDown(false).setFacing(o).stroke(editor, cursor);
                    cursor.translate(o.reverse());
                    cursor.up();
                    stair.setUpsideDown(false).setFacing(o.reverse()).stroke(editor, cursor);
                    cursor.translate(o.reverse());
                    stair.setUpsideDown(true).setFacing(o.reverse()).stroke(editor, cursor);
                    cursor.translate(o.reverse());
                    cursor.up();
                    stair.setUpsideDown(false).setFacing(dir).stroke(editor, cursor);
                    cursor.translate(o);
                    stair.setUpsideDown(false).setFacing(dir).stroke(editor, cursor);
                    cursor.translate(o);
                    stair.setUpsideDown(false).setFacing(o).stroke(editor, cursor);
                }
                Direction[] orthogonals = dir.orthogonals();
                cursor = floor.copy();
                cursor.translate(dir, 4);
                start = cursor.copy();
                end = start.copy();
                start.translate(orthogonals[0]);
                end.up(2);
                end.translate(orthogonals[1]);
                RectSolid.newRect(start, end).fill(editor, SingleBlockBrush.AIR);
                cursor = floor.copy();
                cursor.translate(dir, 6);
                cursor.down();
                this.step(editor, theme, dir, cursor);
                continue;
            }
            for (Direction o : dir.orthogonals()) {
                start = floor.copy();
                start.up(4);
                start.translate(dir, 5);
                end = start.copy();
                start.translate(o, 2);
                RectSolid.newRect(start, end).fill(editor, stair.setUpsideDown(false).setFacing(dir));
                start.translate(o);
                stair.setUpsideDown(false).setFacing(o.reverse()).stroke(editor, start);
                start.down();
                stair.setUpsideDown(true).setFacing(o.reverse()).stroke(editor, start);
            }
        }
        int n = floor.getY() - 1;
        while (var15_19 >= 50) {
            editor.spiralStairStep(rand, new Coord(x, (int)var15_19, z), stair, theme.getPrimary().getPillar());
            --var15_19;
        }
    }

    private void step(WorldEditor editor, Theme theme, Direction dir, Coord origin) {
        if (editor.isOpaqueCubeBlock(origin)) {
            return;
        }
        StairsBlock stair = theme.getPrimary().getStair();
        BlockBrush blocks = theme.getPrimary().getWall();
        Direction[] orthogonals = dir.orthogonals();
        Coord start = origin.copy();
        Coord end = origin.copy();
        start.translate(orthogonals[0]);
        end.translate(orthogonals[1]);
        end = new Coord(end.getX(), 60, end.getZ());
        RectSolid.newRect(start, end).fill(editor, blocks);
        start = origin.copy();
        end = origin.copy();
        start.translate(orthogonals[0]);
        end.translate(orthogonals[1]);
        stair.setUpsideDown(false).setFacing(dir);
        RectSolid.newRect(start, end).fill(editor, stair);
        origin.down();
        origin.translate(dir);
        this.step(editor, theme, dir, origin);
    }
}

