/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.monster.profiles;

import com.github.fnar.minecraft.item.Arrow;
import com.github.fnar.minecraft.item.ItemMapper1_12;
import com.github.fnar.util.Colors;
import greymerk.roguelike.monster.IEntity;
import greymerk.roguelike.monster.IMonsterProfile;
import greymerk.roguelike.monster.MobType;
import greymerk.roguelike.treasure.loot.Enchant;
import greymerk.roguelike.treasure.loot.Quality;
import greymerk.roguelike.treasure.loot.Slot;
import greymerk.roguelike.treasure.loot.provider.ItemArmour;
import greymerk.roguelike.treasure.loot.provider.ItemWeapon;
import java.util.Random;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class ProfileMagicArcher
implements IMonsterProfile {
    @Override
    public void addEquipment(World world, Random random, int level, IEntity mob) {
        Slot[] slotsToBeArmored;
        mob.setMobClass(MobType.STRAY, false);
        mob.setSlot(EntityEquipmentSlot.OFFHAND, ItemMapper1_12.map(Arrow.newRandomHarmful(random).asItemStack()));
        mob.setSlot(EntityEquipmentSlot.MAINHAND, ItemWeapon.getBow(random, level, Enchant.canEnchant(world.func_175659_aa(), random, level)));
        for (Slot slot : slotsToBeArmored = new Slot[]{Slot.HEAD, Slot.CHEST, Slot.LEGS, Slot.FEET}) {
            ItemStack item = ItemArmour.get(slot, Quality.WOOD, Colors.DEEP_VIOLET);
            Enchant.enchantItem(random, item, 20);
            mob.setSlot(Slot.getSlot(slot), item);
        }
    }
}

