/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.theme;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import greymerk.roguelike.dungeon.settings.DungeonSettingParseException;
import greymerk.roguelike.theme.BlockSet;
import greymerk.roguelike.theme.BlockSetParser;
import greymerk.roguelike.theme.Theme;
import greymerk.roguelike.theme.Themes;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Function;

public class ThemeParser {
    public static final String THEME_BASE_KEY = "base";
    public static final String PRIMARY_KEY = "primary";
    public static final String SECONDARY_KEY = "secondary";

    public static Theme parse(JsonObject json) throws DungeonSettingParseException {
        Theme theme = ThemeParser.parseThemeBase(json);
        BlockSet primaryBlockSet = Optional.ofNullable(ThemeParser.parsePrimaryBlockSet(json, theme)).orElse(Optional.ofNullable(theme).map(Theme::getPrimary).orElse(null));
        BlockSet secondaryBlockSet = Optional.ofNullable(ThemeParser.parseSecondaryBlockSet(json, theme)).orElse(Optional.ofNullable(theme).map(Theme::getSecondary).orElse(null));
        return new Theme(primaryBlockSet, secondaryBlockSet);
    }

    private static Theme parseThemeBase(JsonObject json) {
        if (!json.has(THEME_BASE_KEY)) {
            return Themes.OAK.getThemeBase();
        }
        JsonElement baseElement = json.get(THEME_BASE_KEY);
        if (baseElement.isJsonNull()) {
            return Themes.OAK.getThemeBase();
        }
        String baseString = baseElement.getAsString();
        if (baseString.isEmpty()) {
            return Themes.OAK.getThemeBase();
        }
        return ThemeParser.get(baseString).getThemeBase();
    }

    private static BlockSet parsePrimaryBlockSet(JsonObject json, Theme base) throws DungeonSettingParseException {
        return ThemeParser.parseBlockSet(json, base, PRIMARY_KEY, Theme::getPrimary);
    }

    private static BlockSet parseSecondaryBlockSet(JsonObject json, Theme base) throws DungeonSettingParseException {
        return ThemeParser.parseBlockSet(json, base, SECONDARY_KEY, Theme::getSecondary);
    }

    private static BlockSet parseBlockSet(JsonObject json, Theme baseTheme, String key, Function<Theme, BlockSet> getBlockSetFunction) throws DungeonSettingParseException {
        if (!json.has(key)) {
            return null;
        }
        JsonObject data = json.get(key).getAsJsonObject();
        BlockSet baseBlockSet = Optional.ofNullable(baseTheme).map(getBlockSetFunction).orElse(ThemeParser.getEmptyBlockSet());
        return BlockSetParser.parseBlockSet(data, baseBlockSet);
    }

    private static BlockSet getEmptyBlockSet() {
        return new BlockSet(null, null, null, null, null, null, null);
    }

    public static Themes get(String name) throws DungeonSettingParseException {
        if (!ThemeParser.contains(name.toUpperCase())) {
            throw new DungeonSettingParseException("No such theme: " + name);
        }
        return Themes.valueOf(name.toUpperCase());
    }

    public static boolean contains(String name) {
        return Arrays.stream(Themes.values()).anyMatch(value -> value.toString().equals(name));
    }
}

