/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.treasure.loot.provider;

import com.github.fnar.util.Color;
import com.google.gson.JsonObject;
import greymerk.roguelike.treasure.loot.Enchant;
import greymerk.roguelike.treasure.loot.Equipment;
import greymerk.roguelike.treasure.loot.Loot;
import greymerk.roguelike.treasure.loot.Quality;
import greymerk.roguelike.treasure.loot.provider.ItemArmour;
import greymerk.roguelike.treasure.loot.provider.ItemBase;
import greymerk.roguelike.util.TextFormat;
import java.util.Random;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ItemSpecialty
extends ItemBase {
    private Equipment type;
    private Quality quality;

    public ItemSpecialty(int weight, int level) {
        super(weight, level);
    }

    public ItemSpecialty(JsonObject data, int weight) throws Exception {
        super(weight);
        if (!data.has("level")) {
            throw new Exception("Item requires a level");
        }
        this.level = data.get("level").getAsInt();
        if (data.has("quality")) {
            try {
                this.quality = Quality.valueOf(data.get("quality").getAsString().toUpperCase());
            }
            catch (Exception e) {
                throw new Exception("No such Quality as: " + data.get("quality").getAsString());
            }
        }
        if (data.has("equipment")) {
            try {
                this.type = Equipment.valueOf(data.get("equipment").getAsString().toUpperCase());
            }
            catch (Exception e) {
                throw new Exception("No such Equipment as: " + data.get("equipment").getAsString());
            }
        }
    }

    public ItemSpecialty(int weight, int level, Equipment type, Quality q) {
        super(weight, level);
        this.type = type;
        this.quality = q;
    }

    public ItemSpecialty(int weight, int level, Quality q) {
        super(weight, level);
        this.quality = q;
    }

    public static ItemStack getRandomItem(Random rand, int level) {
        return ItemSpecialty.getRandomItem(Equipment.values()[rand.nextInt(Equipment.values().length)], rand, level);
    }

    public static ItemStack getRandomItem(Equipment type, Random rand, int level) {
        return ItemSpecialty.getRandomItem(type, rand, Quality.get(rand, level, type));
    }

    public static ItemStack getRandomItem(Equipment type, Random random, Quality quality) {
        switch (type) {
            case SWORD: {
                return ItemSpecialty.getSword(random, quality);
            }
            case BOW: {
                return ItemSpecialty.getBow(random, quality);
            }
            case HELMET: {
                return ItemSpecialty.getHelmet(random, quality);
            }
            case CHEST: {
                return ItemSpecialty.getChest(random, quality);
            }
            case LEGS: {
                return ItemSpecialty.getLegs(random, quality);
            }
            case FEET: {
                return ItemSpecialty.getBoots(random, quality);
            }
            case PICK: {
                return ItemSpecialty.getPick(random, quality);
            }
            case AXE: {
                return ItemSpecialty.getAxe(random, quality);
            }
            case SHOVEL: {
                return ItemSpecialty.getShovel(random, quality);
            }
        }
        return null;
    }

    public static ItemStack getRandomArmour(Random rand, Quality quality) {
        switch (rand.nextInt(4)) {
            case 0: {
                return ItemSpecialty.getRandomItem(Equipment.HELMET, rand, quality);
            }
            case 1: {
                return ItemSpecialty.getRandomItem(Equipment.CHEST, rand, quality);
            }
            case 2: {
                return ItemSpecialty.getRandomItem(Equipment.LEGS, rand, quality);
            }
            case 3: {
                return ItemSpecialty.getRandomItem(Equipment.FEET, rand, quality);
            }
        }
        return null;
    }

    public static ItemStack getRandomTool(Random rand, Quality quality) {
        switch (rand.nextInt(3)) {
            case 0: {
                return ItemSpecialty.getRandomItem(Equipment.PICK, rand, quality);
            }
            case 1: {
                return ItemSpecialty.getRandomItem(Equipment.AXE, rand, quality);
            }
            case 2: {
                return ItemSpecialty.getRandomItem(Equipment.SHOVEL, rand, quality);
            }
        }
        return null;
    }

    private static ItemStack getShovel(Random random, Quality quality) {
        String name = quality.getDescriptor() + " Spade";
        switch (quality) {
            case DIAMOND: {
                return ItemSpecialty.enchantAndRenameTool(Items.field_151047_v, name, random);
            }
            case GOLD: {
                return ItemSpecialty.enchantAndRenameTool(Items.field_151011_C, name, random);
            }
            case IRON: {
                return ItemSpecialty.enchantAndRenameTool(Items.field_151037_a, "Grave Spade", random);
            }
            case STONE: {
                return ItemSpecialty.enchantAndRenameTool(Items.field_151051_r, name, random);
            }
        }
        return ItemSpecialty.enchantAndRenameTool(Items.field_151038_n, name, random);
    }

    private static ItemStack getAxe(Random random, Quality quality) {
        String name = quality.getDescriptor() + " Axe";
        switch (quality) {
            case DIAMOND: {
                return ItemSpecialty.enchantAndRenameTool(Items.field_151056_x, name, random);
            }
            case GOLD: {
                return ItemSpecialty.enchantAndRenameTool(Items.field_151006_E, name, random);
            }
            case IRON: {
                return ItemSpecialty.enchantAndRenameTool(Items.field_151036_c, "Woodland Hatchet", random);
            }
            case STONE: {
                return ItemSpecialty.enchantAndRenameTool(Items.field_151049_t, name, random);
            }
        }
        return ItemSpecialty.enchantAndRenameTool(Items.field_151053_p, name, random);
    }

    private static ItemStack getPick(Random random, Quality quality) {
        String name = quality.getDescriptor() + " Pick";
        switch (quality) {
            case DIAMOND: {
                return ItemSpecialty.enchantAndRenameTool(Items.field_151046_w, name, random);
            }
            case GOLD: {
                return ItemSpecialty.enchantAndRenameTool(Items.field_151005_D, name, random);
            }
            case IRON: {
                return ItemSpecialty.enchantAndRenameTool(Items.field_151035_b, name, random);
            }
            case STONE: {
                return ItemSpecialty.enchantAndRenameTool(Items.field_151050_s, name, random);
            }
        }
        return ItemSpecialty.enchantAndRenameTool(Items.field_151039_o, name, random);
    }

    private static ItemStack enchantAndRenameTool(Item tool, String name, Random random) {
        ItemStack itemStack = new ItemStack(tool);
        name = ItemSpecialty.rollToolEnchantments(itemStack, name, random);
        name = ItemSpecialty.rollGeneralEnchantments(itemStack, name, random);
        itemStack.func_151001_c(name);
        return itemStack;
    }

    private static String rollToolEnchantments(ItemStack itemStack, String name, Random random) {
        name = ItemSpecialty.rollEfficiency(itemStack, name, random);
        name = ItemSpecialty.rollSilkTouch(itemStack, name, random);
        name = ItemSpecialty.rollFortune(itemStack, name, random);
        return name;
    }

    private static String rollEfficiency(ItemStack itemStack, String name, Random random) {
        int enchantmentLevel = random.nextInt(4);
        if (enchantmentLevel <= 0) {
            return name;
        }
        itemStack.func_77966_a(Enchant.getEnchant(Enchant.EFFICIENCY), enchantmentLevel);
        return enchantmentLevel >= 3 ? "Masterwork " + name : name;
    }

    private static String rollFortune(ItemStack item, String name, Random random) {
        if (random.nextInt(10) != 0) {
            return name;
        }
        int enchantmentLevel = random.nextInt(4);
        if (enchantmentLevel <= 0) {
            return name;
        }
        item.func_77966_a(Enchant.getEnchant(Enchant.FORTUNE), enchantmentLevel);
        return name + " of Prospecting";
    }

    private static String rollSilkTouch(ItemStack item, String name, Random random) {
        if (random.nextInt(10) != 0) {
            return name;
        }
        item.func_77966_a(Enchant.getEnchant(Enchant.SILKTOUCH), 1);
        name = "Precision " + name;
        return name;
    }

    private static String rollUnbreaking(ItemStack itemStack, String name, Random random) {
        int enchantmentLevel = random.nextInt(4);
        if (enchantmentLevel <= 0) {
            return name;
        }
        itemStack.func_77966_a(Enchant.getEnchant(Enchant.UNBREAKING), enchantmentLevel);
        return enchantmentLevel >= 3 ? "Reinforced " + name : name;
    }

    private static String rollGeneralEnchantments(ItemStack itemStack, String name, Random random) {
        name = ItemSpecialty.rollUnbreaking(itemStack, name, random);
        name = ItemSpecialty.rollMending(itemStack, name, random);
        return name;
    }

    private static String rollMending(ItemStack item, String name, Random random) {
        if (random.nextInt(10) != 0) {
            return name;
        }
        item.func_77966_a(Enchant.getEnchant(Enchant.MENDING), 1);
        return "Prideful " + name;
    }

    private static ItemStack getSword(Random random, Quality quality) {
        String name = quality.getDescriptor() + " Blade";
        switch (quality) {
            default: {
                return ItemSpecialty.enchantAndRenameSword(Items.field_151041_m, name, random);
            }
            case STONE: {
                return ItemSpecialty.enchantAndRenameSword(Items.field_151052_q, name, random);
            }
            case IRON: {
                return ItemSpecialty.enchantAndRenameSword(Items.field_151040_l, name, random);
            }
            case GOLD: {
                return ItemSpecialty.enchantAndRenameSword(Items.field_151010_B, name, random);
            }
            case DIAMOND: 
        }
        return ItemSpecialty.enchantAndRenameSword(Items.field_151048_u, name, random);
    }

    private static ItemStack enchantAndRenameSword(Item sword, String name, Random random) {
        ItemStack itemStack = new ItemStack(sword);
        name = ItemSpecialty.rollSwordEnchantments(itemStack, name, random);
        name = ItemSpecialty.rollGeneralEnchantments(itemStack, name, random);
        itemStack.func_151001_c(name);
        return itemStack;
    }

    private static String rollSwordEnchantments(ItemStack item, String name, Random random) {
        name = ItemSpecialty.rollSharpness(item, name, random);
        name = ItemSpecialty.rollLooting(item, name, random);
        name = ItemSpecialty.rollFiery(item, name, random);
        return name;
    }

    private static String rollSharpness(ItemStack item, String name, Random random) {
        if (random.nextBoolean()) {
            return name;
        }
        int enchantmentLevel = random.nextInt(6);
        if (enchantmentLevel <= 0) {
            return name;
        }
        item.func_77966_a(Enchant.getEnchant(Enchant.SHARPNESS), enchantmentLevel);
        return name;
    }

    private static String rollLooting(ItemStack item, String name, Random random) {
        if (random.nextBoolean()) {
            return name;
        }
        int enchantmentLevel = random.nextInt(4);
        if (enchantmentLevel <= 0) {
            return name;
        }
        item.func_77966_a(Enchant.getEnchant(Enchant.LOOTING), enchantmentLevel);
        if (enchantmentLevel < 3) {
            return "Burglar's " + name;
        }
        Loot.setItemLore(item, "Once belonged to a king of hidden desert thieves.", TextFormat.DARKGREEN);
        return "Bandit King's " + name;
    }

    private static String rollFiery(ItemStack item, String name, Random random) {
        if (random.nextBoolean()) {
            return name;
        }
        int enchantmentLevel = random.nextInt(4);
        if (enchantmentLevel <= 0) {
            return name;
        }
        item.func_77966_a(Enchant.getEnchant(Enchant.FIREASPECT), enchantmentLevel);
        if (enchantmentLevel == 1) {
            Loot.setItemLore(item, "Warm to the touch", TextFormat.YELLOW);
            return "Ember " + name;
        }
        if (enchantmentLevel == 2) {
            Loot.setItemLore(item, "Almost too hot to hold", TextFormat.RED);
            return "Fiery " + name;
        }
        if (enchantmentLevel == 3) {
            Loot.setItemLore(item, "From the fiery depths", TextFormat.DARKRED);
            return name + " of the Inferno";
        }
        return name;
    }

    private static ItemStack getBow(Random random, Quality quality) {
        ItemStack item = new ItemStack((Item)Items.field_151031_f);
        ItemSpecialty.rollPower(random, item);
        switch (quality) {
            case STONE: 
            case WOOD: {
                String name = "Yew Longbow";
                name = ItemSpecialty.rollUnbreaking(item, name, random);
                Loot.setItemLore(item, "Superior craftsmanship", TextFormat.DARKGREEN);
                item.func_151001_c(name);
                return item;
            }
            default: {
                String name = "Laminated Bow";
                name = ItemSpecialty.rollUnbreaking(item, name, random);
                item.func_151001_c(name);
                Loot.setItemLore(item, "Highly polished", TextFormat.DARKGREEN);
                return item;
            }
            case GOLD: {
                if (random.nextBoolean()) {
                    item.func_77966_a(Enchant.getEnchant(Enchant.INFINITY), 1);
                    String name = "Elven Bow";
                    name = ItemSpecialty.rollUnbreaking(item, name, random);
                    item.func_151001_c(name);
                    Loot.setItemLore(item, "Beautifully crafted", TextFormat.DARKGREEN);
                    return item;
                }
                if (random.nextBoolean()) {
                    item.func_77966_a(Enchant.getEnchant(Enchant.MENDING), 1);
                    String name = "Faerie Bow";
                    name = ItemSpecialty.rollUnbreaking(item, name, random);
                    item.func_151001_c(name);
                    Loot.setItemLore(item, "Beautifully crafted", TextFormat.DARKGREEN);
                    return item;
                }
                String name = "Recurve Bow";
                name = ItemSpecialty.rollUnbreaking(item, name, random);
                item.func_151001_c(name);
                Loot.setItemLore(item, "Curves outward toward the target", TextFormat.DARKGREEN);
                return item;
            }
            case DIAMOND: 
        }
        item.func_77966_a(Enchant.getEnchant(Enchant.FLAME), 1);
        String name = "Eldritch Bow";
        name = ItemSpecialty.rollUnbreaking(item, name, random);
        item.func_151001_c(name);
        Loot.setItemLore(item, "Warm to the touch", TextFormat.DARKGREEN);
        return item;
    }

    private static void rollPower(Random random, ItemStack item) {
        int enchantmentLevel = random.nextInt(4);
        if (enchantmentLevel <= 0) {
            return;
        }
        item.func_77966_a(Enchant.getEnchant(Enchant.POWER), enchantmentLevel);
    }

    private static ItemStack getHelmet(Random random, Quality quality) {
        ItemStack item;
        String canonical = "";
        switch (quality) {
            case WOOD: {
                item = new ItemStack((Item)Items.field_151024_Q);
                ItemArmour.dyeArmor(item, Color.random(random));
                canonical = "Skullcap";
                break;
            }
            case STONE: {
                item = new ItemStack((Item)Items.field_151020_U);
                canonical = "Coif";
                break;
            }
            case IRON: {
                item = new ItemStack((Item)Items.field_151028_Y);
                canonical = "Sallet";
                break;
            }
            case GOLD: {
                item = new ItemStack((Item)Items.field_151169_ag);
                canonical = "Crown";
                break;
            }
            case DIAMOND: {
                item = new ItemStack((Item)Items.field_151161_ac);
                canonical = "Helm";
                break;
            }
            default: {
                item = new ItemStack((Item)Items.field_151024_Q);
            }
        }
        String suffix = "";
        if (random.nextInt(20) == 0) {
            item.func_77966_a(Enchant.getEnchant(Enchant.PROTECTION), ItemSpecialty.getProtectionLevel(quality, random));
            item.func_77966_a(Enchant.getEnchant(Enchant.RESPIRATION), 3);
            item.func_77966_a(Enchant.getEnchant(Enchant.AQUAAFFINITY), 1);
            suffix = "of Diving";
        } else if (random.nextInt(3) == 0) {
            item.func_77966_a(Enchant.getEnchant(Enchant.PROJECTILEPROTECTION), ItemSpecialty.getProtectionLevel(quality, random));
            suffix = "of Deflection";
        } else {
            item.func_77966_a(Enchant.getEnchant(Enchant.PROTECTION), ItemSpecialty.getProtectionLevel(quality, random));
            suffix = "of Defense";
        }
        return ItemSpecialty.commonArmorThingy(random, quality, item, canonical, suffix);
    }

    private static ItemStack commonArmorThingy(Random random, Quality quality, ItemStack item, String canonical, String suffix) {
        String name = ItemSpecialty.getArmourPrefix(quality) + " " + canonical + " " + suffix;
        name = ItemSpecialty.rollUnbreaking(item, name, random);
        name = ItemSpecialty.rollMending(item, name, random);
        item.func_151001_c(name);
        return item;
    }

    private static ItemStack getBoots(Random random, Quality quality) {
        ItemStack item;
        String canonical = "";
        switch (quality) {
            case WOOD: {
                item = new ItemStack((Item)Items.field_151021_T);
                ItemArmour.dyeArmor(item, Color.random());
                canonical = "Shoes";
                break;
            }
            case STONE: {
                item = new ItemStack((Item)Items.field_151029_X);
                canonical = "Greaves";
                break;
            }
            case GOLD: 
            case IRON: {
                item = new ItemStack((Item)Items.field_151167_ab);
                canonical = "Sabatons";
                break;
            }
            case DIAMOND: {
                item = new ItemStack((Item)Items.field_151175_af);
                canonical = "Boots";
                break;
            }
            default: {
                item = new ItemStack((Item)Items.field_151021_T);
                canonical = "Shoes";
            }
        }
        String suffix = "";
        if (random.nextInt(10) == 0) {
            item.func_77966_a(Enchant.getEnchant(Enchant.BLASTPROTECTION), ItemSpecialty.getProtectionLevel(quality, random));
            suffix = "of Warding";
        } else if (random.nextInt(5) == 0) {
            item.func_77966_a(Enchant.getEnchant(Enchant.PROTECTION), ItemSpecialty.getProtectionLevel(quality, random));
            item.func_77966_a(Enchant.getEnchant(Enchant.FEATHERFALLING), quality == Quality.DIAMOND ? 4 : 1 + random.nextInt(3));
            suffix = "of Lightness";
        } else if (random.nextInt(3) == 0) {
            item.func_77966_a(Enchant.getEnchant(Enchant.PROJECTILEPROTECTION), ItemSpecialty.getProtectionLevel(quality, random));
            suffix = "of Deflection";
        } else {
            item.func_77966_a(Enchant.getEnchant(Enchant.PROTECTION), ItemSpecialty.getProtectionLevel(quality, random));
            suffix = "of Defense";
        }
        return ItemSpecialty.commonArmorThingy(random, quality, item, canonical, suffix);
    }

    private static ItemStack getLegs(Random random, Quality quality) {
        ItemStack item;
        String canonical = "";
        switch (quality) {
            case WOOD: {
                item = new ItemStack((Item)Items.field_151026_S);
                ItemArmour.dyeArmor(item, Color.random());
                canonical = "Pantaloons";
                break;
            }
            case STONE: {
                item = new ItemStack((Item)Items.field_151022_W);
                canonical = "Chausses";
                break;
            }
            case GOLD: 
            case IRON: {
                item = new ItemStack((Item)Items.field_151165_aa);
                canonical = "Leg-plates";
                break;
            }
            case DIAMOND: {
                item = new ItemStack((Item)Items.field_151173_ae);
                canonical = "Leggings";
                break;
            }
            default: {
                item = new ItemStack((Item)Items.field_151026_S);
            }
        }
        String suffix = "";
        if (random.nextInt(10) == 0) {
            item.func_77966_a(Enchant.getEnchant(Enchant.FIREPROTECTION), ItemSpecialty.getProtectionLevel(quality, random));
            suffix = "of Warding";
        } else if (random.nextInt(10) == 0) {
            item.func_77966_a(Enchant.getEnchant(Enchant.BLASTPROTECTION), ItemSpecialty.getProtectionLevel(quality, random));
            suffix = "of Integrity";
        } else if (random.nextInt(3) == 0) {
            item.func_77966_a(Enchant.getEnchant(Enchant.PROJECTILEPROTECTION), ItemSpecialty.getProtectionLevel(quality, random));
            suffix = "of Deflection";
        } else {
            item.func_77966_a(Enchant.getEnchant(Enchant.PROTECTION), ItemSpecialty.getProtectionLevel(quality, random));
            suffix = "of Defense";
        }
        return ItemSpecialty.commonArmorThingy(random, quality, item, canonical, suffix);
    }

    private static ItemStack getChest(Random random, Quality quality) {
        ItemStack item;
        String canonical = "";
        switch (quality) {
            case WOOD: {
                item = new ItemStack((Item)Items.field_151027_R);
                ItemArmour.dyeArmor(item, Color.random());
                canonical = "Tunic";
                break;
            }
            case STONE: {
                item = new ItemStack((Item)Items.field_151023_V);
                canonical = "Hauberk";
                break;
            }
            case GOLD: 
            case IRON: {
                item = new ItemStack((Item)Items.field_151030_Z);
                canonical = "Cuirass";
                break;
            }
            case DIAMOND: {
                item = new ItemStack((Item)Items.field_151163_ad);
                canonical = "Plate";
                break;
            }
            default: {
                item = new ItemStack((Item)Items.field_151027_R);
                canonical = "Tunic";
            }
        }
        String suffix = "";
        if (random.nextInt(10) == 0) {
            item.func_77966_a(Enchant.getEnchant(Enchant.FIREPROTECTION), ItemSpecialty.getProtectionLevel(quality, random));
            suffix = "of Flamewarding";
        } else if (random.nextInt(10) == 0) {
            item.func_77966_a(Enchant.getEnchant(Enchant.BLASTPROTECTION), ItemSpecialty.getProtectionLevel(quality, random));
            suffix = "of Integrity";
        } else if (random.nextInt(3) == 0) {
            item.func_77966_a(Enchant.getEnchant(Enchant.PROJECTILEPROTECTION), ItemSpecialty.getProtectionLevel(quality, random));
            suffix = "of Deflection";
        } else {
            item.func_77966_a(Enchant.getEnchant(Enchant.PROTECTION), ItemSpecialty.getProtectionLevel(quality, random));
            suffix = "of Defense";
        }
        return ItemSpecialty.commonArmorThingy(random, quality, item, canonical, suffix);
    }

    private static int getProtectionLevel(Quality quality, Random rand) {
        int value = 1;
        switch (quality) {
            case WOOD: {
                if (rand.nextInt(3) != 0) break;
                ++value;
                break;
            }
            case STONE: {
                if (!rand.nextBoolean()) break;
                ++value;
                break;
            }
            case GOLD: 
            case IRON: {
                value += rand.nextInt(3);
                break;
            }
            case DIAMOND: {
                value += 2 + rand.nextInt(2);
            }
        }
        return value;
    }

    private static String getArmourPrefix(Quality quality) {
        switch (quality) {
            case WOOD: {
                return "Surplus";
            }
            case STONE: {
                return "Riveted";
            }
            case IRON: {
                return "Gothic";
            }
            case GOLD: {
                return "Jewelled";
            }
            case DIAMOND: {
                return "Crystal";
            }
        }
        return "Strange";
    }

    @Override
    public ItemStack get(Random rand) {
        Equipment t = this.type == null ? Equipment.values()[rand.nextInt(Equipment.values().length)] : this.type;
        Quality q = this.quality == null ? Quality.get(rand, this.level, t) : this.quality;
        return ItemSpecialty.getRandomItem(t, rand, q);
    }

    @Override
    public ItemStack getLootItem(Random rand, int level) {
        Quality q;
        switch (level) {
            case 0: {
                q = Quality.WOOD;
                break;
            }
            case 1: {
                q = Quality.STONE;
                break;
            }
            case 2: {
                q = Quality.IRON;
                break;
            }
            case 3: {
                q = Quality.GOLD;
                break;
            }
            case 4: {
                q = Quality.DIAMOND;
                break;
            }
            default: {
                q = Quality.WOOD;
            }
        }
        return ItemSpecialty.getRandomItem(Equipment.values()[rand.nextInt(Equipment.values().length)], rand, q);
    }
}

