/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.worldgen.spawners;

import com.github.fnar.minecraft.EffectType;
import greymerk.roguelike.config.RogueConfig;
import greymerk.roguelike.treasure.loot.Equipment;
import greymerk.roguelike.treasure.loot.Quality;
import java.util.Random;
import java.util.stream.IntStream;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagList;

public class SpawnPotential {
    private final String name;
    private final int weight;
    private final boolean equip;
    private final NBTTagCompound entityNbt;

    public SpawnPotential(String name, boolean equip, int weight, NBTTagCompound entityNbt) {
        this.name = name;
        this.equip = equip;
        this.weight = weight;
        this.entityNbt = entityNbt;
    }

    public NBTTagList getSpawnPotentials(Random random, int level) {
        NBTTagList potentials = new NBTTagList();
        if (this.equip) {
            IntStream.range(0, 12).forEach(i -> potentials.func_74742_a((NBTBase)this.buildSpawnPotentialNbt(this.createEquippedEntityNbt(random, level))));
        } else {
            potentials.func_74742_a((NBTBase)this.createSpawnPotentialNbt(level));
        }
        return potentials;
    }

    private NBTTagCompound createSpawnPotentialNbt(int level) {
        NBTTagCompound entityNbt = this.createEntityNbt(level);
        return this.buildSpawnPotentialNbt(entityNbt);
    }

    private NBTTagCompound createEquippedEntityNbt(Random random, int level) {
        NBTTagCompound entityNbt = this.createEntityNbt(level);
        this.equipHands(entityNbt, random, level);
        this.equipArmour(entityNbt, random, level);
        return entityNbt;
    }

    private NBTTagCompound createEntityNbt(int level) {
        NBTTagCompound entityNbt = this.entityNbt.func_74737_b();
        this.setRoguelikeNbtData(level, this.name, entityNbt);
        return entityNbt;
    }

    private void equipHands(NBTTagCompound entityNbt, Random random, int level) {
        this.equipHands(entityNbt, this.getMainhand(random, level), this.getOffHand(random));
    }

    private String getMainhand(Random random, int level) {
        return random.nextBoolean() ? this.chooseRandomWeapon(random).getMinecraftName(Quality.getWeaponQuality(random, level)) : (random.nextBoolean() ? this.chooseRandomTool(random).getMinecraftName(Quality.getToolQuality(random, level)) : null);
    }

    private Equipment chooseRandomWeapon(Random random) {
        return random.nextInt(5) == 0 ? Equipment.BOW : Equipment.SWORD;
    }

    private Equipment chooseRandomTool(Random random) {
        return random.nextBoolean() ? (random.nextBoolean() ? Equipment.PICK : Equipment.SHOVEL) : Equipment.AXE;
    }

    private String getOffHand(Random random) {
        return random.nextBoolean() ? "minecraft:shield" : null;
    }

    private NBTTagCompound buildSpawnPotentialNbt(NBTTagCompound entityNbt) {
        NBTTagCompound spawnPotentialNbt = new NBTTagCompound();
        spawnPotentialNbt.func_74782_a("Entity", (NBTBase)entityNbt);
        spawnPotentialNbt.func_74768_a("Weight", this.weight);
        return spawnPotentialNbt;
    }

    private void equipHands(NBTTagCompound entityNbt, String mainHand, String offhand) {
        NBTTagList hands = new NBTTagList();
        hands.func_74742_a((NBTBase)this.getItem(mainHand));
        hands.func_74742_a((NBTBase)this.getItem(offhand));
        entityNbt.func_74782_a("HandItems", (NBTBase)hands);
    }

    private void equipArmour(NBTTagCompound entityNbt, Random rand, int level) {
        NBTTagList armour = new NBTTagList();
        armour.func_74742_a((NBTBase)this.getItem(Equipment.FEET.getMinecraftName(Quality.getArmourQuality(rand, level))));
        armour.func_74742_a((NBTBase)this.getItem(Equipment.LEGS.getMinecraftName(Quality.getArmourQuality(rand, level))));
        armour.func_74742_a((NBTBase)this.getItem(Equipment.CHEST.getMinecraftName(Quality.getArmourQuality(rand, level))));
        armour.func_74742_a((NBTBase)this.getItem(Equipment.HELMET.getMinecraftName(Quality.getArmourQuality(rand, level))));
        entityNbt.func_74782_a("ArmorItems", (NBTBase)armour);
    }

    private NBTTagCompound getItem(String itemName) {
        NBTTagCompound item = new NBTTagCompound();
        if (itemName == null) {
            return item;
        }
        item.func_74778_a("id", itemName);
        item.func_74768_a("Count", 1);
        return item;
    }

    private void setRoguelikeNbtData(int level, String type, NBTTagCompound entityNbt) {
        entityNbt.func_74778_a("id", type);
        if (this.areRoguelikeSpawnersEnabled()) {
            this.tagEntityAsFromRoguelikeSpawner(level, entityNbt);
        }
        this.setLootingRateTags(entityNbt);
    }

    private boolean areRoguelikeSpawnersEnabled() {
        return RogueConfig.ROGUESPAWNERS.getBoolean() && this.equip;
    }

    private void tagEntityAsFromRoguelikeSpawner(int level, NBTTagCompound entityNbt) {
        NBTTagList activeEffects = new NBTTagList();
        activeEffects.func_74742_a((NBTBase)this.getMiningFatigueBuff(level));
        entityNbt.func_74782_a("ActiveEffects", (NBTBase)activeEffects);
    }

    private NBTTagCompound getMiningFatigueBuff(int level) {
        NBTTagCompound buff = new NBTTagCompound();
        buff.func_74774_a("Id", (byte)EffectType.FATIGUE.getEffectID());
        buff.func_74774_a("Amplifier", (byte)level);
        buff.func_74768_a("Duration", 10);
        buff.func_74774_a("Ambient", (byte)0);
        return buff;
    }

    private void setLootingRateTags(NBTTagCompound entityNbt) {
        float lootingChance = (float)RogueConfig.LOOTING.getDouble();
        NBTTagList handDropChances = new NBTTagList();
        NBTTagFloat mainHandDropChance = new NBTTagFloat(lootingChance);
        NBTTagFloat offHandDropChance = new NBTTagFloat(lootingChance);
        handDropChances.func_74742_a((NBTBase)mainHandDropChance);
        handDropChances.func_74742_a((NBTBase)offHandDropChance);
        entityNbt.func_74782_a("HandDropChances", (NBTBase)handDropChances);
        NBTTagList armorDropChances = new NBTTagList();
        NBTTagFloat feetDropChance = new NBTTagFloat(lootingChance);
        NBTTagFloat legsDropChance = new NBTTagFloat(lootingChance);
        NBTTagFloat chestDropChance = new NBTTagFloat(lootingChance);
        NBTTagFloat headDropChance = new NBTTagFloat(lootingChance);
        armorDropChances.func_74742_a((NBTBase)feetDropChance);
        armorDropChances.func_74742_a((NBTBase)legsDropChance);
        armorDropChances.func_74742_a((NBTBase)chestDropChance);
        armorDropChances.func_74742_a((NBTBase)headDropChance);
        entityNbt.func_74782_a("ArmorDropChances", (NBTBase)armorDropChances);
    }
}

